# 画面設計書 336-マイ休暇編集

## 概要

本ドキュメントは、休暇管理モジュールにおける自分の休暇申請編集画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：従業員が自分自身の休暇申請内容を修正するための画面です。申請した日付範囲、休暇タイプ、説明などを変更することができます。ただし、承認済みまたは却下済みの申請は編集できないよう制御されています。

**画面へのアクセス方法**：マイ休暇一覧画面または詳細画面から「編集」アクションをクリックすることでアクセスできます。URLパス: `/my-time/my-time-offs/{record}/edit`

**主要な操作・処理内容**：
1. 既存の休暇申請情報を読み込み、フォームに表示
2. 休暇タイプを変更
3. 申請開始日・終了日を変更
4. 半日休暇設定を変更
5. 説明を変更
6. 「保存」ボタンで変更内容を更新

**画面遷移**：マイ休暇一覧画面または詳細画面から遷移し、保存完了後は詳細画面へリダイレクトされます。ヘッダーアクションからチャット機能、詳細表示画面への遷移、削除処理も可能です。

**権限による表示制御**：ログインユーザー自身の休暇申請のみ編集可能です。承認済み（validate_one, validate_two）または却下済み（refuse）のステータスの申請は編集が制限されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-009 | 自分の休暇申請 | 主機能 | 休暇申請の編集・更新 |
| FN-TOFF-005 | 休暇タイプ選択 | 補助機能 | 休暇タイプの変更 |
| FN-TOFF-006 | 期間計算 | 補助機能 | 営業日ベースの期間再計算 |
| FN-TOFF-007 | 重複チェック | 補助機能 | 既存申請との重複検証（自身を除く） |
| FN-TOFF-008 | 残日数チェック | 補助機能 | 休暇残日数の検証 |
| FN-TOFF-010 | チャット機能 | 補助機能 | 申請に関するコメント・議論 |

## 画面種別

編集画面

## URL/ルーティング

`/my-time/my-time-offs/{record}/edit`

## 画面構成

- ヘッダーセクション
  - ページタイトル（レコード名）
  - ヘッダーアクション: チャット、詳細表示ボタン、削除ボタン
- ナビゲーションタブ（レコードナビゲーション）
- メインコンテンツ（セクション形式）
  - 休暇タイプ選択
  - 日付範囲選択（2カラム）
  - 半日休暇トグル
  - 期間選択（半日休暇時）
  - 期間表示（自動計算）
  - 説明入力
- フッター: 保存ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 最大桁数 | デフォルト値 | バリデーション |
|--------|--------|----------|------|----------|----------|--------------|----------------|
| 休暇タイプ | holiday_status_id | integer | ○ | セレクト | - | 既存値 | time_off_leave_typesテーブルに存在するID |
| 申請開始日 | request_date_from | date | ○ | 日付ピッカー | - | 既存値 | 日付形式 |
| 申請終了日 | request_date_to | date | ○* | 日付ピッカー | - | 既存値 | 開始日以降、半日休暇時は不要 |
| 半日休暇 | request_unit_half | boolean | - | トグル | - | 既存値 | - |
| 期間 | request_date_from_period | enum | ○* | セレクト | - | 既存値 | 半日休暇時のみ必須 |
| 説明 | private_name | text | - | テキストエリア | - | 既存値 | - |

*: 条件付き必須

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| 期間情報 | duration_info | string | テキスト | 自動計算されたX営業日を表示 |

## イベント仕様

### 1-保存ボタン押下

フォーム入力内容のバリデーションを実行し、以下の処理を行います：
1. 従業員情報の確認
2. 重複チェック（自レコードを除く）
3. 休暇残日数チェック
4. 営業日計算
5. time_off_leavesテーブルをUPDATE
6. 保存成功後、詳細画面へリダイレクト

### 2-チャットボタン押下

ヘッダーアクションの「チャット」ボタンをクリックすると、チャット/コメント機能が表示されます。申請に関する質問や確認事項をコメントとして残すことができます。

### 3-詳細表示ボタン押下

ヘッダーアクションの「詳細表示」ボタンをクリックすると、現在編集中の休暇申請の詳細画面へ遷移します。

### 4-削除ボタン押下

ヘッダーアクションの「削除」ボタンをクリックすると、確認ダイアログが表示されます。確認後、該当レコードを削除し、一覧画面へリダイレクトします。

### 5-日付・半日休暇トグル変更

作成画面と同様に、期間情報が自動計算されて表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | time_off_leaves | UPDATE | 休暇申請の更新 |
| 保存ボタン押下 | time_off_leave_allocations | SELECT | 休暇残日数の確認 |
| 削除ボタン押下 | time_off_leaves | DELETE | 休暇申請の削除 |

### テーブル別更新項目詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | holiday_status_id | フォーム選択値 | 休暇タイプID |
| UPDATE | request_date_from | フォーム入力値 | 申請開始日 |
| UPDATE | request_date_to | フォーム入力値 | 申請終了日 |
| UPDATE | request_unit_half | フォーム選択値 | 半日休暇フラグ |
| UPDATE | request_date_from_period | フォーム選択値 | 期間 |
| UPDATE | private_name | フォーム入力値 | 説明 |
| UPDATE | date_from | フォーム入力値 | 開始日 |
| UPDATE | date_to | フォーム入力値 | 終了日 |
| UPDATE | duration_display | 計算値 | 期間表示文字列 |
| UPDATE | number_of_days | 計算値 | 営業日数 |
| UPDATE | state | 'confirm' | ステータスをリセット |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | id | 選択されたレコードID | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| notification.title | 成功 | 休暇申請が正常に更新されました | 保存成功時 |
| notification.body | 成功 | 休暇申請の更新が完了しました | 保存成功時 |
| header-actions.delete.notification.title | 成功 | 休暇申請が削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | 休暇申請の削除が完了しました | 削除成功時 |
| notification.overlap.title | エラー | 休暇申請が重複しています | 重複検出時 |
| notification.overlap.body | エラー | 指定された期間に既に休暇申請があります | 重複検出時 |
| notification.leave_request_denied_insufficient_balance.title | エラー | 休暇残日数が不足しています | 残日数不足時 |
| notification.leave_request_denied_insufficient_balance.body | エラー | 利用可能残日数: {available_balance}日、申請日数: {requested_days}日 | 残日数不足時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| レコードが存在しない | 404エラーページ表示 | レコードが見つかりません |
| 編集不可ステータス | フォームを無効化または403エラー | この申請は編集できません |
| 期間が重複 | 処理中断、エラー通知表示 | 指定された期間に既に休暇申請があります |
| 休暇残日数不足 | 処理中断、エラー通知表示 | 残日数が不足しています |
| 必須項目未入力 | フォームバリデーションエラー表示 | 該当項目に必須エラー表示 |
| データベース更新失敗 | トランザクションロールバック | システムエラー通知 |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装されています
- HasRecordNavigationTabsトレイトを使用してレコードナビゲーションを提供します
- TimeOffHelperトレイトを使用して、期間計算・重複チェック・残日数チェックを行います
- ChatterActionが統合されており、申請に関するコメント機能が利用可能です
- 重複チェックでは自レコードを除外して判定します（excludeRecordId使用）
- 承認済みまたは却下済みのステータスの場合、編集が制限される場合があります（isEditableStateメソッド）
