# 画面設計書 337-マイ休暇詳細

## 概要

本ドキュメントは、休暇管理モジュールにおける自分の休暇申請詳細表示画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：従業員が自分自身の休暇申請の詳細情報を確認するための画面です。申請した休暇タイプ、日付範囲、期間、ステータスなどの詳細を閲覧できます。また、必要に応じて編集画面への遷移や申請の削除も可能です。

**画面へのアクセス方法**：マイ休暇一覧画面から対象レコードをクリック、またはアクションメニューの「詳細表示」を選択することでアクセスできます。URLパス: `/my-time/my-time-offs/{record}`

**主要な操作・処理内容**：
1. 選択された休暇申請の詳細情報を読み取り専用で表示
2. 休暇タイプ、半日休暇設定、日付範囲を確認
3. 申請日数（期間）を確認
4. 説明を確認
5. 添付ファイルがある場合は画像として表示

**画面遷移**：マイ休暇一覧画面から遷移します。ヘッダーアクションからチャット機能、編集画面への遷移、削除処理も可能です。

**権限による表示制御**：ログインユーザー自身の休暇申請のみ表示可能です。編集・削除アクションはステータスに応じて表示/非表示が制御される場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-009 | 自分の休暇申請 | 主機能 | 休暇申請の詳細表示 |
| FN-TOFF-003 | 休暇申請編集 | 遷移先機能 | 編集画面への遷移 |
| FN-TOFF-010 | チャット機能 | 補助機能 | 申請に関するコメント・議論 |

## 画面種別

詳細画面

## URL/ルーティング

`/my-time/my-time-offs/{record}`

## 画面構成

- ヘッダーセクション
  - ページタイトル（レコード名）
  - ヘッダーアクション: チャット、編集ボタン、削除ボタン
- ナビゲーションタブ（レコードナビゲーション）
- メインコンテンツ（セクション形式）
  - 休暇申請情報グループ

## 入出力項目

該当なし（詳細表示画面のため入力なし）

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン | 表示条件 |
|--------|--------|----------|----------|---------|---------|
| 休暇タイプ | holidayStatus.name | string | テキスト | heroicon-o-calendar | 常時 |
| 半日休暇 | request_unit_half | boolean | Yes/No | heroicon-o-clock | 常時 |
| 申請開始日 | request_date_from | date | 日付 | heroicon-o-calendar | 常時 |
| 申請終了日 | request_date_to | date | 日付 | heroicon-o-calendar | 半日休暇でない場合 |
| 期間 | request_date_from_period | enum | ラベル | heroicon-o-sun | 半日休暇の場合 |
| 説明 | private_name | text | テキスト | heroicon-o-document-text | 常時 |
| 申請日数 | duration_display | string | X日 | heroicon-o-calendar-days | 常時 |
| 添付ファイル | attachment | image | 画像 | - | support_documentが有効な休暇タイプ |

## イベント仕様

### 1-チャットボタン押下

ヘッダーアクションの「チャット」ボタンをクリックすると、チャット/コメント機能が表示されます。申請に関する質問や確認事項をコメントとして残すことができます。

### 2-編集ボタン押下

ヘッダーアクションの「編集」ボタンをクリックすると、現在表示中の休暇申請の編集画面へ遷移します。

### 3-削除ボタン押下

ヘッダーアクションの「削除」ボタンをクリックすると、確認ダイアログが表示されます。確認後、該当レコードを削除し、一覧画面へリダイレクトします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | time_off_leaves | SELECT | 休暇申請情報の取得 |
| 画面表示 | time_off_leave_types | SELECT | 休暇タイプ情報の取得（リレーション） |
| 削除ボタン押下 | time_off_leaves | DELETE | 休暇申請の削除 |

### テーブル別更新項目詳細

#### time_off_leaves（参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URLパラメータのrecord | 主キー |
| SELECT | holiday_status_id | - | リレーション取得 |
| SELECT | request_unit_half | - | 半日休暇フラグ |
| SELECT | request_date_from | - | 日付表示 |
| SELECT | request_date_to | - | 日付表示 |
| SELECT | request_date_from_period | - | 期間（半日休暇時） |
| SELECT | private_name | - | 説明 |
| SELECT | duration_display | - | 期間表示 |
| SELECT | attachment | - | 添付ファイル |
| DELETE | id | 選択されたレコードID | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| header-actions.delete.notification.title | 成功 | 休暇申請が削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | 休暇申請の削除が完了しました | 削除成功時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| レコードが存在しない | 404エラーページ表示 | レコードが見つかりません |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| データベースエラー | エラー通知を表示 | システムエラーが発生しました |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装されています
- HasRecordNavigationTabsトレイトを使用してレコードナビゲーションを提供します
- ChatterActionが統合されており、申請に関するコメント機能が利用可能です
- ヘッダーアクションにChatterAction、EditAction、DeleteActionが配置されています
- 申請日数は半日休暇の場合は「0.5日」、それ以外は開始日から終了日までの日数を計算して表示されます
- 添付ファイルは休暇タイプのsupport_document設定がtrueの場合のみ表示されます
- infolist定義はMyTimeOffResourceで定義されており、TimeOffResourceのものを参照しています
