# 画面設計書 338-マイ割当一覧

## 概要

本ドキュメントは、休暇管理モジュールにおける自分の休暇割当一覧画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：休暇割当（Allocation）は、従業員に対して特定の休暇タイプの取得可能日数を割り当てる機能です。本画面は、ログインユーザー自身に割り当てられた休暇の一覧を確認するためのものです。従業員は自分に付与された有給休暇、特別休暇などの割当状況を把握し、残日数を確認することができます。

**画面へのアクセス方法**：メインナビゲーションから「休暇」モジュール → 「マイ休暇」クラスターの「マイ割当」メニューをクリックすることでアクセスできます。URLパス: `/my-time/my-allocations`

**主要な操作・処理内容**：
1. 自分の休暇割当一覧をテーブル形式で表示
2. 休暇タイプ、割当日数、割当タイプ、ステータスで検索・ソート
3. グループ化機能（従業員名、休暇タイプ、割当タイプ、ステータス、開始日）
4. 新規割当申請の作成
5. 個別レコードの詳細表示・編集・削除
6. 承認・却下アクション
7. 一括削除

**画面遷移**：新規作成ボタンから作成画面へ、一覧のレコードクリックまたはアクションから詳細画面・編集画面へ遷移します。

**権限による表示制御**：ログインユーザー自身の割当のみが表示されます（employee_idでフィルタ）。承認・却下アクションは適切なステータスの場合に表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-011 | 自分の休暇割当 | 主機能 | 割当一覧の表示・検索・フィルタ |
| FN-TOFF-012 | 割当申請作成 | 遷移先機能 | 新規割当申請の作成 |
| FN-TOFF-013 | 割当申請編集 | 遷移先機能 | 割当申請の編集 |
| FN-TOFF-014 | 割当申請表示 | 遷移先機能 | 割当申請の詳細表示 |

## 画面種別

一覧画面

## URL/ルーティング

`/my-time/my-allocations`

## 画面構成

- ヘッダーセクション
  - ページタイトル「マイ割当」
  - ヘッダーアクション: 作成ボタン
- フィルター・検索バー
- グループ化オプション
- テーブル（データ一覧）
- ページネーション
- 一括アクションツールバー

## 入出力項目

該当なし（一覧画面のため入力なし、検索・フィルタは標準機能）

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 |
|--------|--------|----------|----------|--------|------|
| 休暇タイプ | holidayStatus.name | string | テキスト | ○ | ○ |
| 割当日数 | number_of_days | integer | 数値 | ○ | ○ |
| 割当タイプ | allocation_type | enum | ラベル | ○ | ○ |
| ステータス | state | enum | バッジ | ○ | ○ |

## イベント仕様

### 1-作成ボタン押下

ヘッダーの「作成」ボタンをクリックすると、新規割当申請作成画面へ遷移します。

### 2-レコード行クリック

一覧のレコード行をクリックすると、該当割当の詳細画面へ遷移します。

### 3-アクションメニュー

各レコードのアクションメニューから以下の操作が可能です：
- **承認**: ステータスを「承認済み」（validate_two）に更新（ステータスが「承認済み」以外の場合に表示）
- **却下**: ステータスを「却下」（refuse）に更新（ステータスが「却下」以外の場合に表示）
- **詳細表示**: 詳細画面へ遷移
- **編集**: 編集画面へ遷移
- **削除**: 確認後、レコードを削除

### 4-一括削除

チェックボックスで選択した複数レコードを一括で削除します。

### 5-グループ化

テーブルのグループ化オプションから以下の項目でグループ化が可能です：
- 従業員名
- 休暇タイプ
- 割当タイプ
- ステータス
- 開始日

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | time_off_leave_allocations | SELECT | 自分の割当一覧を取得 |
| 画面表示 | time_off_leave_types | SELECT | 休暇タイプ情報を取得（リレーション） |
| 承認アクション | time_off_leave_allocations | UPDATE | ステータスを「承認済み」に更新 |
| 却下アクション | time_off_leave_allocations | UPDATE | ステータスを「却下」に更新 |
| 削除アクション | time_off_leave_allocations | DELETE | 割当レコードを削除 |
| 一括削除 | time_off_leave_allocations | DELETE | 複数の割当レコードを削除 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | employee_id = ログインユーザーの従業員ID | 自分のデータのみ取得 |
| UPDATE(承認時) | state | 'validate_two' | State::VALIDATE_TWO |
| UPDATE(却下時) | state | 'refuse' | State::REFUSE |
| DELETE | id | 選択されたレコードID | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| table.actions.approve.notification.title | 成功 | 割当が承認されました | 承認成功時 |
| table.actions.approve.notification.body | 成功 | 割当の承認が完了しました | 承認成功時 |
| table.actions.refused.notification.title | 成功 | 割当が却下されました | 却下成功時 |
| table.actions.refused.notification.body | 成功 | 割当の却下が完了しました | 却下成功時 |
| table.actions.delete.notification.title | 成功 | 割当が削除されました | 削除成功時 |
| table.actions.delete.notification.body | 成功 | 割当の削除が完了しました | 削除成功時 |
| table.bulk-actions.delete.notification.title | 成功 | 選択した割当が削除されました | 一括削除成功時 |
| table.bulk-actions.delete.notification.body | 成功 | 選択した割当の削除が完了しました | 一括削除成功時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| データが存在しない | 空の一覧を表示 | データがありません |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 従業員情報未登録 | 空の一覧を表示 | 従業員情報が登録されていません |
| データベースエラー | エラー通知を表示 | システムエラーが発生しました |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装されています
- クエリはmodifyQueryUsingでログインユーザーの従業員IDにフィルタリングされます
- 割当タイプ（allocation_type）はAllocationType Enumで管理されます（regular, accrual等）
- ステータス（state）はState Enumで管理され、バッジ形式で色分け表示されます
- 承認・却下アクションは現在のステータスに応じて表示/非表示が制御されます
- MyTimeクラスターに属しており、サブナビゲーションが表示されます
- LeaveAllocationモデルを使用しています
