# 画面設計書 339-マイ割当作成

## 概要

本ドキュメントは、休暇管理モジュールにおける自分の休暇割当申請作成画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：従業員が自分自身の休暇割当（追加の有給休暇日数など）を申請するための画面です。休暇タイプを選択し、割当タイプ（通常/発生ベース）、有効期間、日数を指定して申請を行います。申請後は承認フローに従って管理者による承認が行われます。

**画面へのアクセス方法**：マイ割当一覧画面の「作成」ボタンをクリックすることでアクセスできます。URLパス: `/my-time/my-allocations/create`

**主要な操作・処理内容**：
1. 割当名（Description）を入力
2. 休暇タイプを選択
3. 割当タイプ（通常/発生ベース）を選択
4. 有効期間（開始日・終了日）を設定
5. 割当日数を入力
6. 理由を入力（任意）
7. 「作成」ボタンで割当申請を保存

**画面遷移**：マイ割当一覧画面から遷移し、作成完了後は作成された割当の詳細画面へリダイレクトされます。

**権限による表示制御**：ログインユーザーとして従業員情報が登録されている場合のみ申請が可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-011 | 自分の休暇割当 | 主機能 | 新規割当申請の作成 |
| FN-TOFF-005 | 休暇タイプ選択 | 補助機能 | 休暇タイプの選択 |

## 画面種別

登録画面

## URL/ルーティング

`/my-time/my-allocations/create`

## 画面構成

- ヘッダーセクション: ページタイトル「割当作成」
- サブナビゲーション: MyTimeクラスターのナビゲーション
- メインコンテンツ
  - 進捗ステッパー（ステータス表示）
  - 申請情報セクション（2カラム）
    - 割当名
    - 休暇タイプ選択
    - 割当タイプ選択
    - 有効期間フィールドセット
    - 割当日数
    - 理由
- フッター: 作成ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 最大桁数 | デフォルト値 | バリデーション |
|--------|--------|----------|------|----------|----------|--------------|----------------|
| 割当名 | name | string | ○ | テキスト | - | - | 必須 |
| 休暇タイプ | holiday_status_id | integer | ○ | セレクト | - | - | time_off_leave_typesテーブルに存在するID |
| 割当タイプ | allocation_type | enum | ○ | ラジオ | - | regular | AllocationType Enum値 |
| 開始日 | date_from | date | ○ | 日付ピッカー | - | 現在日 | 日付形式 |
| 終了日 | date_to | date | - | 日付ピッカー | - | - | 開始日以降 |
| 割当日数 | number_of_days | decimal | ○ | 数値 | - | 0 | 0以上、99999999999以下 |
| 理由 | notes | text | - | リッチエディタ | - | - | - |

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| ステータス | state | enum | 進捗ステッパー | 確認待ち→承認済み |

## イベント仕様

### 1-作成ボタン押下

フォーム入力内容のバリデーションを実行し、以下の処理を行います：
1. 従業員情報の取得（ログインユーザーから）
2. 従業員が存在しない場合は警告通知を表示して処理中断
3. employee_idを自動設定
4. time_off_leave_allocationsテーブルへINSERT
5. ステータスは'confirm'（確認待ち）として登録
6. 作成成功後、詳細画面へリダイレクト

### 2-サブナビゲーション表示

画面表示時にMyTimeクラスターのナビゲーションアイテムを生成して表示します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | time_off_leave_allocations | INSERT | 新規割当申請の登録 |
| 作成ボタン押下 | employees | SELECT | 従業員情報の確認 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 割当名 |
| INSERT | holiday_status_id | フォーム選択値 | 休暇タイプID |
| INSERT | allocation_type | フォーム選択値 | 割当タイプ |
| INSERT | date_from | フォーム入力値 | 開始日 |
| INSERT | date_to | フォーム入力値 | 終了日（任意） |
| INSERT | number_of_days | フォーム入力値 | 割当日数 |
| INSERT | notes | フォーム入力値 | 理由 |
| INSERT | employee_id | ログインユーザーの従業員ID | 自動設定 |
| INSERT | state | 'confirm' | State::CONFIRM |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| notification.success.title | 成功 | 割当が正常に作成されました | 作成成功時 |
| notification.success.body | 成功 | 割当の作成が完了しました | 作成成功時 |
| notification.warning.title | 警告 | 従業員情報がありません | 従業員未登録時 |
| notification.warning.body | 警告 | 従業員として登録されていないため、割当を作成できません | 従業員未登録時 |
| validation.required | エラー | この項目は必須です | 必須項目未入力時 |
| validation.min | エラー | 0以上の値を入力してください | 負の値入力時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| 従業員情報未登録 | 処理中断（halt）、警告通知表示 | 従業員として登録されていないため、割当を作成できません |
| 必須項目未入力 | フォームバリデーションエラー表示 | 該当項目に必須エラー表示 |
| データベース登録失敗 | トランザクションロールバック | システムエラー通知 |

## 備考

- 本画面はFilament PHPのCreateRecordページを継承して実装されています
- ProgressStepperコンポーネントを使用してステータスの進捗を視覚化しています
- 割当タイプはRadioコンポーネントで選択します（regular: 通常、accrual: 発生ベース）
- 有効期間はFieldsetでグループ化されています
- 開始日のデフォルト値は現在日（now()）です
- 終了日は任意項目で、未設定の場合は無期限として扱われます
- 割当日数には「Days」という接尾辞が表示されます
- 理由入力にはRichEditorを使用しており、リッチテキスト形式での入力が可能です
- ステータスは作成時点では'confirm'（確認待ち）として登録され、承認後に'validate_two'に変更されます
