# 画面設計書 34-支払条件作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払条件作成画面の設計仕様を定義するものです。この画面は会計モジュールの支払条件リソースの一部として、新規支払条件の登録機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払条件は、請求書や見積書において顧客・仕入先との支払いに関する取り決めを定義するマスタデータです。この作成画面は、「Net 30（30日後支払い）」「2%/10 Net 30（10日以内に支払えば2%割引、そうでなければ30日後支払い）」などの新しい支払条件を登録するために使用されます。早期支払割引の設定も可能で、税金の減額処理方法も指定できます。

**画面へのアクセス方法**：支払条件一覧画面のヘッダーにある「新規作成」ボタンをクリックしてアクセスします。URLパターンは `/payment-terms/create` です。

**主要な操作・処理内容**：
1. 支払条件名の入力
2. 早期支払割引の有効化・設定（割引率、割引適用日数）
3. 税金減額方法の選択
4. 備考の入力（リッチテキスト）
5. 保存処理の実行

**画面遷移**：
- 遷移元：支払条件一覧画面
- 遷移先：保存成功時は支払条件詳細画面

**権限による表示制御**：システムの権限設定に基づき、支払条件リソースへの作成権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-023 | 支払条件管理 | 主機能 | 支払条件の新規作成 |
| - | 支払条件一覧 | 遷移元機能 | 一覧からの新規作成遷移 |
| - | 支払条件詳細 | 遷移先機能 | 作成成功後の遷移先 |

## 画面種別

登録

## URL/ルーティング

- パス: `/payment-terms/create`
- ルート名: `filament.accounts.resources.payment-terms.create`
- HTTPメソッド: GET（表示）, POST（登録）

## 画面構成

```
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  支払条件の作成                                                    |
+------------------------------------------------------------------+
| セクション                                                         |
| +--------------------------------------------------------------+ |
| | 支払条件名 *                                                   | |
| | [                                        ] (大きめフォント)    | |
| +--------------------------------------------------------------+ |
| |                                                                | |
| | □ 早期割引                                                     | |
| |                                                                | |
| | (早期割引有効時に表示)                                          | |
| | [  ]% [  ]日以内に支払った場合                                  | |
| |                                                                | |
| | 税金減額: [プルダウン▼]                                         | |
| |                                                                | |
| | 備考                                                           | |
| | +----------------------------------------------------------+ | |
| | |                                                          | | |
| | | [リッチテキストエディタ]                                   | | |
| | |                                                          | | |
| | +----------------------------------------------------------+ | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
| フッター                                                          |
|  [キャンセル] [作成]                                              |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 備考 |
|--------|--------|--------|----------|------|------|
| 支払条件名 | name | 入力 | string(255) | ○ | 大きめフォント表示 |
| 早期割引 | early_discount | 入力 | boolean | - | トグル、Live |
| 割引率 | discount_percentage | 入力 | numeric | ※ | 0-100%、早期割引有効時必須 |
| 割引日数 | discount_days | 入力 | integer | ※ | 0以上、早期割引有効時必須 |
| 税金減額 | early_pay_discount | 入力 | enum | - | EarlyPayDiscount列挙型 |
| 備考 | note | 入力 | text | - | リッチテキストエディタ |

※ 早期割引が有効な場合のみ必須

## 表示項目

作成画面のため、入出力項目と同様です。フォームフィールドとして表示されます。

## イベント仕様

### 1-作成ボタン押下

**トリガー**: フッターの「作成」ボタンをクリック

**処理フロー**:
1. フォームバリデーションの実行
2. `mutateFormDataBeforeCreate`メソッドによるデータ変換
   - `creator_id`に現在のログインユーザーIDを設定
   - `company_id`にユーザーのデフォルト会社IDを設定
3. データベースへのINSERT処理
4. PaymentDueTermの自動作成（モデルのbootメソッド）
5. 成功通知の表示
6. 支払条件詳細画面へのリダイレクト

### 2-早期割引トグル変更

**トリガー**: 早期割引トグルの切り替え（Live/Reactive）

**処理フロー**:
1. トグルがONの場合
   - 割引率フィールドを表示（必須）
   - 割引日数フィールドを表示（必須）
   - 税金減額フィールドを表示
2. トグルがOFFの場合
   - 上記フィールドを非表示

### 3-キャンセル

**トリガー**: キャンセルボタンのクリック、またはブラウザの戻る

**処理フロー**:
1. 入力内容を破棄
2. 支払条件一覧画面へ戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | accounts_payment_terms | INSERT | 支払条件の新規登録 |
| 作成ボタン押下 | accounts_payment_due_terms | INSERT | 支払期限条件の自動作成 |

### テーブル別更新項目詳細

#### accounts_payment_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | early_discount | フォーム入力値 | boolean |
| INSERT | discount_percentage | フォーム入力値 | 早期割引有効時 |
| INSERT | discount_days | フォーム入力値 | 早期割引有効時 |
| INSERT | early_pay_discount | フォーム入力値 | EarlyPayDiscount列挙型 |
| INSERT | note | フォーム入力値 | HTML形式 |
| INSERT | creator_id | Auth::user()->id | ログインユーザーID |
| INSERT | company_id | Auth::user()->default_company_id | ユーザーのデフォルト会社 |
| INSERT | sort | 自動採番 | Sortableトレイト |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

#### accounts_payment_due_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | value | DueTermValue::PERCENT->value | デフォルト値 |
| INSERT | value_amount | 100 | デフォルト値 |
| INSERT | delay_type | DelayType::DAYS_AFTER->value | デフォルト値 |
| INSERT | days_next_month | 10 | デフォルト値 |
| INSERT | nb_days | 0 | デフォルト値 |
| INSERT | payment_id | 親レコードのID | FK |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| notification.title | 成功 | 支払条件が作成されました | 作成成功時 |
| notification.body | 成功 | 支払条件が正常に作成されました | 作成成功時 |
| validation.required | エラー | このフィールドは必須です | 必須項目未入力時 |
| validation.max | エラー | 100%を超えることはできません | 割引率が100超過時 |
| validation.min | エラー | 0以上の値を入力してください | 負の値入力時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの保存中にエラーが発生しました |
| バリデーションエラー | フォームエラー表示 | 各フィールドに対応するエラーメッセージ |

## 備考

- 本画面はFilament PHPのCreateRecordページクラスを継承して実装されています
- 支払条件名フィールドは大きめのフォントスタイル（font-size: 1.5rem; height: 3rem）で表示されます
- 早期割引トグルはLive設定されており、切り替え時に関連フィールドが動的に表示/非表示されます
- 備考フィールドはRichEditorコンポーネントを使用しており、書式付きテキスト入力が可能です
- 支払条件作成時、PaymentTermモデルのbootメソッドにより支払期限条件（PaymentDueTerm）が自動的に1件作成されます
- EarlyPayDiscountの初期値は`INCLUDED`（税込み）です
