# 画面設計書 340-マイ割当編集

## 概要

本ドキュメントは、休暇管理モジュールにおける自分の休暇割当編集画面に関する設計書です。

### 本画面の処理概要

**業務上の目的・背景**：従業員が自分自身の休暇割当申請内容を修正するための画面です。割当名、休暇タイプ、割当タイプ、有効期間、日数などを変更することができます。申請後は再度承認フローを経る場合があります。

**画面へのアクセス方法**：マイ割当一覧画面または詳細画面から「編集」アクションをクリックすることでアクセスできます。URLパス: `/my-time/my-allocations/{record}/edit`

**主要な操作・処理内容**：
1. 既存の割当情報を読み込み、フォームに表示
2. 割当名を変更
3. 休暇タイプを変更
4. 割当タイプを変更
5. 有効期間を変更
6. 割当日数を変更
7. 理由を変更
8. 「保存」ボタンで変更内容を更新

**画面遷移**：マイ割当一覧画面または詳細画面から遷移し、保存完了後は詳細画面へリダイレクトされます。ヘッダーアクションからチャット機能、詳細表示画面への遷移、削除処理も可能です。

**権限による表示制御**：ログインユーザー自身の割当のみ編集可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-011 | 自分の休暇割当 | 主機能 | 割当申請の編集・更新 |
| FN-TOFF-005 | 休暇タイプ選択 | 補助機能 | 休暇タイプの変更 |
| FN-TOFF-010 | チャット機能 | 補助機能 | 申請に関するコメント・議論 |

## 画面種別

編集画面

## URL/ルーティング

`/my-time/my-allocations/{record}/edit`

## 画面構成

- ヘッダーセクション
  - ページタイトル（レコード名）
  - ヘッダーアクション: チャット、詳細表示ボタン、削除ボタン
- ナビゲーションタブ（レコードナビゲーション）
- メインコンテンツ
  - 進捗ステッパー（ステータス表示）
  - 申請情報セクション（2カラム）
    - 割当名
    - 休暇タイプ選択
    - 割当タイプ選択
    - 有効期間フィールドセット
    - 割当日数
    - 理由
- フッター: 保存ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 最大桁数 | デフォルト値 | バリデーション |
|--------|--------|----------|------|----------|----------|--------------|----------------|
| 割当名 | name | string | ○ | テキスト | - | 既存値 | 必須 |
| 休暇タイプ | holiday_status_id | integer | ○ | セレクト | - | 既存値 | time_off_leave_typesテーブルに存在するID |
| 割当タイプ | allocation_type | enum | ○ | ラジオ | - | 既存値 | AllocationType Enum値 |
| 開始日 | date_from | date | ○ | 日付ピッカー | - | 既存値 | 日付形式 |
| 終了日 | date_to | date | - | 日付ピッカー | - | 既存値 | 開始日以降 |
| 割当日数 | number_of_days | decimal | ○ | 数値 | - | 既存値 | 0以上、99999999999以下 |
| 理由 | notes | text | - | リッチエディタ | - | 既存値 | - |

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| ステータス | state | enum | 進捗ステッパー | 現在のステータスを表示 |

## イベント仕様

### 1-保存ボタン押下

フォーム入力内容のバリデーションを実行し、以下の処理を行います：
1. ログインユーザーの従業員情報を取得
2. employee_idを再設定（変更防止）
3. time_off_leave_allocationsテーブルをUPDATE
4. 保存成功後、詳細画面へリダイレクト

### 2-チャットボタン押下

ヘッダーアクションの「チャット」ボタンをクリックすると、チャット/コメント機能が表示されます。割当に関する質問や確認事項をコメントとして残すことができます。

### 3-詳細表示ボタン押下

ヘッダーアクションの「詳細表示」ボタンをクリックすると、現在編集中の割当の詳細画面へ遷移します。

### 4-削除ボタン押下

ヘッダーアクションの「削除」ボタンをクリックすると、確認ダイアログが表示されます。確認後、該当レコードを削除し、一覧画面へリダイレクトします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | time_off_leave_allocations | UPDATE | 割当申請の更新 |
| 削除ボタン押下 | time_off_leave_allocations | DELETE | 割当申請の削除 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 割当名 |
| UPDATE | holiday_status_id | フォーム選択値 | 休暇タイプID |
| UPDATE | allocation_type | フォーム選択値 | 割当タイプ |
| UPDATE | date_from | フォーム入力値 | 開始日 |
| UPDATE | date_to | フォーム入力値 | 終了日 |
| UPDATE | number_of_days | フォーム入力値 | 割当日数 |
| UPDATE | notes | フォーム入力値 | 理由 |
| UPDATE | employee_id | ログインユーザーの従業員ID | 再設定 |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| DELETE | id | 選択されたレコードID | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| notification.title | 成功 | 割当が正常に更新されました | 保存成功時 |
| notification.body | 成功 | 割当の更新が完了しました | 保存成功時 |
| header-actions.delete.notification.title | 成功 | 割当が削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | 割当の削除が完了しました | 削除成功時 |
| validation.required | エラー | この項目は必須です | 必須項目未入力時 |
| validation.min | エラー | 0以上の値を入力してください | 負の値入力時 |

## 例外処理

| 例外ケース | 対応処理 | 表示メッセージ |
|-----------|---------|---------------|
| レコードが存在しない | 404エラーページ表示 | レコードが見つかりません |
| 必須項目未入力 | フォームバリデーションエラー表示 | 該当項目に必須エラー表示 |
| データベース更新失敗 | トランザクションロールバック | システムエラー通知 |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装されています
- HasRecordNavigationTabsトレイトを使用してレコードナビゲーションを提供します
- ChatterActionが統合されており、割当に関するコメント機能が利用可能です
- ヘッダーアクションにChatterAction、ViewAction、DeleteActionが配置されています
- 保存時にemployee_idは現在ログイン中のユーザーの従業員IDで上書きされます（セキュリティ対策）
- ProgressStepperコンポーネントは編集画面では無効（disabled）状態で表示されます
- フォーム定義はMyAllocationResource::formで共通化されています
