# 画面設計書 341-マイ割当詳細

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおけるマイ割当詳細画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、ログインユーザー自身の休暇割当の詳細情報を表示するためのものです。従業員が自分に付与された休暇割当の状況を確認し、必要に応じて編集や削除の操作を行うことができます。

**業務上の目的・背景**：従業員が自身の休暇割当状況（有給休暇、特別休暇など）を確認することは、休暇計画を立てる上で重要です。この画面により、従業員は自分に付与された休暇日数、有効期間、承認状態などを一目で確認でき、適切な休暇取得計画を立てることが可能になります。

**画面へのアクセス方法**：Time Offモジュール → MyTime クラスター → マイ割当一覧画面から、特定の割当レコードをクリックすることでアクセスします。

**主要な操作・処理内容**：
1. 休暇割当の詳細情報（名称、休暇タイプ、割当タイプ、有効期間など）の閲覧
2. Chatter（コミュニケーション機能）を使用したコメント追加・履歴確認
3. 編集画面への遷移
4. 割当レコードの削除

**画面遷移**：
- 遷移元：マイ割当一覧画面（ListMyAllocations）
- 遷移先：マイ割当編集画面（EditMyAllocation）

**権限による表示制御**：ログインユーザー自身の割当データのみ表示されます（employee_idによるフィルタリング）。削除アクションは割当の状態によって制限される場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-010 | 自分の休暇割当 | 主機能 | 自分の休暇割当の詳細表示 |
| FN-TOFF-007 | 休暇割当編集 | 遷移先機能 | 編集ボタンからの遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

```
/time-off/my-time/my-allocations/{record}
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - Chatterアクション（コミュニケーション機能）
   - 編集ボタン（EditAction）
   - 削除ボタン（DeleteAction）

2. **レコードナビゲーションタブ**
   - HasRecordNavigationTabsトレイトによるタブナビゲーション

3. **メイン情報表示エリア**（3カラムレイアウト）
   - 左側（2カラム幅）
     - 割当詳細セクション
     - 有効期間セクション
   - 右側（1カラム幅）
     - 割当ステータスセクション

## 入出力項目

本画面は詳細表示画面のため、入力項目はありません。

## 表示項目

### 割当詳細セクション

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| name | 名称 | string | 割当の名称 |
| holidayStatus.name | 休暇タイプ | string | 関連する休暇タイプ名 |
| allocation_type | 割当タイプ | enum | Regular/Accrual等の割当タイプ |

### 有効期間セクション

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| date_from | 開始日 | date | 有効期間の開始日 |
| date_to | 終了日 | date | 有効期間の終了日 |
| notes | 理由 | text | 割当の理由・備考 |

### 割当ステータスセクション

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| number_of_days | 割当日数 | numeric | 割り当てられた日数 |
| state | ステータス | enum | 確認待ち/承認済み/拒否等の状態 |

## イベント仕様

### 1-Chatterアクション

**トリガー**: Chatterボタン押下

**処理内容**:
- Chatterモーダルを表示
- コメントの追加・履歴の確認が可能
- 関連リソース（MyAllocationResource）に紐づいたチャターを表示

### 2-編集アクション

**トリガー**: 編集ボタン押下

**処理内容**:
- マイ割当編集画面（EditMyAllocation）へ遷移
- 遷移先URL: `/time-off/my-time/my-allocations/{record}/edit`

### 3-削除アクション

**トリガー**: 削除ボタン押下

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示（title、body共にローカライズキーから取得）
4. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | time_off_leave_allocations | DELETE | 対象レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/my-time/resources/my-allocation/pages/view-allocation.header-actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/my-time/resources/my-allocation/pages/view-allocation.header-actions.delete.notification.body | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラーページを表示 |
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| 他ユーザーの割当を表示しようとした | employee_idフィルタにより表示されない |

## 備考

- この画面は `HasRecordNavigationTabs` トレイトを使用しており、関連レコード間のナビゲーションが可能
- 表示データはログインユーザーの従業員IDでフィルタリングされる
- 割当タイプ（allocation_type）とステータス（state）はEnumを使用してラベル表示される
- InfolistはFilamentのSchema/Componentsを使用して構築されている
