# 画面設計書 343-休暇管理作成

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇管理作成画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が従業員の休暇申請を新規作成するためのものです。従業員の代わりに休暇申請を登録したり、管理者自身の休暇を申請する際に使用します。

**業務上の目的・背景**：管理者が従業員に代わって休暇申請を行う必要がある場合（例：緊急の休暇、事後申請など）に、この画面から申請を作成できます。また、システム運用上の必要性から管理者が直接休暇データを入力するケースにも対応します。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → 休暇管理一覧画面から「作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 休暇タイプの選択
2. 対象従業員の選択
3. 休暇期間（開始日・終了日）の入力
4. 半日休暇オプションの設定
5. 説明・理由の入力
6. 添付ファイルのアップロード（休暇タイプによる）
7. 休暇申請の保存

**画面遷移**：
- 遷移元：休暇管理一覧画面（ListTimeOff）
- 遷移先：休暇管理詳細画面（ViewTimeOff）- 作成成功後

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-002 | 休暇申請作成 | 主機能 | 新規休暇申請の作成 |
| FN-TOFF-001 | 休暇申請一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-TOFF-004 | 休暇申請表示 | 遷移先機能 | 作成成功後の詳細表示 |

## 画面種別

作成（Create）

## URL/ルーティング

```
/time-off/management/time-offs/create
```

## 画面構成

画面は以下の要素で構成されます：

1. **サブナビゲーション**
   - クラスター内のコンポーネントナビゲーション

2. **フォームエリア**
   - ステータスプログレスステッパー
   - 休暇タイプ選択
   - 半日休暇オプション
   - 日付入力エリア
   - 説明入力
   - 添付ファイルアップロード

3. **フォームアクション**
   - 作成ボタン
   - キャンセルボタン

## 入出力項目

### 入力項目

| 項目名 | 表示名 | データ型 | 必須 | デフォルト値 | バリデーション | 説明 |
|--------|--------|----------|------|-------------|---------------|------|
| holiday_status_id | 休暇タイプ | select | ○ | - | 存在するLeaveType | 休暇の種類を選択 |
| employee_id | 従業員 | select | ○ | - | 存在するEmployee | 対象従業員を選択 |
| request_unit_half | 半日休暇 | boolean | - | false | - | 半日休暇かどうか |
| request_date_from | 開始日 | date | ○ | 今日 | - | 休暇開始日 |
| request_date_to | 終了日 | date | - | - | >= request_date_from | 休暇終了日 |
| request_date_from_period | 期間 | select | - | - | am/pm | 半日休暇時の午前/午後 |
| private_name | 説明 | text | - | - | - | 休暇の理由・説明 |
| attachment | 添付ファイル | file | - | - | - | 証明書類等 |

## 表示項目

### ステータス表示

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| state | ステータス | ProgressStepper | 申請状態のプログレス表示（読み取り専用） |

## イベント仕様

### 1-フォーム送信（作成）

**トリガー**: 作成ボタン押下

**処理内容**:
1. フォームバリデーション実行
2. TimeOffHelper::mutateTimeOffData()による日付計算・データ変換
3. time_off_leaves テーブルにレコード挿入
4. 成功通知を表示
5. 詳細画面へリダイレクト

### 2-半日休暇トグル

**トリガー**: 半日休暇チェックボックスの変更

**処理内容**:
- true: 終了日フィールドを非表示、期間選択を表示
- false: 終了日フィールドを表示、期間選択を非表示

### 3-休暇タイプ変更

**トリガー**: 休暇タイプの選択変更

**処理内容**:
- 選択された休暇タイプのsupport_documentフラグを確認
- trueの場合、添付ファイルフィールドを表示
- falseの場合、添付ファイルフィールドを非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーム送信 | time_off_leaves | INSERT | 新規休暇申請レコードの作成 |

### テーブル別更新項目詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | holiday_status_id | フォーム入力値 | 休暇タイプID |
| INSERT | employee_id | フォーム入力値 | 従業員ID |
| INSERT | request_date_from | フォーム入力値 | 申請開始日 |
| INSERT | request_date_to | フォーム入力値 or NULL | 申請終了日 |
| INSERT | request_unit_half | フォーム入力値 | 半日休暇フラグ |
| INSERT | request_date_from_period | フォーム入力値 or NULL | 午前/午後 |
| INSERT | private_name | フォーム入力値 | 説明 |
| INSERT | attachment | ファイルパス | 添付ファイル |
| INSERT | state | 'confirm' | 初期状態：確認待ち |
| INSERT | date_from | 計算値 | mutateTimeOffDataで計算 |
| INSERT | date_to | 計算値 | mutateTimeOffDataで計算 |
| INSERT | number_of_days | 計算値 | mutateTimeOffDataで計算 |
| INSERT | duration_display | 計算値 | mutateTimeOffDataで計算 |
| INSERT | user_id | 現在のユーザーID | 作成者 |
| INSERT | creator_id | 現在のユーザーID | 作成者 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/create-time-off.notification.title | 作成成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/create-time-off.notification.body | 作成成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| バリデーションエラー | フォームにエラーメッセージを表示 |
| 日付の矛盾（終了日 < 開始日） | バリデーションエラー |
| 休暇タイプが存在しない | バリデーションエラー |

## 備考

- フォームスキーマは TimeOffHelper トレイトの getFormSchema() メソッドで定義
- mutateFormDataBeforeCreate() で TimeOffHelper::mutateTimeOffData() を呼び出し、日付計算や追加データの設定を行う
- サブナビゲーションはクラスターのコンポーネントから生成される
- state のデフォルト値は CONFIRM（確認待ち）
- 添付ファイルは休暇タイプの support_document フラグによって表示/非表示が制御される
