# 画面設計書 344-休暇管理編集

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇管理編集画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が既存の休暇申請を編集するためのものです。休暇申請の内容修正、承認状態の変更、削除などの管理操作を行うことができます。

**業務上の目的・背景**：提出された休暇申請に誤りがあった場合や、休暇期間の変更が必要な場合に、管理者がデータを修正できます。また、Chatter機能を使用してコメントを残したり、承認ワークフローを進めることもできます。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → 休暇管理一覧画面または詳細画面から「編集」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 休暇申請データの編集
2. Chatter（コミュニケーション機能）によるコメント追加
3. 詳細画面への遷移
4. 休暇申請の削除

**画面遷移**：
- 遷移元：休暇管理一覧画面（ListTimeOff）、休暇管理詳細画面（ViewTimeOff）
- 遷移先：休暇管理詳細画面（ViewTimeOff）- 保存成功後

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-003 | 休暇申請編集 | 主機能 | 既存休暇申請の編集 |
| FN-TOFF-001 | 休暇申請一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-TOFF-004 | 休暇申請表示 | 遷移先機能 | 保存成功後の詳細表示 |

## 画面種別

編集（Edit）

## URL/ルーティング

```
/time-off/management/time-offs/{record}/edit
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - Chatterアクション（コミュニケーション機能）
   - 表示ボタン（ViewAction）
   - 削除ボタン（DeleteAction）

2. **サブナビゲーション**
   - クラスター内のコンポーネントナビゲーション

3. **フォームエリア**
   - ステータスプログレスステッパー
   - 休暇タイプ選択
   - 半日休暇オプション
   - 日付入力エリア
   - 説明入力
   - 添付ファイルアップロード

4. **フォームアクション**
   - 保存ボタン
   - キャンセルボタン

## 入出力項目

### 入力項目

| 項目名 | 表示名 | データ型 | 必須 | バリデーション | 説明 |
|--------|--------|----------|------|---------------|------|
| holiday_status_id | 休暇タイプ | select | ○ | 存在するLeaveType | 休暇の種類を選択 |
| employee_id | 従業員 | select | ○ | 存在するEmployee | 対象従業員を選択 |
| request_unit_half | 半日休暇 | boolean | - | - | 半日休暇かどうか |
| request_date_from | 開始日 | date | ○ | - | 休暇開始日 |
| request_date_to | 終了日 | date | - | >= request_date_from | 休暇終了日 |
| request_date_from_period | 期間 | select | - | am/pm | 半日休暇時の午前/午後 |
| private_name | 説明 | text | - | - | 休暇の理由・説明 |
| attachment | 添付ファイル | file | - | - | 証明書類等 |

## 表示項目

### ステータス表示

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| state | ステータス | ProgressStepper | 申請状態のプログレス表示（読み取り専用） |

## イベント仕様

### 1-Chatterアクション

**トリガー**: Chatterボタン押下

**処理内容**:
- Chatterモーダルを表示
- コメントの追加・履歴の確認が可能
- 関連リソース（TimeOffResource）に紐づいたチャターを表示

### 2-表示アクション

**トリガー**: 表示ボタン押下

**処理内容**:
- 休暇管理詳細画面（ViewTimeOff）へ遷移

### 3-削除アクション

**トリガー**: 削除ボタン押下

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

### 4-フォーム保存

**トリガー**: 保存ボタン押下

**処理内容**:
1. フォームバリデーション実行
2. TimeOffHelper::mutateTimeOffData()による日付計算・データ変換
3. time_off_leaves テーブルのレコード更新
4. 成功通知を表示
5. 詳細画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーム保存 | time_off_leaves | UPDATE | 休暇申請レコードの更新 |
| 削除アクション | time_off_leaves | DELETE | 対象レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | holiday_status_id | フォーム入力値 | 休暇タイプID |
| UPDATE | employee_id | フォーム入力値 | 従業員ID |
| UPDATE | request_date_from | フォーム入力値 | 申請開始日 |
| UPDATE | request_date_to | フォーム入力値 or NULL | 申請終了日 |
| UPDATE | request_unit_half | フォーム入力値 | 半日休暇フラグ |
| UPDATE | request_date_from_period | フォーム入力値 or NULL | 午前/午後 |
| UPDATE | private_name | フォーム入力値 | 説明 |
| UPDATE | attachment | ファイルパス | 添付ファイル |
| UPDATE | date_from | 計算値 | mutateTimeOffDataで計算 |
| UPDATE | date_to | 計算値 | mutateTimeOffDataで計算 |
| UPDATE | number_of_days | 計算値 | mutateTimeOffDataで計算 |
| UPDATE | duration_display | 計算値 | mutateTimeOffDataで計算 |
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/edit-time-off.notification.title | 保存成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/edit-time-off.notification.body | 保存成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/edit-time-off.header-actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/edit-time-off.header-actions.delete.notification.body | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラーページを表示 |
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| バリデーションエラー | フォームにエラーメッセージを表示 |

## 備考

- フォームスキーマは TimeOffHelper トレイトの getFormSchema() メソッドで定義
- mutateFormDataBeforeSave() で TimeOffHelper::mutateTimeOffData() を呼び出し、日付計算や追加データの設定を行う
- 保存成功後は詳細画面（ViewTimeOff）へリダイレクト
- サブナビゲーションはクラスターのコンポーネントから生成される
- 添付ファイルは休暇タイプの support_document フラグによって表示/非表示が制御される
