# 画面設計書 345-休暇管理詳細

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇管理詳細画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が休暇申請の詳細情報を閲覧するためのものです。休暇タイプ、期間、ステータスなどの情報を確認し、必要に応じて編集画面への遷移や削除操作を行うことができます。

**業務上の目的・背景**：管理者が休暇申請の全体像を把握し、承認判断のための情報を確認する画面です。申請者、休暇期間、申請理由などの詳細を一目で確認でき、Chatter機能を使用してコミュニケーションを取ることもできます。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → 休暇管理一覧画面から特定のレコードをクリック、または編集画面の「表示」ボタンからアクセスします。

**主要な操作・処理内容**：
1. 休暇申請の詳細情報閲覧
2. Chatter（コミュニケーション機能）によるコメント確認・追加
3. 編集画面への遷移
4. 休暇申請の削除

**画面遷移**：
- 遷移元：休暇管理一覧画面（ListTimeOff）、休暇管理編集画面（EditTimeOff）
- 遷移先：休暇管理編集画面（EditTimeOff）

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-004 | 休暇申請表示 | 主機能 | 休暇申請詳細の表示 |
| FN-TOFF-003 | 休暇申請編集 | 遷移先機能 | 編集ボタンからの遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

```
/time-off/management/time-offs/{record}
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - Chatterアクション（コミュニケーション機能）
   - 編集ボタン（EditAction）
   - 削除ボタン（DeleteAction）

2. **サブナビゲーション**
   - クラスター内のコンポーネントナビゲーション

3. **詳細情報表示エリア**（1カラムレイアウト）
   - 休暇タイプ
   - 半日休暇フラグ
   - 申請開始日
   - 申請終了日（半日休暇でない場合）
   - 期間（半日休暇の場合）
   - 説明
   - 申請日数
   - 添付ファイル（休暇タイプで許可されている場合）

## 入出力項目

本画面は詳細表示画面のため、入力項目はありません。

## 表示項目

### 休暇情報セクション

| 項目名 | 表示名 | データ型 | 表示条件 | 説明 |
|--------|--------|----------|----------|------|
| holidayStatus.name | 休暇タイプ | string | 常時 | 休暇の種類名 |
| request_unit_half | 半日休暇 | string | 常時 | Yes/Noで表示 |
| request_date_from | 申請開始日 | date | 常時 | 休暇の開始日 |
| request_date_to | 申請終了日 | date | 半日休暇でない場合 | 休暇の終了日 |
| request_date_from_period | 期間 | string | 半日休暇の場合 | 午前/午後 |
| private_name | 説明 | text | 常時 | 休暇の理由・説明 |
| duration_display | 申請日数 | string | 常時 | 休暇日数の表示 |
| attachment | 添付ファイル | image | 休暇タイプのsupport_documentがtrue | 証明書類等 |

## イベント仕様

### 1-Chatterアクション

**トリガー**: Chatterボタン押下

**処理内容**:
- Chatterモーダルを表示
- コメントの追加・履歴の確認が可能
- 関連リソース（TimeOffResource）に紐づいたチャターを表示

### 2-編集アクション

**トリガー**: 編集ボタン押下

**処理内容**:
- 休暇管理編集画面（EditTimeOff）へ遷移
- 遷移先URL: `/time-off/management/time-offs/{record}/edit`

### 3-削除アクション

**トリガー**: 削除ボタン押下

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | time_off_leaves | DELETE | 対象レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/view-time-off.header-actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off/pages/view-time-off.header-actions.delete.notification.body | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラーページを表示 |
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |

## 備考

- InfolistはFilamentのSchema/Componentsを使用して構築
- サブナビゲーションはクラスターのコンポーネントから生成される
- 添付ファイルはImageEntryで表示（休暇タイプのsupport_documentフラグによる制御）
- 半日休暇の場合は申請終了日が非表示になり、代わりに期間（午前/午後）が表示される
- 日数表示は半日休暇の場合「0.5日」、それ以外は計算された日数を表示
