# 画面設計書 346-割当管理一覧

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける割当管理一覧画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が全従業員の休暇割当を一覧表示し、承認・拒否などの管理操作を行うためのものです。複数のプリセットビューを使用して、状態別に休暇割当をフィルタリングして表示できます。

**業務上の目的・背景**：管理者が従業員への休暇割当（有給休暇、特別休暇などの付与）を一元管理するための画面です。年次の休暇付与、追加休暇の割当、承認状態の確認などを効率的に行えます。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → Allocations（割当）メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 休暇割当の一覧表示（従業員名、休暇タイプ、割当日数、ステータス等）
2. プリセットビューによる状態別フィルタリング（承認待ち、二次承認、承認済み、現在有効、マイチーム、自部署、拒否済み）
3. 休暇割当の承認・拒否アクション
4. 個別レコードの表示・編集・削除
5. 一括削除操作
6. グループ化表示（従業員名、休暇タイプ、割当タイプ、ステータス、開始日）

**画面遷移**：
- 遷移先：割当管理作成画面（CreateAllocation）、割当管理詳細画面（ViewAllocation）、割当管理編集画面（EditAllocation）

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。プリセットビュー「マイチーム」は現在のユーザーが休暇管理者として設定されている従業員のみ表示します。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-005 | 休暇割当一覧 | 主機能 | 休暇割当の一覧表示と検索 |
| FN-TOFF-006 | 休暇割当作成 | 遷移先機能 | 新規作成ボタンからの遷移 |
| FN-TOFF-007 | 休暇割当編集 | 遷移先機能 | 編集アクションからの遷移 |
| FN-TOFF-008 | 休暇割当表示 | 遷移先機能 | 表示アクションからの遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

```
/time-off/management/allocations
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - 作成ボタン（CreateAction）- heroicon-o-plus-circle アイコン付き

2. **プリセットビュータブ**
   - Waiting For Me（承認待ち）- デフォルト、お気に入り
   - Second Approval（二次承認）- デフォルト、お気に入り
   - Approved（承認済み）- デフォルト、お気に入り
   - Currently Valid（現在有効）
   - My Team（マイチーム）
   - My Department（自部署）
   - Refused（拒否済み）

3. **テーブル一覧**
   - カラム表示
   - グループ化オプション
   - 行アクション（表示、編集、削除、承認、拒否）

4. **ツールバーアクション**
   - 一括削除

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません（検索・フィルタ機能を除く）。

## 表示項目

### テーブルカラム

| 項目名 | 表示名 | データ型 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| employee.name | 従業員名 | string | ○ | ○ | 割当対象の従業員名 |
| holidayStatus.name | 休暇タイプ | string | ○ | ○ | 休暇の種類名 |
| number_of_days | 割当日数 | number | ○ | ○ | 割り当てられた日数 |
| allocation_type | 割当タイプ | enum | ○ | ○ | Regular/Accrual等 |
| state | ステータス | badge | ○ | ○ | 確認待ち/承認済み/拒否等 |

### グループ化オプション

| グループ名 | 対象項目 | 折りたたみ可能 |
|-----------|----------|---------------|
| 従業員名 | employee.name | ○ |
| 休暇タイプ | holidayStatus.name | ○ |
| 割当タイプ | allocation_type | ○ |
| ステータス | state | ○ |
| 開始日 | date_from | ○ |

## イベント仕様

### 1-作成アクション

**トリガー**: 作成ボタン押下

**処理内容**:
- 割当管理作成画面（CreateAllocation）へ遷移

### 2-承認アクション

**トリガー**: 行アクションメニューから「承認」を選択

**処理内容**:
1. 対象レコードのstateをVALIDATE_TWOに更新
2. 成功通知を表示
3. テーブルを再読み込み

**表示条件**: state が VALIDATE_TWO でない場合のみ表示

### 3-拒否アクション

**トリガー**: 行アクションメニューから「拒否」を選択

**処理内容**:
1. 対象レコードのstateをREFUSEに更新
2. 成功通知を表示
3. テーブルを再読み込み

**表示条件**: state が REFUSE でない場合のみ表示

### 4-表示アクション

**トリガー**: 行アクションメニューから「表示」を選択

**処理内容**:
- 割当管理詳細画面（ViewAllocation）へ遷移

### 5-編集アクション

**トリガー**: 行アクションメニューから「編集」を選択

**処理内容**:
- 割当管理編集画面（EditAllocation）へ遷移

### 6-削除アクション

**トリガー**: 行アクションメニューから「削除」を選択

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示

### 7-一括削除アクション

**トリガー**: 複数行を選択し、一括削除を選択

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、選択されたすべてのレコードを削除
3. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 承認アクション | time_off_leave_allocations | UPDATE | state を VALIDATE_TWO に更新 |
| 拒否アクション | time_off_leave_allocations | UPDATE | state を REFUSE に更新 |
| 削除アクション | time_off_leave_allocations | DELETE | 対象レコードの削除 |
| 一括削除アクション | time_off_leave_allocations | DELETE | 複数レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（承認） | state | 'validate_two' | 承認状態に変更 |
| UPDATE（拒否） | state | 'refuse' | 拒否状態に変更 |
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/allocation.table.actions.approve.notification.title | 承認成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.actions.approve.notification.body | 承認成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.actions.refused.notification.title | 拒否成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.actions.refused.notification.body | 拒否成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.actions.delete.notification.body | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.bulk-actions.delete.notification.title | 一括削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation.table.bulk-actions.delete.notification.body | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| 対象レコードが既に削除されている | エラー通知を表示 |

## 備考

- プリセットビューは `HasTableViews` トレイトを使用して実装
- State Enumの値：CONFIRM（確認待ち）、VALIDATE_ONE（一次承認）、VALIDATE_TWO（二次承認/最終承認）、REFUSE（拒否）
- AllocationType Enumの値：REGULAR（通常）、ACCRUAL（積立）
- 「Waiting For Me」「Second Approval」「Approved」の3つがデフォルトで選択状態（setAsDefault）
- マイチームビューは leave_manager_id または user_id が現在のユーザーIDに一致するレコードを表示
- 作成ボタンには heroicon-o-plus-circle アイコンが付与
- navigationSort = 2 で、Time Offリソースの次に表示される
