# 画面設計書 347-割当管理作成

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける割当管理作成画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が従業員への新規休暇割当を作成するためのものです。有給休暇、特別休暇などの休暇日数を従業員に付与する際に使用します。

**業務上の目的・背景**：年次の休暇付与、追加休暇の割当、新入社員への初期休暇付与など、従業員に対して休暇日数を割り当てる必要がある場合に使用します。割当タイプ（通常/積立）や有効期間を設定することで、柔軟な休暇管理が可能です。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → 割当管理一覧画面から「作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 割当名の入力
2. 休暇タイプの選択
3. 対象従業員の選択
4. 割当タイプ（通常/積立）の選択
5. 有効期間（開始日・終了日）の設定
6. 割当日数の入力
7. 理由・備考の入力
8. 休暇割当の保存

**画面遷移**：
- 遷移元：割当管理一覧画面（ListAllocations）
- 遷移先：割当管理詳細画面（ViewAllocation）- 作成成功後

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-006 | 休暇割当作成 | 主機能 | 新規休暇割当の作成 |
| FN-TOFF-005 | 休暇割当一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-TOFF-008 | 休暇割当表示 | 遷移先機能 | 作成成功後の詳細表示 |

## 画面種別

作成（Create）

## URL/ルーティング

```
/time-off/management/allocations/create
```

## 画面構成

画面は以下の要素で構成されます：

1. **サブナビゲーション**
   - クラスター内のコンポーネントナビゲーション

2. **フォームエリア**（1カラムレイアウト）
   - ステータスプログレスステッパー（読み取り専用）
   - 割当情報セクション
     - 割当名入力
     - 休暇タイプ選択
     - 従業員選択
     - 割当タイプ選択
     - 有効期間フィールドセット
     - 割当日数入力
     - 理由入力

3. **フォームアクション**
   - 作成ボタン
   - キャンセルボタン

## 入出力項目

### 入力項目

| 項目名 | 表示名 | データ型 | 必須 | デフォルト値 | バリデーション | 説明 |
|--------|--------|----------|------|-------------|---------------|------|
| name | 名称 | text | ○ | - | - | 割当の名称 |
| holiday_status_id | 休暇タイプ | select | ○ | - | 存在するLeaveType | 休暇の種類を選択 |
| employee_id | 従業員 | select | ○ | - | 存在するEmployee | 対象従業員を選択 |
| allocation_type | 割当タイプ | radio | ○ | regular | AllocationType Enum | 通常/積立の選択 |
| date_from | 開始日 | date | ○ | 今日 | - | 有効期間の開始日 |
| date_to | 終了日 | date | - | - | - | 有効期間の終了日 |
| number_of_days | 割当日数 | number | ○ | 0 | min:0, max:99999999999 | 割り当てる日数 |
| notes | 理由 | richtext | - | - | - | 割当の理由・備考 |

## 表示項目

### ステータス表示

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| state | ステータス | ProgressStepper | 確認待ち→承認済みのプログレス表示（読み取り専用） |

## イベント仕様

### 1-フォーム送信（作成）

**トリガー**: 作成ボタン押下

**処理内容**:
1. フォームバリデーション実行
2. time_off_leave_allocations テーブルにレコード挿入
3. 成功通知を表示
4. 詳細画面へリダイレクト

### 2-割当タイプ選択

**トリガー**: 割当タイプのラジオボタン変更

**処理内容**:
- 選択された割当タイプをフォームデータに反映
- UIの表示更新（リアクティブ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーム送信 | time_off_leave_allocations | INSERT | 新規休暇割当レコードの作成 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 割当名 |
| INSERT | holiday_status_id | フォーム入力値 | 休暇タイプID |
| INSERT | employee_id | フォーム入力値 | 従業員ID |
| INSERT | allocation_type | フォーム入力値 | 割当タイプ |
| INSERT | date_from | フォーム入力値 | 開始日 |
| INSERT | date_to | フォーム入力値 or NULL | 終了日 |
| INSERT | number_of_days | フォーム入力値 | 割当日数 |
| INSERT | notes | フォーム入力値 | 理由・備考 |
| INSERT | state | 'confirm' | 初期状態：確認待ち |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/create-allocation.notification.title | 作成成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/create-allocation.notification.body | 作成成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| バリデーションエラー | フォームにエラーメッセージを表示 |
| 休暇タイプが存在しない | バリデーションエラー |
| 従業員が存在しない | バリデーションエラー |

## 備考

- フォームはAllocationResource::form()で定義
- ProgressStepperでstate（CONFIRM, VALIDATE_TWO, REFUSE）を視覚的に表示
- 作成成功後は詳細画面（ViewAllocation）へリダイレクト（getRedirectUrl()で定義）
- サブナビゲーションはクラスターのコンポーネントから生成
- state のデフォルト値は CONFIRM（確認待ち）
- 割当日数は数値入力で、サフィックスとして「日」が表示される
- notesフィールドはRichEditor（リッチテキストエディタ）を使用
