# 画面設計書 348-割当管理編集

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける割当管理編集画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が既存の休暇割当を編集するためのものです。割当内容の修正に加え、承認・拒否などの状態変更操作も行うことができます。

**業務上の目的・背景**：休暇割当の内容に誤りがあった場合や、割当日数の変更が必要な場合に修正できます。また、承認ワークフローとして承認・拒否・再確認の操作も可能です。Chatter機能を使用して承認理由やコメントを残すこともできます。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → 割当管理一覧画面または詳細画面から「編集」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 休暇割当データの編集
2. Chatter（コミュニケーション機能）によるコメント追加
3. 承認アクション（確認待ちの場合）
4. 拒否アクション（拒否済みでない場合）
5. 再確認アクション（拒否済みの場合）
6. 休暇割当の削除

**画面遷移**：
- 遷移元：割当管理一覧画面（ListAllocations）、割当管理詳細画面（ViewAllocation）
- 遷移先：割当管理詳細画面（ViewAllocation）- 保存成功後

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-007 | 休暇割当編集 | 主機能 | 既存休暇割当の編集 |
| FN-TOFF-005 | 休暇割当一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-TOFF-008 | 休暇割当表示 | 遷移先機能 | 保存成功後の詳細表示 |

## 画面種別

編集（Edit）

## URL/ルーティング

```
/time-off/management/allocations/{record}/edit
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - Chatterアクション（コミュニケーション機能）
   - 承認ボタン（Approved）- 確認待ちの場合のみ表示
   - 拒否ボタン（Refuse）- 拒否済みでない場合のみ表示
   - 再確認ボタン（Mark as Ready to Confirm）- 拒否済みの場合のみ表示
   - 削除ボタン（DeleteAction）

2. **サブナビゲーション**
   - クラスター内のコンポーネントナビゲーション

3. **フォームエリア**（1カラムレイアウト）
   - ステータスプログレスステッパー（読み取り専用）
   - 割当情報セクション
     - 割当名入力
     - 休暇タイプ選択
     - 従業員選択
     - 割当タイプ選択
     - 有効期間フィールドセット
     - 割当日数入力
     - 理由入力

4. **フォームアクション**
   - 保存ボタン
   - キャンセルボタン

## 入出力項目

### 入力項目

| 項目名 | 表示名 | データ型 | 必須 | バリデーション | 説明 |
|--------|--------|----------|------|---------------|------|
| name | 名称 | text | ○ | - | 割当の名称 |
| holiday_status_id | 休暇タイプ | select | ○ | 存在するLeaveType | 休暇の種類を選択 |
| employee_id | 従業員 | select | ○ | 存在するEmployee | 対象従業員を選択 |
| allocation_type | 割当タイプ | radio | ○ | AllocationType Enum | 通常/積立の選択 |
| date_from | 開始日 | date | ○ | - | 有効期間の開始日 |
| date_to | 終了日 | date | - | - | 有効期間の終了日 |
| number_of_days | 割当日数 | number | ○ | min:0, max:99999999999 | 割り当てる日数 |
| notes | 理由 | richtext | - | - | 割当の理由・備考 |

## 表示項目

### ステータス表示

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| state | ステータス | ProgressStepper | 確認待ち→承認済み/拒否のプログレス表示 |

## イベント仕様

### 1-Chatterアクション

**トリガー**: Chatterボタン押下

**処理内容**:
- Chatterモーダルを表示
- コメントの追加・履歴の確認が可能
- 関連リソース（AllocationResource）に紐づいたチャターを表示

### 2-承認アクション

**トリガー**: 承認ボタン押下

**処理内容**:
1. 対象レコードのstateをVALIDATE_TWOに更新
2. フォームデータを更新（refreshFormData）
3. 成功通知を表示

**表示条件**: state が CONFIRM の場合のみ表示

### 3-拒否アクション

**トリガー**: 拒否ボタン押下

**処理内容**:
1. 対象レコードのstateをREFUSEに更新
2. フォームデータを更新（refreshFormData）
3. 成功通知を表示

**表示条件**: state が REFUSE でない場合のみ表示

### 4-再確認アクション

**トリガー**: 再確認ボタン押下

**処理内容**:
1. 対象レコードのstateをCONFIRMに更新
2. フォームデータを更新（refreshFormData）
3. 成功通知を表示

**表示条件**: state が REFUSE の場合のみ表示

### 5-削除アクション

**トリガー**: 削除ボタン押下

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

### 6-フォーム保存

**トリガー**: 保存ボタン押下

**処理内容**:
1. フォームバリデーション実行
2. time_off_leave_allocations テーブルのレコード更新
3. 成功通知を表示
4. 詳細画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーム保存 | time_off_leave_allocations | UPDATE | 休暇割当レコードの更新 |
| 承認アクション | time_off_leave_allocations | UPDATE | state を VALIDATE_TWO に更新 |
| 拒否アクション | time_off_leave_allocations | UPDATE | state を REFUSE に更新 |
| 再確認アクション | time_off_leave_allocations | UPDATE | state を CONFIRM に更新 |
| 削除アクション | time_off_leave_allocations | DELETE | 対象レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（保存） | name | フォーム入力値 | 割当名 |
| UPDATE（保存） | holiday_status_id | フォーム入力値 | 休暇タイプID |
| UPDATE（保存） | employee_id | フォーム入力値 | 従業員ID |
| UPDATE（保存） | allocation_type | フォーム入力値 | 割当タイプ |
| UPDATE（保存） | date_from | フォーム入力値 | 開始日 |
| UPDATE（保存） | date_to | フォーム入力値 or NULL | 終了日 |
| UPDATE（保存） | number_of_days | フォーム入力値 | 割当日数 |
| UPDATE（保存） | notes | フォーム入力値 | 理由・備考 |
| UPDATE（承認） | state | 'validate_two' | 承認状態に変更 |
| UPDATE（拒否） | state | 'refuse' | 拒否状態に変更 |
| UPDATE（再確認） | state | 'confirm' | 確認待ち状態に変更 |
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.notification.title | 保存成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.notification.body | 保存成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.approved.notification.title | 承認成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.approved.notification.body | 承認成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.refuse.notification.title | 拒否成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.refuse.notification.body | 拒否成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.mark-as-ready-to-confirm.notification.title | 再確認成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.mark-as-ready-to-confirm.notification.body | 再確認成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/edit-allocation.header-actions.delete.notification.body | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラーページを表示 |
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| バリデーションエラー | フォームにエラーメッセージを表示 |

## 備考

- 承認ワークフロー：CONFIRM → VALIDATE_TWO（承認）または REFUSE（拒否）
- 拒否後は再確認アクションでCONFIRM状態に戻すことが可能
- 各アクション実行後、refreshFormData(['state'])でフォームのstate表示を更新
- 保存成功後は詳細画面（ViewAllocation）へリダイレクト
- サブナビゲーションはクラスターのコンポーネントから生成
- ProgressStepperはstate変更に応じて動的に表示が更新される（reactive/live）
