# 画面設計書 349-割当管理詳細

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける割当管理詳細画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、管理者が休暇割当の詳細情報を閲覧するためのものです。割当名、休暇タイプ、割当日数、有効期間、ステータスなどの情報を確認し、必要に応じて編集画面への遷移や削除操作を行うことができます。

**業務上の目的・背景**：管理者が従業員への休暇割当状況を詳細に確認するための画面です。割当内容、有効期間、承認状態などを一目で確認でき、Chatter機能を使用してコミュニケーションを取ることもできます。

**画面へのアクセス方法**：Time Offモジュール → Management クラスター → 割当管理一覧画面から特定のレコードをクリック、または編集画面からアクセスします。

**主要な操作・処理内容**：
1. 休暇割当の詳細情報閲覧
2. Chatter（コミュニケーション機能）によるコメント確認・追加
3. 編集画面への遷移
4. 休暇割当の削除

**画面遷移**：
- 遷移元：割当管理一覧画面（ListAllocations）、割当管理編集画面（EditAllocation）、割当管理作成画面（CreateAllocation）
- 遷移先：割当管理編集画面（EditAllocation）

**権限による表示制御**：管理クラスターのため、管理権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-008 | 休暇割当表示 | 主機能 | 休暇割当詳細の表示 |
| FN-TOFF-007 | 休暇割当編集 | 遷移先機能 | 編集ボタンからの遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

```
/time-off/management/allocations/{record}
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - Chatterアクション（コミュニケーション機能）
   - 編集ボタン（EditAction）
   - 削除ボタン（DeleteAction）

2. **サブナビゲーション**
   - クラスター内のコンポーネントナビゲーション

3. **詳細情報表示エリア**（3カラムレイアウト）
   - 左側（2カラム幅）
     - 割当詳細セクション
     - 有効期間セクション
   - 右側（1カラム幅）
     - 割当ステータスセクション

## 入出力項目

本画面は詳細表示画面のため、入力項目はありません。

## 表示項目

### 割当詳細セクション（Allocation Details）

| 項目名 | 表示名 | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| name | 名称 | string | heroicon-o-calendar | 割当の名称 |
| holidayStatus.name | 休暇タイプ | string | heroicon-o-clock | 関連する休暇タイプ名 |
| allocation_type | 割当タイプ | enum | heroicon-o-queue-list | Regular/Accrual等の割当タイプ |

### 有効期間セクション（Validity Period）

| 項目名 | 表示名 | データ型 | 説明 |
|--------|--------|----------|------|
| date_from | 開始日 | date | 有効期間の開始日 |
| date_to | 終了日 | date | 有効期間の終了日 |
| notes | 理由 | text | 割当の理由・備考（全幅表示） |

### 割当ステータスセクション（Allocation Status）

| 項目名 | 表示名 | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| number_of_days | 割当日数 | numeric | heroicon-o-calculator | 割り当てられた日数 |
| state | ステータス | enum | heroicon-o-flag | 確認待ち/承認済み/拒否等の状態 |

## イベント仕様

### 1-Chatterアクション

**トリガー**: Chatterボタン押下

**処理内容**:
- Chatterモーダルを表示
- コメントの追加・履歴の確認が可能
- 関連リソース（AllocationResource）に紐づいたチャターを表示

### 2-編集アクション

**トリガー**: 編集ボタン押下

**処理内容**:
- 割当管理編集画面（EditAllocation）へ遷移
- 遷移先URL: `/time-off/management/allocations/{record}/edit`

### 3-削除アクション

**トリガー**: 削除ボタン押下

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | time_off_leave_allocations | DELETE | 対象レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leave_allocations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/view-allocation.header-actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/allocation/pages/view-allocation.header-actions.delete.notification.body | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラーページを表示 |
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |

## 備考

- InfolistはFilamentのSchema/Componentsを使用して構築
- 3カラムグリッドレイアウト（左2、右1）で情報を整理表示
- サブナビゲーションはクラスターのコンポーネントから生成される
- 割当タイプ（allocation_type）はgetLabel()メソッドでラベル表示
- ステータス（state）はState::options()[$state]でラベル表示
- 各TextEntryには適切なアイコンが設定されている
- notesフィールドはcolumnSpanFullで全幅表示
- 値がnullの場合は「—」（プレースホルダ）が表示される
