# 画面設計書 35-支払条件編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払条件編集画面の設計仕様を定義するものです。この画面は会計モジュールの支払条件リソースの一部として、既存の支払条件データの編集機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払条件は、請求書や見積書において支払いに関する取り決めを定義するマスタデータです。この編集画面は、既に登録された支払条件の情報（名称、早期支払割引の設定、備考など）を修正する必要がある場合に使用されます。例えば、割引率の変更、割引適用日数の修正、税金減額方法の変更などの業務ニーズに対応します。

**画面へのアクセス方法**：支払条件一覧画面から該当レコードの「編集」ボタンをクリック、または支払条件詳細画面のヘッダーにある「編集」ボタンをクリックしてアクセスします。URLパターンは `/payment-terms/{record}/edit` です。

**主要な操作・処理内容**：
1. 支払条件名の編集
2. 早期支払割引設定の変更（有効/無効、割引率、割引日数）
3. 税金減額方法の変更
4. 備考の編集
5. 保存処理の実行

**画面遷移**：
- 遷移元：支払条件一覧画面、支払条件詳細画面
- 遷移先：保存成功時は支払条件詳細画面、ヘッダーの「表示」ボタンで支払条件詳細画面へ、「削除」ボタンで削除確認後に一覧画面へ

**権限による表示制御**：システムの権限設定に基づき、支払条件リソースへの編集権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-023 | 支払条件管理 | 主機能 | 支払条件の編集 |
| - | 支払条件一覧 | 遷移元機能 | 一覧からの編集遷移 |
| - | 支払条件詳細 | 遷移元/先機能 | 詳細からの編集遷移、保存後の遷移先 |

## 画面種別

編集

## URL/ルーティング

- パス: `/payment-terms/{record}/edit`
- ルート名: `filament.accounts.resources.payment-terms.edit`
- HTTPメソッド: GET（表示）, POST（更新）

## 画面構成

```
+------------------------------------------------------------------+
| サブナビゲーション（上部配置）                                      |
|  [詳細] [編集(現在)] [支払期限]                                    |
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  支払条件の編集                    [表示] [削除]                   |
+------------------------------------------------------------------+
| セクション                                                         |
| +--------------------------------------------------------------+ |
| | 支払条件名 *                                                   | |
| | [Net 30                                  ] (大きめフォント)    | |
| +--------------------------------------------------------------+ |
| |                                                                | |
| | [■] 早期割引                                                   | |
| |                                                                | |
| | (早期割引有効時に表示)                                          | |
| | [2 ]% [10 ]日以内に支払った場合                                 | |
| |                                                                | |
| | 税金減額: [Included▼]                                          | |
| |                                                                | |
| | 備考                                                           | |
| | +----------------------------------------------------------+ | |
| | |                                                          | | |
| | | [リッチテキストエディタ]                                   | | |
| | |                                                          | | |
| | +----------------------------------------------------------+ | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
| フッター                                                          |
|  [キャンセル] [保存]                                              |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 備考 |
|--------|--------|--------|----------|------|------|
| 支払条件名 | name | 入力 | string(255) | ○ | 大きめフォント表示 |
| 早期割引 | early_discount | 入力 | boolean | - | トグル、Live |
| 割引率 | discount_percentage | 入力 | numeric | ※ | 0-100%、早期割引有効時必須 |
| 割引日数 | discount_days | 入力 | integer | ※ | 0以上、早期割引有効時必須 |
| 税金減額 | early_pay_discount | 入力 | enum | - | EarlyPayDiscount列挙型 |
| 備考 | note | 入力 | text | - | リッチテキストエディタ |

※ 早期割引が有効な場合のみ必須

## 表示項目

編集画面のため、入出力項目と同様です。フォームフィールドとして表示されます。

## イベント仕様

### 1-保存ボタン押下

**トリガー**: フッターの「保存」ボタンをクリック

**処理フロー**:
1. フォームバリデーションの実行
2. `mutateFormDataBeforeSave`メソッドによるデータ変換（現在は変換なし）
3. データベースへのUPDATE処理
4. 成功通知の表示
5. 支払条件詳細画面へのリダイレクト

### 2-表示ボタン押下

**トリガー**: ヘッダーの「表示」ボタンをクリック

**処理フロー**:
1. 支払条件詳細画面への遷移

### 3-削除ボタン押下

**トリガー**: ヘッダーの「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、ソフトデリート実行
3. 成功通知の表示
4. 一覧画面へのリダイレクト

### 4-早期割引トグル変更

**トリガー**: 早期割引トグルの切り替え（Live/Reactive）

**処理フロー**:
1. トグルがONの場合
   - 割引率フィールドを表示（必須）
   - 割引日数フィールドを表示（必須）
   - 税金減額フィールドを表示
2. トグルがOFFの場合
   - 上記フィールドを非表示

### 5-サブナビゲーション

**トリガー**: サブナビゲーションのリンクをクリック

**処理フロー**:
1. 詳細: 支払条件詳細画面へ遷移
2. 編集: 現在のページ
3. 支払期限: 支払期限管理画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_payment_terms | UPDATE | 支払条件の更新 |
| 削除ボタン押下 | accounts_payment_terms | UPDATE | deleted_atを設定（ソフトデリート） |

### テーブル別更新項目詳細

#### accounts_payment_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | early_discount | フォーム入力値 | boolean |
| UPDATE | discount_percentage | フォーム入力値 | 早期割引有効時 |
| UPDATE | discount_days | フォーム入力値 | 早期割引有効時 |
| UPDATE | early_pay_discount | フォーム入力値 | EarlyPayDiscount列挙型 |
| UPDATE | note | フォーム入力値 | HTML形式 |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| notification.title | 成功 | 支払条件が更新されました | 保存成功時 |
| notification.body | 成功 | 支払条件が正常に更新されました | 保存成功時 |
| delete.notification.title | 成功 | 支払条件が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 支払条件がアーカイブされました | 削除成功時 |
| validation.required | エラー | このフィールドは必須です | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面表示 | 指定された支払条件が見つかりません |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの保存中にエラーが発生しました |
| バリデーションエラー | フォームエラー表示 | 各フィールドに対応するエラーメッセージ |

## 備考

- 本画面はFilament PHPのEditRecordページクラスを継承して実装されています
- サブナビゲーションは画面上部に配置されます（SubNavigationPosition::Top）
- サブナビゲーションには詳細、編集、支払期限の3つのリンクが表示されます
- 早期割引トグルはLive設定されており、切り替え時に関連フィールドが動的に表示/非表示されます
- 備考フィールドはRichEditorコンポーネントを使用しており、書式付きテキスト入力が可能です
- 削除はソフトデリート（論理削除）として処理されます
- フォームは作成画面と同じ構造を共有しています（PaymentTermResource::form）
