# 画面設計書 350-従業員別レポート

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける従業員別レポート画面の設計仕様を定義します。

### 本画面の処理概要

この画面は、従業員別に休暇申請状況をレポート表示するためのものです。休暇管理一覧画面と同様の機能を持ちますが、デフォルトで従業員名でグループ化して表示することで、従業員ごとの休暇取得状況を把握しやすくしています。

**業務上の目的・背景**：管理者・経営層が従業員別の休暇取得状況を分析・レポートとして確認するための画面です。各従業員がどの程度休暇を取得しているか、承認待ちの申請があるかなどを従業員単位で把握できます。これにより、休暇取得の促進や人員配置の計画に活用できます。

**画面へのアクセス方法**：Time Offモジュール → Reporting クラスター → By Employee（従業員別）メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 休暇申請の従業員別グループ化表示
2. プリセットビューによる状態別フィルタリング
3. 休暇申請の承認・拒否アクション
4. 個別レコードの表示・編集・削除
5. 一括削除操作
6. グループ化表示（従業員名、休暇タイプ、ステータス、開始日、終了日）

**画面遷移**：
- 遷移先：従業員別レポート作成画面（CreateByEmployee）、従業員別レポート詳細画面（ViewByEmployee）、従業員別レポート編集画面（EditByEmployee）

**権限による表示制御**：レポーティングクラスターのため、レポート参照権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-011 | 従業員別レポート | 主機能 | 従業員別の休暇レポート表示 |

## 画面種別

一覧（List）/レポート（Report）

## URL/ルーティング

```
/time-off/reporting/by-employees
```

## 画面構成

画面は以下の要素で構成されます：

1. **ヘッダーアクション**
   - 作成ボタン（CreateAction）- 継承元から

2. **プリセットビュータブ**（ListTimeOffから継承）
   - Waiting For Me（承認待ち）- デフォルト、お気に入り
   - Second Approval（二次承認）- お気に入り
   - Approved（承認済み）- お気に入り
   - Currently Valid（現在有効）
   - My Team（マイチーム）
   - My Department（自部署）
   - Refused（拒否済み）

3. **テーブル一覧**
   - デフォルトで従業員名でグループ化
   - カラム表示
   - 行アクション（承認、拒否、表示、編集、削除）

4. **ツールバーアクション**
   - 一括削除

## 入出力項目

本画面は一覧/レポート表示画面のため、直接の入力項目はありません（検索・フィルタ機能を除く）。

## 表示項目

### テーブルカラム（TimeOffResourceから継承）

| 項目名 | 表示名 | データ型 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| employee.name | 従業員名 | string | ○ | ○ | 休暇申請者の従業員名 |
| holidayStatus.name | 休暇タイプ | string | ○ | ○ | 休暇の種類名 |
| private_name | 説明 | string | ○ | ○ | 休暇の説明・理由 |
| date_from | 開始日 | datetime | ○ | ○ | 休暇期間の開始日 |
| date_to | 終了日 | datetime | ○ | ○ | 休暇期間の終了日 |
| duration_display | 期間 | string | ○ | ○ | 休暇日数の表示 |
| state | ステータス | badge | ○ | ○ | 申請の状態（確認待ち、承認済み等） |

### デフォルトグループ化

| グループ名 | 対象項目 | 備考 |
|-----------|----------|------|
| 従業員名 | employee.name | デフォルトでグループ化されて表示 |

## イベント仕様

### 1-作成アクション

**トリガー**: 作成ボタン押下

**処理内容**:
- 従業員別レポート作成画面（CreateByEmployee）へ遷移

### 2-承認アクション

**トリガー**: 行アクションメニューから「承認」を選択

**処理内容**:
1. 対象レコードのstateをVALIDATE_TWOに更新
2. 成功通知を表示
3. テーブルを再読み込み

**表示条件**: state が VALIDATE_TWO でない場合のみ表示

### 3-拒否アクション

**トリガー**: 行アクションメニューから「拒否」を選択

**処理内容**:
1. 対象レコードのstateをREFUSEに更新
2. 成功通知を表示
3. テーブルを再読み込み

**表示条件**: state が REFUSE でない場合のみ表示

### 4-表示アクション

**トリガー**: 行アクションメニューから「表示」を選択

**処理内容**:
- 従業員別レポート詳細画面（ViewByEmployee）へ遷移

### 5-編集アクション

**トリガー**: 行アクションメニューから「編集」を選択

**処理内容**:
- 従業員別レポート編集画面（EditByEmployee）へ遷移

### 6-削除アクション

**トリガー**: 行アクションメニューから「削除」を選択

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、対象レコードを削除
3. 成功通知を表示

### 7-一括削除アクション

**トリガー**: 複数行を選択し、一括削除を選択

**処理内容**:
1. 削除確認ダイアログを表示
2. 確認後、選択されたすべてのレコードを削除
3. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 承認アクション | time_off_leaves | UPDATE | state を VALIDATE_TWO に更新 |
| 拒否アクション | time_off_leaves | UPDATE | state を REFUSE に更新 |
| 削除アクション | time_off_leaves | DELETE | 対象レコードの削除 |
| 一括削除アクション | time_off_leaves | DELETE | 複数レコードの削除 |

### テーブル別更新項目詳細

#### time_off_leaves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（承認） | state | 'validate_two' | 承認状態に変更 |
| UPDATE（拒否） | state | 'refuse' | 拒否状態に変更 |
| DELETE | - | WHERE id = {record_id} | レコード全体を削除 |

## メッセージ仕様

メッセージはTimeOffResourceから継承されます。

| メッセージ種別 | メッセージキー | 表示条件 |
|---------------|---------------|----------|
| 成功 | time-off::filament/clusters/management/resources/time-off.table.actions.approve.notification.title | 承認成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off.table.actions.approve.notification.body | 承認成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off.table.actions.refused.notification.title | 拒否成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off.table.actions.refused.notification.body | 拒否成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off.table.actions.delete.notification.title | 削除成功時 |
| 成功 | time-off::filament/clusters/management/resources/time-off.table.actions.delete.notification.body | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーまたはアクセス拒否画面を表示 |
| 対象レコードが既に削除されている | エラー通知を表示 |

## 備考

- ByEmployeeResourceはTimeOffResource（BaseByEmployeeResource）を継承
- ListByEmployeesはListTimeOffを継承
- デフォルトグループ化として `employee.name` が設定（->defaultGroup('employee.name')）
- Reportingクラスターに属する
- ナビゲーションアイコンは heroicon-o-users
- モデルはLeave（休暇申請）を使用
- テーブル構成、アクション、プリセットビューはすべてTimeOffResourceから継承
- 画面ラベルとナビゲーションラベルは独自のローカライズキーを使用：
  - time-off::filament/clusters/reporting/resources/by-employee.title
  - time-off::filament/clusters/reporting/resources/by-employee.navigation.title
