# 画面設計書 351-休暇タイプ一覧

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇タイプ一覧画面の設計仕様を定義します。

### 本画面の処理概要

休暇タイプ一覧画面は、組織で使用される休暇タイプ（有給休暇、病気休暇、育児休暇など）を一覧表示し、管理するための画面です。

**業務上の目的・背景**：企業の人事管理において、従業員が取得できる休暇の種類を明確に定義し管理することは重要です。本画面では、各休暇タイプの承認フロー、割当要否、表示色などの設定を一元管理し、休暇管理業務の効率化を実現します。

**画面へのアクセス方法**：サイドナビゲーションから「Time Off」モジュールを選択し、「Configurations」クラスターの「Leave Types」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 休暇タイプの一覧表示と検索・フィルタリング
2. 新規休暇タイプの作成（作成ボタンから作成画面へ遷移）
3. 既存休暇タイプの詳細表示・編集・削除
4. 一括削除・復元・完全削除の操作
5. アクティブ/アーカイブ済みのタブ切り替え
6. カラム表示のカスタマイズと並び替え

**画面遷移**：
- 「新規作成」ボタン → 休暇タイプ作成画面（No.352）
- 行クリックまたは「表示」アクション → 休暇タイプ詳細画面（No.354）
- 「編集」アクション → 休暇タイプ編集画面（No.353）

**権限による表示制御**：休暇タイプの管理は通常、人事担当者または管理者権限を持つユーザーに限定されます。一般従業員は閲覧のみ可能な場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-012 | 休暇タイプ管理 | 主機能 | 休暇タイプの一覧表示・作成・編集・削除 |

## 画面種別

一覧（List）

## URL/ルーティング

`/time-off/configurations/leave-types`

## 画面構成

- ヘッダーアクション（新規作成ボタン）
- タブ切り替え（全て / アーカイブ済み）
- データテーブル
  - カラム管理機能
  - カラム並び替え機能
  - 検索・フィルタ機能
  - 行アクション（表示・編集・削除・復元）
  - 一括アクション（削除・完全削除・復元）

## 入出力項目

なし（一覧画面のため）

## 表示項目

| 項目名 | 物理名 | データ型 | 表示形式 | 初期表示 | ソート | 検索 |
|--------|--------|----------|----------|----------|--------|------|
| 名前 | name | string | テキスト | 表示 | 可 | 可 |
| 休暇承認 | leave_validation_type | enum | テキスト | 非表示 | 可 | 可 |
| 通知担当者 | notifiedTimeOffOfficers.name | relation | バッジ | 非表示 | 可 | 可 |
| 割当要否 | requires_allocation | enum | バッジ | 非表示 | 可 | 可 |
| 割当承認 | allocation_validation_type | enum | テキスト | 表示 | 可 | - |
| 従業員リクエスト | employee_requests | enum | バッジ | 非表示 | 可 | 可 |
| 色 | color | string | カラー | 非表示 | - | - |
| 会社 | company.name | relation | テキスト | 非表示 | - | 可 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「New Leave Type」ボタンをクリックすると、休暇タイプ作成画面（CreateLeaveType）に遷移します。

### 2-タブ切り替え

- 「全て」タブ：削除されていない全ての休暇タイプを表示（`whereNull('deleted_at')`）
- 「アーカイブ済み」タブ：ソフトデリートされた休暇タイプを表示（`onlyTrashed()`）
- 各タブにはレコード件数がバッジで表示されます

### 3-行アクション - 表示

選択した休暇タイプの詳細画面（ViewLeaveType）に遷移します。

### 4-行アクション - 編集

選択した休暇タイプの編集画面（EditLeaveType）に遷移します。

### 5-行アクション - 削除

確認ダイアログ表示後、ソフトデリートを実行します。成功時に通知メッセージを表示します。

### 6-行アクション - 復元

アーカイブ済みタブで表示。ソフトデリートされたレコードを復元します。

### 7-一括アクション - 削除

選択した複数の休暇タイプを一括でソフトデリートします。

### 8-一括アクション - 完全削除

選択した複数の休暇タイプを完全に削除します。外部キー制約エラー発生時はエラー通知を表示します。

### 9-一括アクション - 復元

選択した複数の休暇タイプを一括で復元します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | time_off_leave_types | UPDATE | deleted_atをセット（ソフトデリート） |
| 復元アクション | time_off_leave_types | UPDATE | deleted_atをNULLに更新 |
| 完全削除アクション | time_off_leave_types | DELETE | レコードを完全削除 |
| 一覧表示 | time_off_leave_types | SELECT | 休暇タイプ一覧を取得 |

### テーブル別更新項目詳細

#### time_off_leave_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| delete.success | 成功 | 削除完了 | 休暇タイプが正常に削除されました |
| restore.success | 成功 | 復元完了 | 休暇タイプが正常に復元されました |
| bulk-delete.success | 成功 | 一括削除完了 | 選択した休暇タイプが正常に削除されました |
| bulk-restore.success | 成功 | 一括復元完了 | 選択した休暇タイプが正常に復元されました |
| force-delete.success | 成功 | 完全削除完了 | 休暇タイプが完全に削除されました |
| force-delete.error | エラー | 完全削除失敗 | 休暇タイプを削除できませんでした（関連データが存在する可能性があります） |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| 外部キー制約違反（完全削除時） | エラー通知を表示し、削除をスキップ |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装
- ソフトデリート（SoftDeletes）機能を使用
- Spatie EloquentSortableによるレコード並び替えをサポート
- カラムの表示/非表示はユーザーがカスタマイズ可能
