# 画面設計書 352-休暇タイプ作成

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇タイプ作成画面の設計仕様を定義します。

### 本画面の処理概要

休暇タイプ作成画面は、新しい休暇タイプ（有給休暇、病気休暇、育児休暇など）を登録するためのフォーム画面です。

**業務上の目的・背景**：組織の休暇ポリシーに応じて、様々な種類の休暇を定義する必要があります。本画面では、休暇の承認フロー、割当方法、表示設定など、休暇タイプの全ての属性を設定し、従業員が使用できる休暇タイプを新規作成します。

**画面へのアクセス方法**：休暇タイプ一覧画面（No.351）の「New Leave Type」ボタンをクリック、またはURL直接アクセスで遷移します。

**主要な操作・処理内容**：
1. 休暇タイプの基本情報入力（名前、承認タイプ）
2. 割当設定の構成（割当要否、従業員リクエスト可否、割当承認タイプ）
3. 表示オプションの設定（色）
4. 詳細設定の構成（通知担当者、休暇単位、祝日含有、証明書添付、ダッシュボード表示、時間タイプ、ネガティブキャップ）
5. 保存して詳細画面へ遷移

**画面遷移**：
- 保存成功時 → 休暇タイプ詳細画面（No.354）
- キャンセル/戻る → 休暇タイプ一覧画面（No.351）

**権限による表示制御**：休暇タイプの作成は通常、人事担当者または管理者権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-012 | 休暇タイプ管理 | 主機能 | 新規休暇タイプの作成 |

## 画面種別

登録（Create）

## URL/ルーティング

`/time-off/configurations/leave-types/create`

## 画面構成

3カラムレイアウト構成：
- 左側（2カラム幅）：一般設定セクション
  - 名前入力フィールド
  - 承認タイプ（ラジオボタン）
  - 割当要否（ラジオボタン）
  - 従業員リクエスト（条件付き表示）
  - 割当承認タイプ（条件付き表示）
- 右側（1カラム幅）：
  - 表示オプションセクション（色選択）
  - 設定セクション（各種トグルと選択項目）

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 入力制限 |
|--------|--------|----------|------|--------|----------|
| 名前 | name | string | 必須 | なし | 最大255文字 |
| 承認タイプ | leave_validation_type | enum | 必須 | HR | LeaveValidationType |
| 割当要否 | requires_allocation | enum | 必須 | NO | RequiresAllocation |
| 従業員リクエスト | employee_requests | enum | 条件付き必須 | NO | EmployeeRequest |
| 割当承認タイプ | allocation_validation_type | enum | 条件付き必須 | HR | AllocationValidationType |
| 色 | color | string | 必須 | なし | HEXカラーコード |
| 通知担当者 | time_off_user_leave_types | relation | 任意 | なし | 複数選択可 |
| 休暇単位 | request_unit | enum | 任意 | DAY | RequestUnit |
| 祝日含む | include_public_holidays_in_duration | boolean | 任意 | false | - |
| 証明書添付可 | support_document | boolean | 任意 | false | - |
| ダッシュボード表示 | show_on_dashboard | boolean | 任意 | false | - |
| 時間タイプ | time_type | enum | 任意 | LEAVE | TimeType |
| ネガティブキャップ許可 | allows_negative | boolean | 条件付き | false | 割当要否がYESの場合のみ |
| 最大ネガティブキャップ | max_allowed_negative | integer | 条件付き必須 | 0 | ネガティブキャップ許可時のみ |

## 表示項目

なし（入力専用画面）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、データベースに新規レコードを挿入します。
- 保存前にcompany_idとcreator_idを現在のユーザー情報から自動設定
- 保存成功後、通知メッセージを表示
- 詳細画面（ViewLeaveType）にリダイレクト

### 2-割当要否変更（ライブ更新）

requires_allocationの値が変更されると：
- YES選択時：employee_requestsとallocation_validation_typeフィールドを表示
- NO選択時：上記フィールドを非表示

### 3-ネガティブキャップ許可変更（ライブ更新）

allows_negativeがtrueに変更されると：
- max_allowed_negativeフィールドを表示

### 4-キャンセル/戻る

一覧画面に戻ります。未保存の変更は破棄されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | time_off_leave_types | INSERT | 新規休暇タイプレコードを作成 |
| 保存ボタン押下 | time_off_user_leave_types | INSERT | 通知担当者との関連を作成 |

### テーブル別更新項目詳細

#### time_off_leave_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | leave_validation_type | フォーム入力値 | デフォルト: HR |
| INSERT | requires_allocation | フォーム入力値 | デフォルト: NO |
| INSERT | employee_requests | フォーム入力値 | 条件付き |
| INSERT | allocation_validation_type | フォーム入力値 | 条件付き |
| INSERT | color | フォーム入力値 | HEX形式 |
| INSERT | request_unit | フォーム入力値 | デフォルト: DAY |
| INSERT | include_public_holidays_in_duration | フォーム入力値 | boolean |
| INSERT | support_document | フォーム入力値 | boolean |
| INSERT | show_on_dashboard | フォーム入力値 | boolean |
| INSERT | time_type | フォーム入力値 | デフォルト: LEAVE |
| INSERT | allows_negative | フォーム入力値 | boolean |
| INSERT | max_allowed_negative | フォーム入力値 | 整数 |
| INSERT | company_id | ログインユーザーのdefault_company_id | 自動設定 |
| INSERT | creator_id | ログインユーザーのid | 自動設定 |

#### time_off_user_leave_types（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | leave_type_id | 作成された休暇タイプID | - |
| INSERT | user_id | 選択された通知担当者ID | 複数可 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| create.success | 成功 | 作成完了 | 休暇タイプが正常に作成されました |
| validation.name.required | エラー | 入力エラー | 名前は必須です |
| validation.color.required | エラー | 入力エラー | 色は必須です |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| バリデーションエラー | エラーメッセージをフィールド横に表示 |
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| 権限不足 | アクセス拒否画面を表示 |
| セッションタイムアウト | ログイン画面にリダイレクト |

## 備考

- 本画面はFilament PHPのCreateRecordページを継承して実装
- フォームフィールドの条件付き表示はlive()メソッドで実現
- ColorPickerコンポーネントでHEXカラーを選択
- Selectコンポーネントで通知担当者を複数選択可能（searchable, preload, multiple）
- サブナビゲーションにConfigurationsクラスターの他リソースへのリンクを表示
