# 画面設計書 353-休暇タイプ編集

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇タイプ編集画面の設計仕様を定義します。

### 本画面の処理概要

休暇タイプ編集画面は、既存の休暇タイプの設定を変更するためのフォーム画面です。

**業務上の目的・背景**：組織の休暇ポリシー変更に伴い、既存の休暇タイプの設定を更新する必要が生じます。本画面では、休暇の承認フロー、割当方法、表示設定など、休暇タイプの全ての属性を編集できます。

**画面へのアクセス方法**：休暇タイプ一覧画面（No.351）の行アクションから「編集」を選択、または休暇タイプ詳細画面（No.354）のヘッダーアクションから「編集」ボタンをクリックして遷移します。

**主要な操作・処理内容**：
1. 既存の休暇タイプ情報の表示と編集
2. 基本情報の変更（名前、承認タイプ）
3. 割当設定の変更（割当要否、従業員リクエスト可否、割当承認タイプ）
4. 表示オプションの変更（色）
5. 詳細設定の変更
6. 保存して詳細画面へ遷移
7. 削除操作

**画面遷移**：
- 保存成功時 → 休暇タイプ詳細画面（No.354）
- 「表示」ボタン → 休暇タイプ詳細画面（No.354）
- 「削除」ボタン → 削除後、一覧画面（No.351）へ

**権限による表示制御**：休暇タイプの編集は通常、人事担当者または管理者権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-012 | 休暇タイプ管理 | 主機能 | 既存休暇タイプの編集 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/time-off/configurations/leave-types/{record}/edit`

## 画面構成

3カラムレイアウト構成：
- ヘッダーアクション（表示ボタン、削除ボタン）
- 左側（2カラム幅）：一般設定セクション
  - 名前入力フィールド
  - 承認タイプ（ラジオボタン）
  - 割当要否（ラジオボタン）
  - 従業員リクエスト（条件付き表示）
  - 割当承認タイプ（条件付き表示）
- 右側（1カラム幅）：
  - 表示オプションセクション（色選択）
  - 設定セクション（各種トグルと選択項目）

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 入力制限 |
|--------|--------|----------|------|--------|----------|
| 名前 | name | string | 必須 | 既存値 | 最大255文字 |
| 承認タイプ | leave_validation_type | enum | 必須 | 既存値 | LeaveValidationType |
| 割当要否 | requires_allocation | enum | 必須 | 既存値 | RequiresAllocation |
| 従業員リクエスト | employee_requests | enum | 条件付き必須 | 既存値 | EmployeeRequest |
| 割当承認タイプ | allocation_validation_type | enum | 条件付き必須 | 既存値 | AllocationValidationType |
| 色 | color | string | 必須 | 既存値 | HEXカラーコード |
| 通知担当者 | time_off_user_leave_types | relation | 任意 | 既存値 | 複数選択可 |
| 休暇単位 | request_unit | enum | 任意 | 既存値 | RequestUnit |
| 祝日含む | include_public_holidays_in_duration | boolean | 任意 | 既存値 | - |
| 証明書添付可 | support_document | boolean | 任意 | 既存値 | - |
| ダッシュボード表示 | show_on_dashboard | boolean | 任意 | 既存値 | - |
| 時間タイプ | time_type | enum | 任意 | 既存値 | TimeType |
| ネガティブキャップ許可 | allows_negative | boolean | 条件付き | 既存値 | - |
| 最大ネガティブキャップ | max_allowed_negative | integer | 条件付き必須 | 既存値 | 整数 |

## 表示項目

なし（入力専用画面）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、データベースのレコードを更新します。
- 保存前にcompany_idとcreator_idを現在のユーザー情報から自動設定
- 保存成功後、通知メッセージを表示
- 詳細画面（ViewLeaveType）にリダイレクト

### 2-表示ボタン押下

休暇タイプ詳細画面（ViewLeaveType）に遷移します。

### 3-削除ボタン押下

確認ダイアログ表示後、ソフトデリートを実行します。
- 削除成功後、通知メッセージを表示
- 一覧画面にリダイレクト

### 4-割当要否変更（ライブ更新）

requires_allocationの値が変更されると：
- YES選択時：employee_requestsとallocation_validation_typeフィールドを表示
- NO選択時：上記フィールドを非表示

### 5-ネガティブキャップ許可変更（ライブ更新）

allows_negativeがtrueに変更されると：
- max_allowed_negativeフィールドを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | time_off_leave_types | UPDATE | 休暇タイプレコードを更新 |
| 保存ボタン押下 | time_off_user_leave_types | SYNC | 通知担当者との関連を同期 |
| 削除ボタン押下 | time_off_leave_types | UPDATE | deleted_atをセット |

### テーブル別更新項目詳細

#### time_off_leave_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | leave_validation_type | フォーム入力値 | - |
| UPDATE | requires_allocation | フォーム入力値 | - |
| UPDATE | employee_requests | フォーム入力値 | 条件付き |
| UPDATE | allocation_validation_type | フォーム入力値 | 条件付き |
| UPDATE | color | フォーム入力値 | HEX形式 |
| UPDATE | request_unit | フォーム入力値 | - |
| UPDATE | include_public_holidays_in_duration | フォーム入力値 | boolean |
| UPDATE | support_document | フォーム入力値 | boolean |
| UPDATE | show_on_dashboard | フォーム入力値 | boolean |
| UPDATE | time_type | フォーム入力値 | - |
| UPDATE | allows_negative | フォーム入力値 | boolean |
| UPDATE | max_allowed_negative | フォーム入力値 | 整数 |
| UPDATE | company_id | ログインユーザーのdefault_company_id | 自動設定 |
| UPDATE | creator_id | ログインユーザーのid | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| save.success | 成功 | 更新完了 | 休暇タイプが正常に更新されました |
| delete.success | 成功 | 削除完了 | 休暇タイプが正常に削除されました |
| validation.error | エラー | 入力エラー | 入力内容を確認してください |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| レコードが存在しない | 404エラー画面を表示 |
| バリデーションエラー | エラーメッセージをフィールド横に表示 |
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| 権限不足 | アクセス拒否画面を表示 |
| 楽観的ロック違反 | 競合エラーメッセージを表示 |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装
- フォームフィールドの条件付き表示はlive()メソッドで実現
- 作成画面と同じフォームスキーマを共有
- サブナビゲーションにConfigurationsクラスターの他リソースへのリンクを表示
