# 画面設計書 354-休暇タイプ詳細

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける休暇タイプ詳細画面の設計仕様を定義します。

### 本画面の処理概要

休暇タイプ詳細画面は、休暇タイプの設定内容を詳細に表示するための画面です。

**業務上の目的・背景**：休暇タイプの設定内容を確認し、必要に応じて編集や削除を行うための起点となる画面です。承認フロー、割当設定、表示設定などの全ての属性を一覧で確認できます。

**画面へのアクセス方法**：休暇タイプ一覧画面（No.351）の行クリックまたは「表示」アクションから遷移、または休暇タイプ作成・編集画面からの保存成功時にリダイレクトされます。

**主要な操作・処理内容**：
1. 休暇タイプの基本情報の表示
2. 割当設定の確認
3. 表示オプションの確認
4. 詳細設定の確認
5. 編集画面への遷移
6. 削除操作

**画面遷移**：
- 「編集」ボタン → 休暇タイプ編集画面（No.353）
- 「削除」ボタン → 削除後、一覧画面（No.351）へ

**権限による表示制御**：休暇タイプの詳細は通常、人事担当者または管理者が確認します。一般従業員は閲覧のみ可能な場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-012 | 休暇タイプ管理 | 主機能 | 休暇タイプの詳細表示 |

## 画面種別

詳細（View）

## URL/ルーティング

`/time-off/configurations/leave-types/{record}`

## 画面構成

3カラムグリッドレイアウト：
- ヘッダーアクション（編集ボタン、削除ボタン）
- 左側（2カラム幅）：一般セクション
  - 名前（大きいテキスト表示）
  - 承認タイプ（バッジ）
  - 割当要否（バッジ）
  - 従業員リクエスト（条件付き表示、バッジ）
  - 割当承認タイプ（条件付き表示、バッジ）
- 右側（1カラム幅）：
  - 表示オプションセクション（色表示）
  - 設定セクション
    - 通知担当者リスト
    - 休暇単位（バッジ）
    - 祝日含む（アイコン）
    - 証明書添付可（アイコン）
    - ダッシュボード表示（アイコン）
    - 時間タイプ（バッジ）
    - ネガティブキャップ許可（条件付き、アイコン）
    - 最大ネガティブキャップ（条件付き）

## 入出力項目

なし（表示専用画面）

## 表示項目

| 項目名 | 物理名 | データ型 | 表示形式 | 条件付き表示 |
|--------|--------|----------|----------|-------------|
| 名前 | name | string | 大きいテキスト + アイコン | - |
| 承認タイプ | leave_validation_type | enum | バッジ + アイコン | - |
| 割当要否 | requires_allocation | enum | バッジ + アイコン | - |
| 従業員リクエスト | employee_requests | enum | バッジ + アイコン | 割当要否がYESの場合 |
| 割当承認タイプ | allocation_validation_type | enum | バッジ + アイコン | 割当要否がYESの場合 |
| 色 | color | string | カラー表示 | - |
| 通知担当者 | notifiedTimeOffOfficers | relation | リスト + アイコン | - |
| 休暇単位 | request_unit | enum | バッジ + アイコン | - |
| 祝日含む | include_public_holidays_in_duration | boolean | アイコン | - |
| 証明書添付可 | support_document | boolean | アイコン | - |
| ダッシュボード表示 | show_on_dashboard | boolean | アイコン | - |
| 時間タイプ | time_type | enum | バッジ + アイコン | - |
| ネガティブキャップ許可 | allows_negative | boolean | アイコン | 割当要否がYESの場合 |
| 最大ネガティブキャップ | max_allowed_negative | integer | 数値 + アイコン | 割当要否がYESかつネガティブ許可の場合 |

## イベント仕様

### 1-編集ボタン押下

休暇タイプ編集画面（EditLeaveType）に遷移します。

### 2-削除ボタン押下

確認ダイアログ表示後、ソフトデリートを実行します。
- 削除成功後、通知メッセージを表示
- 一覧画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | time_off_leave_types | SELECT | 休暇タイプ情報を取得 |
| 画面表示 | time_off_user_leave_types | SELECT | 通知担当者情報を取得 |
| 削除ボタン押下 | time_off_leave_types | UPDATE | deleted_atをセット |

### テーブル別更新項目詳細

#### time_off_leave_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE id = {record} | レコード取得 |
| UPDATE（削除時） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| delete.success | 成功 | 削除完了 | 休暇タイプが正常に削除されました |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| レコードが存在しない | 404エラー画面を表示 |
| レコードが削除済み | 一覧画面にリダイレクト |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装
- Infolistコンポーネントを使用してデータを表示
- TextEntryにはプレースホルダー「—」を設定
- 条件付き表示はvisible()メソッドで制御
- IconEntryでboolean値をアイコン表示
- ColorEntryで色を視覚的に表示
- サブナビゲーションにConfigurationsクラスターの他リソースへのリンクを表示
