# 画面設計書 355-累積プラン一覧

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける累積プラン一覧画面の設計仕様を定義します。

### 本画面の処理概要

累積プラン一覧画面は、休暇の累積（アキュムレーション）プランを一覧表示し、管理するための画面です。累積プランは、勤続期間に応じて休暇日数が自動的に増加する仕組みを定義します。

**業務上の目的・背景**：多くの企業では、従業員の勤続期間に応じて有給休暇日数が増加する制度を採用しています。累積プランは、この自動付与の仕組みを定義し、手動での休暇割当作業を削減します。

**画面へのアクセス方法**：サイドナビゲーションから「Time Off」モジュールを選択し、「Configurations」クラスターの「Accrual Plans」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 累積プラン一覧の表示と検索
2. 新規累積プランの作成（作成ボタンから作成画面へ遷移）
3. 既存累積プランの詳細表示・編集・削除
4. 一括削除操作
5. マイルストーン（レベル）数の確認

**画面遷移**：
- 「新規作成」ボタン → 累積プラン作成画面（No.356）
- 行クリックまたは「表示」アクション → 累積プラン詳細画面（No.358）
- 「編集」アクション → 累積プラン編集画面（No.357）

**権限による表示制御**：累積プランの管理は通常、人事担当者または管理者権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-013 | 休暇積立プラン管理 | 主機能 | 累積プランの一覧表示・作成・編集・削除 |

## 画面種別

一覧（List）

## URL/ルーティング

`/time-off/configurations/accrual-plans`

## 画面構成

- ヘッダーアクション（新規作成ボタン）
- データテーブル
  - 名前カラム
  - レベル数カラム
  - 行アクション（表示・編集・削除）
  - 一括アクション（削除）

## 入出力項目

なし（一覧画面のため）

## 表示項目

| 項目名 | 物理名 | データ型 | 表示形式 | 初期表示 | ソート | 検索 |
|--------|--------|----------|----------|----------|--------|------|
| 名前 | name | string | テキスト | 表示 | - | 可 |
| レベル数 | leaveAccrualLevels | relation | 数値（カウント） | 表示 | - | - |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「New Accrual Plan」ボタンをクリックすると、累積プラン作成画面（CreateAccrualPlan）に遷移します。

### 2-行アクション - 表示

選択した累積プランの詳細画面（ViewAccrualPlan）に遷移します。

### 3-行アクション - 編集

選択した累積プランの編集画面（EditAccrualPlan）に遷移します。

### 4-行アクション - 削除

確認ダイアログ表示後、レコードを削除します。成功時に通知メッセージを表示します。

### 5-一括アクション - 削除

選択した複数の累積プランを一括で削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | time_off_leave_accrual_plans | DELETE | レコードを削除 |
| 一覧表示 | time_off_leave_accrual_plans | SELECT | 累積プラン一覧を取得 |
| 一覧表示 | time_off_leave_accrual_levels | SELECT | レベル数をカウント |

### テーブル別更新項目詳細

#### time_off_leave_accrual_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {選択ID} | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| delete.success | 成功 | 削除完了 | 累積プランが正常に削除されました |
| bulk-delete.success | 成功 | 一括削除完了 | 選択した累積プランが正常に削除されました |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| 外部キー制約違反（削除時） | エラー通知を表示し、削除をスキップ |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装
- ソフトデリートは使用していない（物理削除）
- レベル数はリレーションのcount()で計算
- シンプルなテーブル構成で検索とソートは名前カラムのみ対応
