# 画面設計書 356-累積プラン作成

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける累積プラン作成画面の設計仕様を定義します。

### 本画面の処理概要

累積プラン作成画面は、新しい休暇累積プランを登録するためのフォーム画面です。

**業務上の目的・背景**：勤続期間に応じた休暇日数の自動付与ルールを定義する累積プランを作成します。累積プランは、いつ休暇が付与されるか、繰越日がいつかなどの基本設定を行います。

**画面へのアクセス方法**：累積プラン一覧画面（No.355）の「New Accrual Plan」ボタンをクリック、またはURL直接アクセスで遷移します。

**主要な操作・処理内容**：
1. プラン名の入力
2. 勤務時間ベースの設定
3. 累積獲得時間の設定（期間終了時/期間開始時）
4. 繰越日の設定（契約日/他の日付）
5. 繰越日付の詳細設定（日・月選択）
6. ステータスの設定
7. 保存して詳細画面へ遷移

**画面遷移**：
- 保存成功時 → 累積プラン詳細画面（No.358）
- キャンセル/戻る → 累積プラン一覧画面（No.355）

**権限による表示制御**：累積プランの作成は通常、人事担当者または管理者権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-013 | 休暇積立プラン管理 | 主機能 | 新規累積プランの作成 |

## 画面種別

登録（Create）

## URL/ルーティング

`/time-off/configurations/accrual-plans/create`

## 画面構成

2カラムレイアウト構成：
- セクション
  - プラン名入力フィールド
  - 勤務時間ベーストグル
  - 累積獲得時間（ラジオボタン）
  - 繰越日（ラジオボタン）
  - 繰越日付フィールドセット（条件付き表示）
    - 日選択
    - 月選択
  - ステータストグル

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 入力制限 |
|--------|--------|----------|------|--------|----------|
| 名前 | name | string | 必須 | なし | - |
| 勤務時間ベース | is_based_on_worked_time | boolean | 任意 | false | - |
| 累積獲得時間 | accrued_gain_time | enum | 必須 | END | AccruedGainTime |
| 繰越日 | carryover_date | enum | 必須 | OTHER | CarryoverDate |
| 繰越日（日） | carryover_day | integer | 条件付き必須 | 1 | 月の日数範囲 |
| 繰越月 | carryover_month | enum | 条件付き必須 | JAN | CarryoverMonth |
| ステータス | is_active | boolean | 任意 | false | - |

## 表示項目

なし（入力専用画面）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、データベースに新規レコードを挿入します。
- 保存前にcompany_idとcreator_idを現在のユーザー情報から自動設定
- 保存成功後、通知メッセージを表示
- 詳細画面（ViewAccrualPlan）にリダイレクト

### 2-繰越日変更（ライブ更新）

carryover_dateの値が変更されると：
- OTHER選択時：carryover_dayとcarryover_monthフィールドを表示
- 契約日選択時：上記フィールドを非表示

### 3-繰越月変更（リアクティブ）

carryover_monthの値が変更されると：
- carryover_dayの選択肢を該当月の日数に合わせて更新
- 例：2月選択時は1-28/29、12月選択時は1-31

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | time_off_leave_accrual_plans | INSERT | 新規累積プランレコードを作成 |

### テーブル別更新項目詳細

#### time_off_leave_accrual_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | is_based_on_worked_time | フォーム入力値 | boolean |
| INSERT | accrued_gain_time | フォーム入力値 | デフォルト: END |
| INSERT | carryover_date | フォーム入力値 | デフォルト: OTHER |
| INSERT | carryover_day | フォーム入力値 | 条件付き |
| INSERT | carryover_month | フォーム入力値 | 条件付き |
| INSERT | is_active | フォーム入力値 | boolean |
| INSERT | company_id | ログインユーザーのdefault_company_id | 自動設定 |
| INSERT | creator_id | ログインユーザーのid | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| create.success | 成功 | 作成完了 | 累積プランが正常に作成されました |
| validation.name.required | エラー | 入力エラー | 名前は必須です |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| バリデーションエラー | エラーメッセージをフィールド横に表示 |
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのCreateRecordページを継承して実装
- フォームフィールドの条件付き表示はlive()とvisible()メソッドで実現
- carryover_dayの選択肢は月に応じて動的に生成
- サブナビゲーション位置はSubNavigationPosition::Start
- サブナビゲーションにConfigurationsクラスターの他リソースへのリンクを表示
