# 画面設計書 357-累積プラン編集

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける累積プラン編集画面の設計仕様を定義します。

### 本画面の処理概要

累積プラン編集画面は、既存の休暇累積プランの設定を変更するためのフォーム画面です。

**業務上の目的・背景**：企業の休暇ポリシー変更に伴い、既存の累積プランの設定を更新する必要があります。累積獲得時間や繰越日などの設定を変更できます。

**画面へのアクセス方法**：累積プラン一覧画面（No.355）の行アクションから「編集」を選択、または累積プラン詳細画面（No.358）のヘッダーアクションから「編集」ボタンをクリックして遷移します。

**主要な操作・処理内容**：
1. 既存の累積プラン情報の表示と編集
2. プラン名の変更
3. 各種設定の変更
4. 保存して詳細画面へ遷移
5. 削除操作

**画面遷移**：
- 保存成功時 → 累積プラン詳細画面（No.358）
- 「表示」ボタン → 累積プラン詳細画面（No.358）
- 「削除」ボタン → 削除後、一覧画面（No.355）へ
- サブナビゲーション → マイルストーン管理画面

**権限による表示制御**：累積プランの編集は通常、人事担当者または管理者権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-013 | 休暇積立プラン管理 | 主機能 | 既存累積プランの編集 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/time-off/configurations/accrual-plans/{record}/edit`

## 画面構成

2カラムレイアウト構成：
- ヘッダーアクション（表示ボタン、削除ボタン）
- レコードサブナビゲーション（詳細・編集・マイルストーン）
- セクション
  - プラン名入力フィールド
  - 勤務時間ベーストグル
  - 累積獲得時間（ラジオボタン）
  - 繰越日（ラジオボタン）
  - 繰越日付フィールドセット（条件付き表示）
  - ステータストグル

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 入力制限 |
|--------|--------|----------|------|--------|----------|
| 名前 | name | string | 必須 | 既存値 | - |
| 勤務時間ベース | is_based_on_worked_time | boolean | 任意 | 既存値 | - |
| 累積獲得時間 | accrued_gain_time | enum | 必須 | 既存値 | AccruedGainTime |
| 繰越日 | carryover_date | enum | 必須 | 既存値 | CarryoverDate |
| 繰越日（日） | carryover_day | integer | 条件付き必須 | 既存値 | 月の日数範囲 |
| 繰越月 | carryover_month | enum | 条件付き必須 | 既存値 | CarryoverMonth |
| ステータス | is_active | boolean | 任意 | 既存値 | - |

## 表示項目

なし（入力専用画面）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、データベースのレコードを更新します。
- 保存前にcompany_idとcreator_idを現在のユーザー情報から自動設定
- 保存成功後、通知メッセージを表示
- 詳細画面（ViewAccrualPlan）にリダイレクト

### 2-表示ボタン押下

累積プラン詳細画面（ViewAccrualPlan）に遷移します。

### 3-削除ボタン押下

確認ダイアログ表示後、レコードを削除します。
- 削除成功後、通知メッセージを表示
- 一覧画面にリダイレクト

### 4-繰越日変更（ライブ更新）

carryover_dateの値が変更されると：
- OTHER選択時：carryover_dayとcarryover_monthフィールドを表示
- 契約日選択時：上記フィールドを非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | time_off_leave_accrual_plans | UPDATE | 累積プランレコードを更新 |
| 削除ボタン押下 | time_off_leave_accrual_plans | DELETE | レコードを削除 |

### テーブル別更新項目詳細

#### time_off_leave_accrual_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | is_based_on_worked_time | フォーム入力値 | boolean |
| UPDATE | accrued_gain_time | フォーム入力値 | - |
| UPDATE | carryover_date | フォーム入力値 | - |
| UPDATE | carryover_day | フォーム入力値 | 条件付き |
| UPDATE | carryover_month | フォーム入力値 | 条件付き |
| UPDATE | is_active | フォーム入力値 | boolean |
| UPDATE | company_id | ログインユーザーのdefault_company_id | 自動設定 |
| UPDATE | creator_id | ログインユーザーのid | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| save.success | 成功 | 更新完了 | 累積プランが正常に更新されました |
| delete.success | 成功 | 削除完了 | 累積プランが正常に削除されました |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| レコードが存在しない | 404エラー画面を表示 |
| バリデーションエラー | エラーメッセージをフィールド横に表示 |
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装
- HasRecordNavigationTabsトレイトを使用してレコードナビゲーションを実装
- 作成画面と同じフォームスキーマを共有
- レコードサブナビゲーションにView/Edit/ManageMilestoneページへのリンクを表示
