# 画面設計書 358-累積プラン詳細

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける累積プラン詳細画面の設計仕様を定義します。

### 本画面の処理概要

累積プラン詳細画面は、累積プランの設定内容を詳細に表示するための画面です。

**業務上の目的・背景**：累積プランの設定内容を確認し、必要に応じて編集や削除を行うための起点となる画面です。マイルストーン管理画面へのナビゲーションも提供します。

**画面へのアクセス方法**：累積プラン一覧画面（No.355）の行クリックまたは「表示」アクションから遷移、または累積プラン作成・編集画面からの保存成功時にリダイレクトされます。

**主要な操作・処理内容**：
1. 累積プランの基本情報の表示
2. 累積設定の確認
3. 繰越設定の確認
4. 編集画面への遷移
5. マイルストーン管理画面への遷移
6. 削除操作

**画面遷移**：
- 「編集」ボタン → 累積プラン編集画面（No.357）
- 「削除」ボタン → 削除後、一覧画面（No.355）へ
- サブナビゲーション「Milestones」 → マイルストーン管理画面

**権限による表示制御**：累積プランの詳細は通常、人事担当者または管理者が確認します。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-013 | 休暇積立プラン管理 | 主機能 | 累積プランの詳細表示 |

## 画面種別

詳細（View）

## URL/ルーティング

`/time-off/configurations/accrual-plans/{record}`

## 画面構成

2カラムグリッドレイアウト：
- ヘッダーアクション（編集ボタン、削除ボタン）
- レコードサブナビゲーション（詳細・編集・マイルストーン）
- 基本情報セクション（2カラム幅）
  - 名前（アイコン付き）
  - 勤務時間ベース（アイコン）
  - 累積獲得時間（アイコン付き）
  - 繰越日（アイコン付き）
  - 繰越日（日）（アイコン付き）
  - 繰越月（アイコン付き）

## 入出力項目

なし（表示専用画面）

## 表示項目

| 項目名 | 物理名 | データ型 | 表示形式 | 条件付き表示 |
|--------|--------|----------|----------|-------------|
| 名前 | name | string | テキスト + アイコン | - |
| 勤務時間ベース | is_based_on_worked_time | boolean | アイコン | - |
| 累積獲得時間 | accrued_gain_time | enum | テキスト + アイコン | - |
| 繰越日 | carryover_date | enum | テキスト + アイコン | - |
| 繰越日（日） | carryover_day | integer | テキスト + アイコン | - |
| 繰越月 | carryover_month | enum | テキスト + アイコン | - |

## イベント仕様

### 1-編集ボタン押下

累積プラン編集画面（EditAccrualPlan）に遷移します。

### 2-削除ボタン押下

確認ダイアログ表示後、レコードを削除します。
- 削除成功後、通知メッセージを表示
- 一覧画面にリダイレクト

### 3-サブナビゲーション「Milestones」クリック

マイルストーン管理画面（ManageMilestone）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | time_off_leave_accrual_plans | SELECT | 累積プラン情報を取得 |
| 削除ボタン押下 | time_off_leave_accrual_plans | DELETE | レコードを削除 |

### テーブル別更新項目詳細

#### time_off_leave_accrual_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE id = {record} | レコード取得 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| delete.success | 成功 | 削除完了 | 累積プランが正常に削除されました |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| レコードが存在しない | 404エラー画面を表示 |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装
- HasRecordNavigationTabsトレイトを使用してレコードナビゲーションを実装
- Infolistコンポーネントを使用してデータを表示
- TextEntryにはプレースホルダー「—」を設定
- IconEntryでboolean値をアイコン表示
- レコードサブナビゲーションにView/Edit/ManageMilestoneページへのリンクを表示
- MilestoneRelationManagerでマイルストーンの管理が可能
