# 画面設計書 36-支払条件詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払条件詳細画面の設計仕様を定義するものです。この画面は会計モジュールの支払条件リソースの一部として、支払条件の詳細情報を閲覧するための読み取り専用ビューを提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払条件は、請求書や見積書において顧客・仕入先との支払いに関する取り決めを定義するマスタデータです。この詳細画面は、登録された支払条件の全情報（名称、早期支払割引設定、税金減額方法、備考など）を一目で確認できるビューを提供し、会計担当者や管理者が支払条件の設定内容を検証・確認する際に使用されます。

**画面へのアクセス方法**：支払条件一覧画面から該当レコードの「表示」ボタンをクリック、または一覧の行をクリックしてアクセスします。また、支払条件作成・編集画面からの保存成功後にもリダイレクトされます。URLパターンは `/payment-terms/{record}` です。

**主要な操作・処理内容**：
1. 支払条件の基本情報（名称）の表示
2. 早期支払割引設定の表示（有効/無効、割引率、割引日数）
3. 税金減額方法の表示
4. 備考の表示
5. ヘッダーアクションからの編集・削除操作
6. サブナビゲーションからの関連ページへの遷移

**画面遷移**：
- 遷移元：支払条件一覧画面、支払条件作成画面（保存成功時）、支払条件編集画面（保存成功時）
- 遷移先：「編集」ボタンで編集画面へ、「削除」ボタンで削除後一覧画面へ、サブナビゲーションで支払期限管理画面へ

**権限による表示制御**：システムの権限設定に基づき、支払条件リソースへの表示権限を持つユーザーがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-023 | 支払条件管理 | 主機能 | 支払条件の詳細表示 |
| - | 支払条件一覧 | 遷移元機能 | 一覧からの詳細遷移 |
| - | 支払条件編集 | 遷移先機能 | 詳細からの編集遷移 |
| - | 支払期限管理 | 関連機能 | サブナビゲーションからの遷移 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/payment-terms/{record}`
- ルート名: `filament.accounts.resources.payment-terms.view`
- HTTPメソッド: GET

## 画面構成

```
+------------------------------------------------------------------+
| サブナビゲーション（上部配置）                                      |
|  [詳細(現在)] [編集] [支払期限]                                    |
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  支払条件の詳細                    [編集] [削除]                   |
+------------------------------------------------------------------+
| セクション（3カラムグリッド）                                       |
| +--------------------------------------------------------------+ |
| |                                                                | |
| | 支払条件名: Net 30                                             | |
| |                                                                | |
| | 早期割引: ○ 有効 / × 無効                                       | |
| |                                                                | |
| | 割引率: 2%                     割引日数: 10日以内               | |
| |                                                                | |
| | 税金減額: Included                                              | |
| |                                                                | |
| | 備考:                                                          | |
| | +----------------------------------------------------------+ | |
| | | [HTML形式のテキスト]                                       | | |
| | +----------------------------------------------------------+ | |
| |                                                                | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
```

## 入出力項目

本画面は読み取り専用のため、入力項目はありません。

## 表示項目

| 項目名 | 項目ID | データ型 | 表示条件 | 備考 |
|--------|--------|----------|---------|------|
| 支払条件名 | name | string | 常時 | アイコン: briefcase |
| 早期割引 | early_discount | boolean | 常時 | IconEntry（○/×） |
| 割引率 | discount_percentage | numeric | 常時 | %サフィックス、プレースホルダー: - |
| 割引日数 | discount_days | integer | 常時 | サフィックス: 日以内、プレースホルダー: - |
| 税金減額 | early_pay_discount | enum | 常時 | プレースホルダー: - |
| 備考 | note | text | 常時 | HTML形式でレンダリング |

## イベント仕様

### 1-編集ボタン押下

**トリガー**: ヘッダーの「編集」ボタンをクリック

**処理フロー**:
1. 支払条件編集画面への遷移
2. URLは `/payment-terms/{id}/edit`

### 2-削除ボタン押下

**トリガー**: ヘッダーの「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、ソフトデリート実行
3. 成功通知の表示
4. 一覧画面へのリダイレクト

### 3-サブナビゲーション

**トリガー**: サブナビゲーションのリンクをクリック

**処理フロー**:
1. 詳細: 現在のページ
2. 編集: 支払条件編集画面へ遷移
3. 支払期限: 支払期限管理画面へ遷移（/payment-terms/{id}/payment-due-terms）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | accounts_payment_terms | UPDATE | deleted_atを設定（ソフトデリート） |

### テーブル別更新項目詳細

#### accounts_payment_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| delete.notification.title | 成功 | 支払条件が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 支払条件がアーカイブされました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面表示 | 指定された支払条件が見つかりません |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |

## 備考

- 本画面はFilament PHPのViewRecordページクラスを継承して実装されています
- サブナビゲーションは画面上部に配置されます（SubNavigationPosition::Top）
- サブナビゲーションには詳細、編集、支払期限の3つのリンクが表示されます
- 表示はInfolist（情報リスト）コンポーネントを使用しており、読み取り専用です
- 早期割引はIconEntryでboolean値を○/×アイコンで視覚的に表示します
- 備考はHtmlString形式でレンダリングされ、リッチテキストの書式が保持されます
- 削除はソフトデリート（論理削除）として処理されます
- 3カラムグリッドレイアウトを使用しています
