# 画面設計書 360-必須日一覧

## 概要

本ドキュメントは、Time Off（休暇）モジュールにおける必須日一覧画面の設計仕様を定義します。

### 本画面の処理概要

必須日一覧画面は、従業員が必ず出勤しなければならない日（必須出勤日）を一覧表示し、管理するための画面です。モーダルフォームで作成・編集を行う一体型の管理画面です。

**業務上の目的・背景**：繁忙期や重要なイベント日など、従業員の出勤が必須となる日を事前に定義し、休暇申請時に警告を表示したり、申請を制限したりするために使用します。

**画面へのアクセス方法**：サイドナビゲーションから「Time Off」モジュールを選択し、「Configurations」クラスターの「Mandatory Days」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 必須日一覧の表示と検索・フィルタリング
2. 新規必須日の作成（モーダルフォーム）
3. 既存必須日の編集（モーダルフォーム）
4. 必須日の削除
5. 一括削除操作
6. グループ化表示（名前・作成者・会社・開始日・終了日別）

**画面遷移**：
- 本画面はモーダルで作成・編集を完結するため、別画面への遷移なし
- 「表示」アクション → 詳細モーダル表示

**権限による表示制御**：必須日の管理は通常、人事担当者または管理者権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TOFF-015 | 必須出勤日管理 | 主機能 | 必須日の一覧表示・作成・編集・削除 |

## 画面種別

一覧（List）+ モーダル管理

## URL/ルーティング

`/time-off/configurations/mandatory-days`

## 画面構成

- ヘッダーアクション（新規作成ボタン → モーダルフォーム）
- データテーブル
  - 名前カラム（ソート・検索可）
  - 会社カラム（ソート・検索可）
  - 作成者カラム（ソート・検索可）
  - 開始日カラム（ソート・検索可）
  - 終了日カラム（ソート・検索可）
  - グループ化オプション
  - フィルタ機能
  - 行アクション（表示・編集・削除）
  - 一括アクション（削除）

## 入出力項目

### 作成・編集モーダルフォーム

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 入力制限 |
|--------|--------|----------|------|--------|----------|
| 色 | color | string | 必須 | #000000 | HEXカラーコード |
| 名前 | name | string | 必須 | なし | - |
| 開始日 | start_date | date | 必須 | 今日 | - |
| 終了日 | end_date | date | 必須 | 今日 | - |

## 表示項目

| 項目名 | 物理名 | データ型 | 表示形式 | 初期表示 | ソート | 検索 |
|--------|--------|----------|----------|----------|--------|------|
| 名前 | name | string | テキスト | 表示 | 可 | 可 |
| 会社 | company.name | relation | テキスト | 表示 | 可 | 可 |
| 作成者 | createdBy.name | relation | テキスト | 表示 | 可 | 可 |
| 開始日 | start_date | date | 日付 | 表示 | 可 | 可 |
| 終了日 | end_date | date | 日付 | 表示 | 可 | 可 |

## イベント仕様

### 1-新規作成ボタン押下

モーダルフォームを表示します。
- 保存前にcompany_idとcreator_idを現在のユーザー情報から自動設定
- 保存成功後、通知メッセージを表示

### 2-行アクション - 表示

選択した必須日の詳細情報をモーダルで表示します。

### 3-行アクション - 編集

モーダルフォームで必須日情報を編集します。
- 保存成功後、通知メッセージを表示

### 4-行アクション - 削除

確認ダイアログ表示後、レコードを削除します。
- 削除成功後、通知メッセージを表示

### 5-一括アクション - 削除

選択した複数の必須日を一括で削除します。

### 6-グループ化

テーブルをグループ化して表示できます：
- 名前でグループ化
- 作成者でグループ化
- 会社名でグループ化
- 開始日でグループ化
- 終了日でグループ化

### 7-フィルタ

以下の条件でフィルタリング可能：
- 会社（SelectFilter）
- 作成者（SelectFilter）
- 名前（QueryBuilder TextConstraint）
- 開始日（QueryBuilder TextConstraint）
- 終了日（QueryBuilder TextConstraint）
- 作成日（QueryBuilder DateConstraint）
- 更新日（QueryBuilder DateConstraint）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | time_off_leave_mandatory_days | INSERT | 必須日レコードを作成 |
| 編集保存 | time_off_leave_mandatory_days | UPDATE | 必須日レコードを更新 |
| 削除アクション | time_off_leave_mandatory_days | DELETE | レコードを削除 |
| 一覧表示 | time_off_leave_mandatory_days | SELECT | 必須日一覧を取得 |

### テーブル別更新項目詳細

#### time_off_leave_mandatory_days

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | color | フォーム入力値 | HEXカラー |
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | start_date | フォーム入力値 | 日付 |
| INSERT/UPDATE | end_date | フォーム入力値 | 日付 |
| INSERT | company_id | ログインユーザーのdefault_company_id | 自動設定 |
| INSERT | creator_id | ログインユーザーのid | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | メッセージ内容 |
|------------|------|---------|---------------|
| create.success | 成功 | 作成完了 | 必須日が正常に作成されました |
| edit.success | 成功 | 更新完了 | 必須日が正常に更新されました |
| delete.success | 成功 | 削除完了 | 必須日が正常に削除されました |
| bulk-delete.success | 成功 | 一括削除完了 | 選択した必須日が正常に削除されました |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | エラーメッセージを表示し、処理を中断 |
| バリデーションエラー | モーダル内にエラーメッセージを表示 |
| 権限不足 | アクセス拒否画面を表示 |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装
- 作成・編集はモーダルフォームで完結
- テーブル名はtime_off_leave_mandatory_days
- 日付入力はDatePickerコンポーネントを使用（ネイティブは無効）
- 色はColorPickerコンポーネントでHEXカラーを選択
- 祝日一覧画面と同様のUIパターンを採用
- 必須日は休暇申請時のバリデーションや警告表示に使用される
