# 画面設計書 361-タイムシート管理

## 概要

本ドキュメントは、Aureus ERPシステムのタイムシート管理画面の設計仕様を定義します。

### 本画面の処理概要

タイムシート管理画面は、従業員がプロジェクトおよびタスクに費やした作業時間を記録・管理するための中核的な機能を提供します。

**業務上の目的・背景**：プロジェクト管理において、各タスクに費やされた時間を正確に把握することは、プロジェクトの進捗管理、リソース配分の最適化、およびコスト管理において不可欠です。本画面は、従業員が日々の作業時間を簡単に記録し、マネージャーがチーム全体の工数を俯瞰的に把握できる環境を提供します。また、記録されたタイムシートデータはタスクの実績時間として自動的に集計され、プロジェクトの進捗率や残作業時間の算出に活用されます。

**画面へのアクセス方法**：サイドメニューの「Timesheets」グループから「タイムシート」を選択してアクセスします。

**主要な操作・処理内容**：
1. タイムシートエントリの一覧表示・検索・フィルタリング
2. 新規タイムシートエントリの作成（日付、従業員、プロジェクト、タスク、作業内容、作業時間の入力）
3. 既存タイムシートエントリの編集・削除
4. 日付・従業員・プロジェクト・タスク別のグループ化表示
5. 作業時間の合計サマリー表示
6. 「マイタイムシート」プリセットビューでの自分の記録のみの表示

**画面遷移**：本画面はManageRecordsページとして単独で機能し、モーダルダイアログを使用して作成・編集を行います。プロジェクト詳細画面やタスク詳細画面からのタイムシート管理機能へのリンクが存在します。

**権限による表示制御**：ログインユーザーは全てのタイムシートを閲覧可能ですが、「マイタイムシート」タブでは自分が記録したエントリのみがフィルタリングされて表示されます。作成時にはcreator_idが自動的に設定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TS-001 | タイムシート一覧 | 主機能 | タイムシートデータの一覧表示と検索 |
| FN-TS-002 | タイムシート作成 | 主機能 | 新規タイムシートエントリの作成 |
| FN-TS-003 | タイムシート編集 | 主機能 | 既存タイムシートエントリの編集 |
| FN-TS-004 | タイムシート削除 | 主機能 | タイムシートエントリの削除 |
| FN-PROJ-005 | タスク管理 | 遷移先機能 | タスクの時間更新との連携 |

## 画面種別

管理（ManageRecords）画面

## URL/ルーティング

`/admin/timesheets`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン（CreateAction）
- テーブルビュー切替タブ
  - 「マイタイムシート」プリセットビュー
- データテーブル
  - 列: 日付、従業員、プロジェクト、タスク、説明、作業時間、作成日時、更新日時
  - グループ化オプション: 日付、従業員、プロジェクト、タスク、作成者
  - フィルタ: 日付範囲、従業員、プロジェクト、タスク、作成者
- 行アクション
  - 編集（EditAction）
  - 削除（DeleteAction）
- 一括アクション
  - 一括削除（DeleteBulkAction）

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 項目ID | 型 | 必須 | バリデーション | 説明 |
|--------|--------|-----|------|----------------|------|
| タイプ | type | Hidden | - | - | 固定値「projects」 |
| 日付 | date | DatePicker | 必須 | 日付形式 | 作業実施日 |
| 従業員 | user_id | Select | 必須 | users関連 | 作業を行った従業員 |
| プロジェクト | project_id | Select | 必須 | projects関連 | 対象プロジェクト |
| タスク | task_id | Select | 必須 | tasks関連（project_idでフィルタ） | 対象タスク |
| 説明 | name | TextInput | 任意 | - | 作業内容の説明 |
| 作業時間 | unit_amount | TextInput | 必須 | 数値、0〜99999999999 | 費やした時間（時間単位） |

## 表示項目

### テーブル列

| 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|--------|--------|-----|--------|------|------|
| 日付 | date | TextColumn | 可 | - | Y-m-d形式で表示 |
| 従業員 | user.name | TextColumn | 可 | 可 | 従業員名 |
| プロジェクト | project.name | TextColumn | 可 | 可 | プロジェクト名 |
| タスク | task.title | TextColumn | 可 | 可 | タスクタイトル |
| 説明 | name | TextColumn | 可 | 可 | 作業内容 |
| 作業時間 | unit_amount | TextColumn | 可 | - | 時:分形式で表示、合計サマリー付き |
| 作成日時 | created_at | TextColumn | 可 | - | デフォルト非表示 |
| 更新日時 | updated_at | TextColumn | 可 | - | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「New Timesheet」ボタンを押下すると、モーダルダイアログが表示されタイムシートエントリの入力フォームが開きます。creator_idには自動的に現在のログインユーザーIDが設定されます。

### 2-プロジェクト選択変更

プロジェクト選択（project_id）を変更すると、タスク選択（task_id）がリセットされ、選択されたプロジェクトに紐づくタスクのみがタスク選択肢に表示されます。

### 3-編集アクション

テーブル行の編集アクションをクリックすると、モーダルダイアログで該当レコードの編集フォームが表示されます。保存成功時に成功通知が表示されます。

### 4-削除アクション

テーブル行の削除アクションをクリックすると、確認ダイアログ後にレコードが削除されます。削除成功時に成功通知が表示されます。削除後、関連タスクの時間情報が自動更新されます。

### 5-一括削除アクション

チェックボックスで選択した複数レコードを一括削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | analytic_records | INSERT | タイムシートレコード作成 |
| 新規作成 | projects_tasks | UPDATE | 関連タスクの時間情報更新 |
| 編集保存 | analytic_records | UPDATE | タイムシートレコード更新 |
| 編集保存 | projects_tasks | UPDATE | 関連タスクの時間情報更新 |
| 削除 | analytic_records | DELETE | タイムシートレコード削除 |
| 削除 | projects_tasks | UPDATE | 関連タスクの時間情報更新 |

### テーブル別更新項目詳細

#### analytic_records

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | type | 'projects' | 固定値 |
| INSERT/UPDATE | date | フォーム入力値 | 作業日 |
| INSERT/UPDATE | user_id | フォーム入力値 | 従業員ID |
| INSERT/UPDATE | project_id | フォーム入力値 | プロジェクトID |
| INSERT/UPDATE | task_id | フォーム入力値 | タスクID |
| INSERT/UPDATE | name | フォーム入力値 | 説明 |
| INSERT/UPDATE | unit_amount | フォーム入力値 | 作業時間 |
| INSERT | creator_id | Auth::id() | 作成者ID |

#### projects_tasks（自動更新）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | total_hours_spent | タイムシート合計 + サブタスク合計 | 総作業時間 |
| UPDATE | effective_hours | タスク直接のタイムシート合計 | 実効時間 |
| UPDATE | overtime | spent - allocated（正の場合） | 超過時間 |
| UPDATE | remaining_hours | allocated - spent | 残時間 |
| UPDATE | progress | (spent / allocated) * 100 | 進捗率 |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 新規作成完了時 | Timesheet Created | Timesheet has been created successfully. |
| 成功 | 編集保存完了時 | Timesheet Updated | Timesheet has been updated successfully. |
| 成功 | 削除完了時 | Timesheet Deleted | Timesheet has been deleted successfully. |
| 成功 | 一括削除完了時 | Timesheets Deleted | Selected timesheets have been deleted successfully. |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| 必須項目未入力 | フォームバリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| 作業時間が範囲外 | フォームバリデーションエラー | 0〜99999999999の範囲で入力するよう表示 |
| 関連データ不整合 | データベースエラー | システムエラーメッセージ表示 |

## 備考

- TimesheetモデルはWebkul\Project\Models\Timesheetを使用し、Webkul\Analytic\Models\Recordを継承しています
- タイムシートの作成・更新・削除時に、関連タスクおよび親タスクの時間情報が自動的に再計算されます（updateTaskTimesメソッド）
- 作業時間は時間単位で入力し、表示時には「時:分」形式でフォーマットされます
- テーブルには作業時間の合計（Sum）が表示されます
