# 画面設計書 362-ページ一覧

## 概要

本ドキュメントは、Aureus ERPシステムのウェブサイトページ一覧画面（管理者用）の設計仕様を定義します。

### 本画面の処理概要

ページ一覧画面は、ウェブサイトに表示する静的ページ（コンテンツページ）を管理するための管理者向け機能を提供します。

**業務上の目的・背景**：企業のウェブサイトには、会社概要、利用規約、プライバシーポリシーなど、CMSで管理する必要のある静的コンテンツページが存在します。本画面は、これらのページを一元的に管理し、公開・非公開の制御やSEO設定を行うための機能を提供します。管理者は本画面から迅速にコンテンツを管理し、顧客向けサイトに反映することができます。

**画面へのアクセス方法**：サイドメニューの「Website」グループから「Pages」を選択してアクセスします。

**主要な操作・処理内容**：
1. ウェブサイトページの一覧表示・検索・フィルタリング
2. 新規ページの作成画面への遷移
3. 既存ページの詳細・編集画面への遷移
4. ページの削除・復元・完全削除
5. アーカイブ済みページの表示（プリセットビュー）
6. ページの公開状態の確認

**画面遷移**：
- 新規作成ボタン押下 → ページ作成画面（No.363）
- 一覧行クリック/表示アクション → ページ詳細画面（No.365）
- 編集アクション → ページ編集画面（No.364）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。削除済み（ソフトデリート）のページはアーカイブタブで確認でき、復元または完全削除が可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-WEB-001 | ページ一覧 | 主機能 | ウェブサイトページの一覧表示と検索 |
| FN-WEB-002 | ページ作成 | 遷移先機能 | 新規ページ作成画面への遷移 |
| FN-WEB-003 | ページ編集 | 遷移先機能 | ページ編集画面への遷移 |
| FN-WEB-004 | ページ表示 | 遷移先機能 | ページ詳細画面への遷移 |

## 画面種別

一覧（ListRecords）画面

## URL/ルーティング

`/admin/website/pages`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン（CreateAction）
- テーブルビュー切替タブ
  - 「Archived」プリセットビュー（削除済みページ表示）
- データテーブル
  - 列: タイトル、スラッグ、作成者、公開状態、ヘッダー表示、フッター表示、更新日時、作成日時
  - グループ化オプション: 作成日時
  - フィルタ: 公開状態、作成者
- 行アクション（ActionGroup）
  - 表示（ViewAction）- 削除済みは非表示
  - 編集（EditAction）- 削除済みは非表示
  - 復元（RestoreAction）
  - 削除（DeleteAction）
  - 完全削除（ForceDeleteAction）
- 一括アクション
  - 一括復元（RestoreBulkAction）
  - 一括削除（DeleteBulkAction）
  - 一括完全削除（ForceDeleteBulkAction）

## 入出力項目

本画面は一覧表示のため、入力項目はありません。

## 表示項目

### テーブル列

| 項目名 | 項目ID | 型 | ソート | 検索 | デフォルト表示 | 説明 |
|--------|--------|-----|--------|------|---------------|------|
| タイトル | title | TextColumn | 可 | 可 | 表示 | ページタイトル |
| スラッグ | slug | TextColumn | 可 | - | 表示 | URLスラッグ |
| 作成者 | creator.name | TextColumn | 可 | - | 非表示 | ページ作成者 |
| 公開状態 | is_published | IconColumn | 可 | - | 表示 | 真偽値アイコン |
| ヘッダー表示 | is_header_visible | IconColumn | 可 | - | 非表示 | 真偽値アイコン |
| フッター表示 | is_footer_visible | IconColumn | 可 | - | 非表示 | 真偽値アイコン |
| 更新日時 | updated_at | TextColumn | 可 | - | 非表示 | 最終更新日時 |
| 作成日時 | created_at | TextColumn | 可 | - | 表示 | 作成日時 |

### フィルタ

| フィルタ名 | フィルタID | 型 | 説明 |
|-----------|-----------|-----|------|
| 公開状態 | is_published | Filter | 公開済みページのフィルタ |
| 作成者 | creator_id | SelectFilter | 作成者による絞り込み |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタンを押下すると、ページ作成画面（No.363）に遷移します。

### 2-行クリック/表示アクション

テーブル行をクリックまたは表示アクションを選択すると、該当ページの詳細画面（No.365）に遷移します。削除済みレコードでは表示アクションは非表示となります。

### 3-編集アクション

編集アクションを選択すると、該当ページの編集画面（No.364）に遷移します。削除済みレコードでは編集アクションは非表示となります。

### 4-復元アクション

削除済みレコードに対して復元アクションを実行すると、ソフトデリートが解除されページが復元されます。

### 5-削除アクション

削除アクションを実行すると、ページがソフトデリートされます。アーカイブタブで確認可能です。

### 6-完全削除アクション

完全削除アクションを実行すると、ページがデータベースから完全に削除されます。この操作は取り消せません。

### 7-アーカイブタブ切替

プリセットビュー「Archived」を選択すると、削除済み（onlyTrashed）のページのみが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | website_pages | UPDATE | deleted_atに日時を設定（ソフトデリート） |
| 復元 | website_pages | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | website_pages | DELETE | レコードを物理削除 |

### テーブル別更新項目詳細

#### website_pages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE（ソフト） | deleted_at | 現在日時 | SoftDeletesトレイト使用 |
| RESTORE | deleted_at | NULL | ソフトデリート解除 |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 復元完了時 | Page Restored | Page has been restored successfully. |
| 成功 | 削除完了時 | Page Deleted | Page has been deleted successfully. |
| 成功 | 完全削除完了時 | Page Force Deleted | Page has been permanently deleted. |
| 成功 | 一括復元完了時 | Pages Restored | Selected pages have been restored successfully. |
| 成功 | 一括削除完了時 | Pages Deleted | Selected pages have been deleted successfully. |
| 成功 | 一括完全削除完了時 | Pages Force Deleted | Selected pages have been permanently deleted. |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| レコードが見つからない | 404エラー | ページが見つかりません |
| 権限不足 | 403エラー | アクセスが拒否されました |
| 外部キー制約違反 | 削除エラー | 関連データが存在するため削除できません |

## 備考

- PageモデルはSoftDeletesトレイトを使用しており、削除時にはdeleted_atカラムに日時が設定されます
- テーブル列は並び替え可能（reorderableColumns）です
- 列マネージャーは2列レイアウトで表示されます（columnManagerColumns(2)）
- プリセットビュー「Archived」は削除済みページのみを表示するonlyTrashedクエリを使用します
