# 画面設計書 363-ページ作成

## 概要

本ドキュメントは、Aureus ERPシステムのウェブサイトページ作成画面の設計仕様を定義します。

### 本画面の処理概要

ページ作成画面は、ウェブサイトに公開する新規コンテンツページを作成するための管理者向け機能を提供します。

**業務上の目的・背景**：ウェブサイトに新しい静的ページ（会社情報、サービス説明、FAQ等）を追加する際に使用します。本画面では、ページの基本情報（タイトル、コンテンツ）、SEO設定（メタタイトル、キーワード、説明）、および表示設定（ヘッダー・フッター表示有無）を入力し、一括で新規ページを作成できます。

**画面へのアクセス方法**：ページ一覧画面（No.362）のヘッダーにある「新規作成」ボタンを押下してアクセスします。

**主要な操作・処理内容**：
1. ページタイトルの入力（自動スラッグ生成）
2. リッチテキストエディタによるコンテンツ入力
3. SEOメタ情報の設定
4. ヘッダー・フッター表示設定
5. ページの保存

**画面遷移**：
- 保存成功時 → ページ詳細画面（No.365）
- キャンセル → ページ一覧画面（No.362）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。作成時にcreator_idが自動的に現在のログインユーザーIDに設定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-WEB-002 | ページ作成 | 主機能 | 新規ページの作成と保存 |
| FN-WEB-001 | ページ一覧 | 遷移元 | 一覧画面からの遷移 |
| FN-WEB-004 | ページ表示 | 遷移先 | 作成後の詳細画面への遷移 |

## 画面種別

作成（CreateRecord）画面

## URL/ルーティング

`/admin/website/pages/create`

## 画面構成

3カラムレイアウト（左2カラム：メインコンテンツ、右1カラム：設定）

### 左側エリア（2/3幅）

#### 一般情報セクション
- タイトル入力（TextInput）
- スラッグ表示（TextInput - 無効化・自動生成）
- コンテンツ入力（RichEditor）

#### SEOセクション
- メタタイトル（TextInput）
- メタキーワード（TextInput）
- メタ説明（Textarea）

### 右側エリア（1/3幅）

#### 設定セクション
- ヘッダー表示（Toggle）
- フッター表示（Toggle）

### フッターアクション
- 作成ボタン
- キャンセルリンク

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | バリデーション | 説明 |
|--------|--------|-----|------|----------------|------|
| タイトル | title | TextInput | 必須 | - | ページタイトル、入力時にスラッグ自動生成 |
| スラッグ | slug | TextInput | 必須 | 最大255文字、ユニーク | URL識別子（無効化・自動生成） |
| コンテンツ | content | RichEditor | 必須 | - | ページ本文 |
| メタタイトル | meta_title | TextInput | 任意 | - | SEO用タイトル |
| メタキーワード | meta_keywords | TextInput | 任意 | - | SEO用キーワード |
| メタ説明 | meta_description | Textarea | 任意 | - | SEO用説明文 |
| ヘッダー表示 | is_header_visible | Toggle | 任意 | - | ヘッダーにリンク表示するか |
| フッター表示 | is_footer_visible | Toggle | 任意 | - | フッターにリンク表示するか |

## イベント仕様

### 1-タイトル入力（onBlur）

タイトルフィールドからフォーカスが外れたタイミングで、入力されたタイトルからスラッグが自動生成されます。生成にはStr::slug()関数が使用され、URL安全な形式に変換されます。これは作成時のみ動作し、編集時には動作しません。

### 2-作成ボタン押下

フォームの入力内容をバリデーションし、問題がなければデータベースに新規レコードを作成します。作成成功時には成功通知が表示され、ページ詳細画面（No.365）にリダイレクトされます。

### 3-キャンセル

ページ一覧画面（No.362）に戻ります。入力内容は保存されません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成保存 | website_pages | INSERT | 新規ページレコードの作成 |

### テーブル別更新項目詳細

#### website_pages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | フォーム入力値 | ページタイトル |
| INSERT | slug | タイトルから自動生成 | Str::slug(title) |
| INSERT | content | フォーム入力値 | ページ本文 |
| INSERT | meta_title | フォーム入力値（任意） | SEOタイトル |
| INSERT | meta_keywords | フォーム入力値（任意） | SEOキーワード |
| INSERT | meta_description | フォーム入力値（任意） | SEO説明文 |
| INSERT | is_header_visible | フォーム入力値 | ヘッダー表示フラグ |
| INSERT | is_footer_visible | フォーム入力値 | フッター表示フラグ |
| INSERT | is_published | false | 初期値（未公開） |
| INSERT | published_at | NULL | 未公開のためNULL |
| INSERT | creator_id | Auth::id() | 作成者ID |
| INSERT | created_at | 現在日時 | 作成日時 |
| INSERT | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 作成完了時 | Page Created | Page has been created successfully. |
| エラー | バリデーションエラー | - | 各フィールドにエラーメッセージ表示 |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| 必須項目未入力 | フォームバリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| スラッグ重複 | ユニーク制約エラー | スラッグが既に使用されています |
| スラッグ文字数超過 | バリデーションエラー | 最大255文字まで入力可能 |
| 権限不足 | 403エラー | アクセスが拒否されました |

## 備考

- 新規作成されたページはis_published=false（非公開）の状態で作成されます
- 公開するには編集画面（No.364）から公開アクションを実行する必要があります
- タイトル入力フィールドは大きなフォントサイズ（1.5rem）と高さ（3rem）でスタイリングされています
- スラッグフィールドは無効化されており、直接編集はできません
- RichEditorはWYSIWYGエディタでHTMLコンテンツの入力が可能です
