# 画面設計書 364-ページ編集

## 概要

本ドキュメントは、Aureus ERPシステムのウェブサイトページ編集画面の設計仕様を定義します。

### 本画面の処理概要

ページ編集画面は、既存のウェブサイトページのコンテンツおよび設定を編集するための管理者向け機能を提供します。

**業務上の目的・背景**：公開済みまたは下書き状態のページに対して、タイトル、コンテンツ、SEO設定、表示設定を更新する必要があります。また、本画面からページの公開・非公開（下書きへ戻す）の状態変更も行います。これにより、コンテンツの継続的な改善とタイムリーな情報発信が可能になります。

**画面へのアクセス方法**：
- ページ一覧画面（No.362）から編集アクションを選択
- ページ詳細画面（No.365）のサブナビゲーションから編集タブを選択

**主要な操作・処理内容**：
1. ページタイトル・コンテンツの編集
2. SEOメタ情報の更新
3. ヘッダー・フッター表示設定の変更
4. ページの公開（Publish）
5. ページの下書き化（Draft）
6. ページの削除

**画面遷移**：
- 保存成功時 → ページ詳細画面（No.365）
- 削除成功時 → ページ一覧画面（No.362）
- キャンセル → ページ詳細画面（No.365）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。公開アクションは未公開ページのみで表示され、下書きアクションは公開済みページのみで表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-WEB-003 | ページ編集 | 主機能 | ページ情報の編集・公開・下書き化 |
| FN-WEB-001 | ページ一覧 | 遷移元/遷移先 | 一覧からの遷移、削除後の遷移先 |
| FN-WEB-004 | ページ表示 | 遷移元/遷移先 | 詳細画面との相互遷移 |

## 画面種別

編集（EditRecord）画面

## URL/ルーティング

`/admin/website/pages/{record}/edit`

## 画面構成

### サブナビゲーション（上部）

- 表示タブ（ViewPage）
- 編集タブ（EditPage）- 現在選択中

### ヘッダーアクション

- 公開ボタン（Publish）- 未公開時のみ表示
- 下書きボタン（Draft）- 公開済み時のみ表示
- 削除ボタン（Delete）

### メインコンテンツ（3カラムレイアウト）

#### 左側エリア（2/3幅）

##### 一般情報セクション
- タイトル入力（TextInput）
- スラッグ表示（TextInput - 無効化）
- コンテンツ入力（RichEditor）

##### SEOセクション
- メタタイトル（TextInput）
- メタキーワード（TextInput）
- メタ説明（Textarea）

#### 右側エリア（1/3幅）

##### 設定セクション
- ヘッダー表示（Toggle）
- フッター表示（Toggle）

### フッターアクション
- 保存ボタン
- キャンセルリンク

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | バリデーション | 説明 |
|--------|--------|-----|------|----------------|------|
| タイトル | title | TextInput | 必須 | - | ページタイトル |
| スラッグ | slug | TextInput | 必須 | 最大255文字、ユニーク | URL識別子（無効化） |
| コンテンツ | content | RichEditor | 必須 | - | ページ本文 |
| メタタイトル | meta_title | TextInput | 任意 | - | SEO用タイトル |
| メタキーワード | meta_keywords | TextInput | 任意 | - | SEO用キーワード |
| メタ説明 | meta_description | Textarea | 任意 | - | SEO用説明文 |
| ヘッダー表示 | is_header_visible | Toggle | 任意 | - | ヘッダーにリンク表示するか |
| フッター表示 | is_footer_visible | Toggle | 任意 | - | フッターにリンク表示するか |

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容をバリデーションし、問題がなければデータベースのレコードを更新します。更新成功時には成功通知が表示され、ページ詳細画面（No.365）にリダイレクトされます。

### 2-公開ボタン押下（未公開時のみ表示）

ページの公開状態を変更します：
- is_published を true に設定
- published_at を現在日時に設定

公開成功時には成功通知が表示されます。

### 3-下書きボタン押下（公開済み時のみ表示）

ページを下書き状態に戻します：
- is_published を false に設定
- published_at を NULL に設定

下書き化成功時には成功通知が表示されます。

### 4-削除ボタン押下

確認ダイアログ表示後、ページをソフトデリートします。削除成功時には成功通知が表示され、ページ一覧画面（No.362）にリダイレクトされます。

### 5-キャンセル

ページ詳細画面（No.365）に戻ります。編集内容は保存されません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | website_pages | UPDATE | ページ情報の更新 |
| 公開 | website_pages | UPDATE | 公開状態の設定 |
| 下書き | website_pages | UPDATE | 下書き状態への変更 |
| 削除 | website_pages | UPDATE | ソフトデリート |

### テーブル別更新項目詳細

#### website_pages（保存操作）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | フォーム入力値 | ページタイトル |
| UPDATE | content | フォーム入力値 | ページ本文 |
| UPDATE | meta_title | フォーム入力値（任意） | SEOタイトル |
| UPDATE | meta_keywords | フォーム入力値（任意） | SEOキーワード |
| UPDATE | meta_description | フォーム入力値（任意） | SEO説明文 |
| UPDATE | is_header_visible | フォーム入力値 | ヘッダー表示フラグ |
| UPDATE | is_footer_visible | フォーム入力値 | フッター表示フラグ |
| UPDATE | updated_at | 現在日時 | 更新日時 |

#### website_pages（公開操作）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | is_published | true | 公開フラグ |
| UPDATE | published_at | now() | 公開日時 |

#### website_pages（下書き操作）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | is_published | false | 公開フラグ |
| UPDATE | published_at | NULL | 公開日時リセット |

#### website_pages（削除操作）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 保存完了時 | Page Updated | Page has been updated successfully. |
| 成功 | 公開完了時 | Page Published | Page has been published successfully. |
| 成功 | 下書き完了時 | Page Drafted | Page has been drafted successfully. |
| 成功 | 削除完了時 | Page Deleted | Page has been deleted successfully. |
| エラー | バリデーションエラー | - | 各フィールドにエラーメッセージ表示 |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| 必須項目未入力 | フォームバリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| レコードが見つからない | 404エラー | ページが見つかりません |
| 権限不足 | 403エラー | アクセスが拒否されました |

## 備考

- サブナビゲーションはページ上部に配置（SubNavigationPosition::Top）
- スラッグフィールドは編集時も無効化されており変更不可
- 公開アクションは !is_published の場合のみ表示（visibleメソッドで制御）
- 下書きアクションは is_published の場合のみ表示（visibleメソッドで制御）
- 削除はソフトデリートで実行され、アーカイブから復元可能
