# 画面設計書 365-ページ詳細

## 概要

本ドキュメントは、Aureus ERPシステムのウェブサイトページ詳細画面（管理者用）の設計仕様を定義します。

### 本画面の処理概要

ページ詳細画面は、ウェブサイトページの内容と設定を閲覧するための管理者向け表示専用機能を提供します。

**業務上の目的・背景**：管理者がページの内容、公開状態、SEO設定、作成・更新履歴などの情報を確認するために使用します。編集操作なしに現在の状態を把握できるため、コンテンツレビューや承認プロセスにおいて有用です。

**画面へのアクセス方法**：
- ページ一覧画面（No.362）から表示アクションを選択
- ページ作成画面（No.363）での作成完了後のリダイレクト
- ページ編集画面（No.364）での保存完了後のリダイレクト

**主要な操作・処理内容**：
1. ページタイトル・コンテンツの閲覧
2. SEOメタ情報の確認
3. ヘッダー・フッター表示設定の確認
4. 作成者・公開日時・作成日時・更新日時の確認
5. ページの削除

**画面遷移**：
- 編集タブ → ページ編集画面（No.364）
- 削除成功時 → ページ一覧画面（No.362）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-WEB-004 | ページ表示 | 主機能 | ページ情報の閲覧 |
| FN-WEB-001 | ページ一覧 | 遷移元/遷移先 | 一覧からの遷移、削除後の遷移先 |
| FN-WEB-003 | ページ編集 | 遷移先 | 編集画面への遷移 |

## 画面種別

詳細（ViewRecord）画面

## URL/ルーティング

`/admin/website/pages/{record}`

## 画面構成

### サブナビゲーション（上部）

- 表示タブ（ViewPage）- 現在選択中
- 編集タブ（EditPage）

### ヘッダーアクション

- 削除ボタン（DeleteAction）

### メインコンテンツ（3カラムレイアウト）

#### 左側エリア（2/3幅）

##### 一般情報セクション
- タイトル表示（TextEntry - Large/Bold）
- コンテンツ表示（TextEntry - Markdown）

##### SEOセクション
- メタタイトル（TextEntry - ドキュメントアイコン付き）
- メタキーワード（TextEntry - ハッシュタグアイコン付き）
- メタ説明（TextEntry - Markdown）

#### 右側エリア（1/3幅）

##### レコード情報セクション
- 作成者（TextEntry - ユーザーアイコン付き）
- 公開日時（TextEntry - カレンダーアイコン付き）
- 作成日時（TextEntry - カレンダーアイコン付き）
- 最終更新日時（TextEntry - カレンダーアイコン付き）
- 公開状態（IconEntry - Boolean）

##### 設定セクション
- ヘッダー表示（IconEntry - Boolean）
- フッター表示（IconEntry - Boolean）

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

### 一般情報セクション

| 項目名 | 項目ID | 型 | スタイル | 説明 |
|--------|--------|-----|---------|------|
| タイトル | title | TextEntry | Large, Bold | ページタイトル |
| コンテンツ | content | TextEntry | Markdown | ページ本文（HTML→Markdown表示） |

### SEOセクション

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| メタタイトル | meta_title | TextEntry | document-text | SEO用タイトル |
| メタキーワード | meta_keywords | TextEntry | hashtag | SEO用キーワード |
| メタ説明 | meta_description | TextEntry | - | SEO用説明文（Markdown） |

### レコード情報セクション

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| 作成者 | creator.name | TextEntry | user | ページ作成者名 |
| 公開日時 | published_at | TextEntry | calendar-days | 公開された日時 |
| 作成日時 | created_at | TextEntry | calendar | レコード作成日時 |
| 最終更新 | updated_at | TextEntry | calendar-days | レコード更新日時 |
| 公開状態 | is_published | IconEntry | Boolean | 公開中/下書き |

### 設定セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ヘッダー表示 | is_header_visible | IconEntry | ヘッダーにリンク表示するか |
| フッター表示 | is_footer_visible | IconEntry | フッターにリンク表示するか |

## イベント仕様

### 1-編集タブ押下

サブナビゲーションの「編集」タブを押下すると、ページ編集画面（No.364）に遷移します。

### 2-削除ボタン押下

確認ダイアログ表示後、ページをソフトデリートします。削除成功時には成功通知が表示され、ページ一覧画面（No.362）にリダイレクトされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | website_pages | UPDATE | ソフトデリート |

### テーブル別更新項目詳細

#### website_pages（削除操作）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 削除完了時 | Page Deleted | Page has been deleted successfully. |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| レコードが見つからない | 404エラー | ページが見つかりません |
| 権限不足 | 403エラー | アクセスが拒否されました |

## 備考

- InfolistスキーマによるViewRecord実装
- サブナビゲーションはページ上部に配置（SubNavigationPosition::Top）
- タイトルはLargeサイズ・Bold表示でスタイリング
- コンテンツはMarkdown形式で表示（HTML→Markdownレンダリング）
- 未設定の項目は「—」プレースホルダーで表示
- 削除はソフトデリートで実行され、アーカイブから復元可能
