# 画面設計書 366-パートナー一覧

## 概要

本ドキュメントは、Aureus ERPシステムのWebsiteモジュールにおけるパートナー（連絡先）一覧画面の設計仕様を定義します。

### 本画面の処理概要

パートナー一覧画面は、ウェブサイトに関連するパートナー（取引先・連絡先）情報を管理するための管理者向け機能を提供します。

**業務上の目的・背景**：ウェブサイト運営において、取引先企業や担当者、顧客などのパートナー情報を管理することは重要です。本画面は、Partnersプラグインで提供される基本的なパートナー管理機能をWebsiteモジュール向けに拡張し、ウェブサイトのコンテキストでパートナー情報を参照・管理できるようにします。

**画面へのアクセス方法**：サイドメニューの「Website」グループから「Contacts」を選択してアクセスします。

**主要な操作・処理内容**：
1. パートナーのグリッド形式での一覧表示（カード表示）
2. 新規パートナーの作成画面への遷移
3. 既存パートナーの詳細・編集画面への遷移
4. パートナーの削除・復元・完全削除
5. 高度なフィルタリング（QueryBuilder使用）
6. グループ化表示

**画面遷移**：
- 新規作成ボタン押下 → パートナー作成画面
- カードクリック/表示アクション → パートナー詳細画面
- 編集アクション → パートナー編集画面

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。ナビゲーションに表示されます（shouldRegisterNavigation = true）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PART-001 | パートナー一覧 | 主機能 | パートナーの一覧表示と検索 |
| FN-PART-002 | パートナー作成 | 遷移先機能 | 新規パートナー作成画面への遷移 |
| FN-PART-003 | パートナー編集 | 遷移先機能 | パートナー編集画面への遷移 |
| FN-PART-004 | パートナー表示 | 遷移先機能 | パートナー詳細画面への遷移 |

## 画面種別

一覧（ListRecords）画面 - カードグリッド表示

## URL/ルーティング

`/admin/website/contacts`

## 画面構成

### ヘッダーアクション
- 新規作成ボタン（CreateAction）

### フィルタパネル（モーダル・スライドオーバー）
- QueryBuilderによる高度なフィルタリング
- 2カラムレイアウト

### データグリッド
レスポンシブカードグリッド表示：
- sm: 1列
- md: 2列
- xl: 3列
- 2xl: 4列

### カード構成
各パートナーカードには以下が表示：
- アバター画像
- 名前（太字）
- 会社名（親パートナー）- 該当する場合のみ
- 役職 - 該当する場合のみ
- メールアドレス - 該当する場合のみ
- 電話番号 - 該当する場合のみ
- タグ（バッジ）- 該当する場合のみ

### 行アクション
- 表示（ViewAction）- 削除済みは非表示
- 編集（EditAction）- 削除済みは非表示
- 復元（RestoreAction）
- 削除（DeleteAction）
- 完全削除（ForceDeleteAction）

### 一括アクション
- 一括復元（RestoreBulkAction）
- 一括削除（DeleteBulkAction）
- 一括完全削除（ForceDeleteBulkAction）

### ページネーション
- 16, 32, 64, all

## 入出力項目

本画面は一覧表示のため、入力項目はありません。

## 表示項目

### カード表示項目

| 項目名 | 項目ID | 型 | 条件付き表示 | 説明 |
|--------|--------|-----|-------------|------|
| アバター | avatar | ImageColumn | - | パートナー画像（200x250） |
| 名前 | name | TextColumn | - | パートナー名（太字、検索・ソート可） |
| 会社名 | parent.name | TextColumn | filled(parent) | 親パートナー名、アイコン付き |
| 役職 | job_title | TextColumn | filled(job_title) | 職種・役職 |
| メール | email | TextColumn | filled(email) | メールアドレス（20文字制限） |
| 電話番号 | phone | TextColumn | filled(phone) | 電話番号（30文字制限） |
| タグ | tags.name | TextColumn | tags存在時 | カラーバッジ表示 |

### グループ化オプション

| グループ名 | グループID | 説明 |
|-----------|-----------|------|
| アカウントタイプ | account_type | 個人/企業での分類 |
| 親パートナー | parent.name | 会社別グループ |
| 敬称 | title.name | 敬称別グループ |
| 役職 | job_title | 役職別グループ |
| 業種 | industry.name | 業種別グループ |

### フィルタ（QueryBuilder）

| フィルタ名 | フィルタID | 型 | 説明 |
|-----------|-----------|-----|------|
| アカウントタイプ | account_type | SelectConstraint | 個人/企業 |
| 名前 | name | TextConstraint | パートナー名 |
| メール | email | TextConstraint | メールアドレス |
| 役職 | job_title | TextConstraint | 職種・役職 |
| ウェブサイト | website | TextConstraint | ウェブサイトURL |
| 税ID | tax_id | TextConstraint | 税識別番号 |
| 電話番号 | phone | TextConstraint | 電話番号 |
| 携帯電話 | mobile | TextConstraint | 携帯電話番号 |
| 会社登録 | company_registry | TextConstraint | 会社登記番号 |
| 参照 | reference | TextConstraint | 参照コード |
| 親パートナー | parent | RelationshipConstraint | 親会社 |
| 作成者 | creator | RelationshipConstraint | 作成ユーザー |
| 担当者 | user | RelationshipConstraint | 責任者 |
| 敬称 | title | RelationshipConstraint | 敬称 |
| 会社 | company | RelationshipConstraint | 所属会社 |
| 業種 | industry | RelationshipConstraint | 業種 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタンを押下すると、パートナー作成画面に遷移します。

### 2-カードクリック/表示アクション

パートナーカードをクリックまたは表示アクションを選択すると、該当パートナーの詳細画面に遷移します。削除済みレコードでは表示アクションは非表示となります。

### 3-編集アクション

編集アクションを選択すると、該当パートナーの編集画面に遷移します。削除済みレコードでは編集アクションは非表示となります。

### 4-復元アクション

削除済みレコードに対して復元アクションを実行すると、ソフトデリートが解除されパートナーが復元されます。

### 5-削除アクション

削除アクションを実行すると、パートナーがソフトデリートされます。

### 6-完全削除アクション

完全削除アクションを実行すると、パートナーがデータベースから完全に削除されます。外部キー制約違反の場合はエラーが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | partners | UPDATE | deleted_atに日時を設定（ソフトデリート） |
| 復元 | partners | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | partners | DELETE | レコードを物理削除 |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 編集完了時 | Partner Updated | Partner has been updated successfully. |
| 成功 | 復元完了時 | Partner Restored | Partner has been restored successfully. |
| 成功 | 削除完了時 | Partner Deleted | Partner has been deleted successfully. |
| 成功 | 完全削除完了時 | Partner Force Deleted | Partner has been permanently deleted. |
| エラー | 完全削除失敗時 | Force Delete Failed | Partner could not be deleted due to related records. |
| 成功 | 一括復元完了時 | Partners Restored | Selected partners have been restored successfully. |
| 成功 | 一括削除完了時 | Partners Deleted | Selected partners have been deleted successfully. |
| 成功 | 一括完全削除完了時 | Partners Force Deleted | Selected partners have been permanently deleted. |
| エラー | 一括完全削除失敗時 | Force Delete Failed | Some partners could not be deleted due to related records. |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| 権限不足 | 403エラー | アクセスが拒否されました |
| 外部キー制約違反（完全削除時） | QueryException捕捉 | 関連データが存在するため削除できません |

## 備考

- WebsiteモジュールのPartnerResourceはBasePartnerResourceを継承しています
- account_type='address'のレコードは表示から除外されています（modifyQueryUsing）
- カードグリッドはレスポンシブ対応でデバイス幅に応じて列数が変化します
- タグはカラーバッジとして表示され、各タグの色設定が反映されます
- サブナビゲーションは上部に配置（SubNavigationPosition::Top）
- 関連ページとして連絡先管理（ManageContacts）と住所管理（ManageAddresses）へのナビゲーションがあります
