# 画面設計書 367-連絡先設定

## 概要

本ドキュメントは、Aureus ERPシステムのWebsiteモジュールにおける連絡先設定画面の設計仕様を定義します。

### 本画面の処理概要

連絡先設定画面は、ウェブサイトに表示する連絡先情報およびソーシャルメディアリンクを管理するための管理者向け設定機能を提供します。

**業務上の目的・背景**：企業のウェブサイトには、顧客がコンタクトを取るための連絡先情報（メールアドレス、電話番号）や、ソーシャルメディアへのリンクを表示することが一般的です。本画面は、これらの情報を一元的に管理し、ウェブサイト全体で統一された連絡先情報を提供できるようにします。spatie/laravel-settingsパッケージを使用したアプリケーション設定として保存されます。

**画面へのアクセス方法**：サイドメニューの「Settings」クラスターから「Website」グループの「Manage Contacts」を選択してアクセスします。

**主要な操作・処理内容**：
1. 連絡先情報の入力・更新（メール、電話番号）
2. ソーシャルメディアリンクの入力・更新（Twitter, Facebook, Instagram等）
3. 設定の保存

**画面遷移**：本画面は設定ページのため、他画面への遷移はありません。同じ画面で設定の閲覧・編集・保存を行います。

**権限による表示制御**：HasPageShieldトレイトによりFilamentShield権限管理が適用されます。管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SET-001 | 連絡先設定 | 主機能 | 連絡先情報とSNSリンクの管理 |

## 画面種別

設定（SettingsPage）画面

## URL/ルーティング

`/admin/settings/website/manage-contacts`

## 画面構成

### ナビゲーション位置
- クラスター：Settings
- ナビゲーショングループ：Website
- ナビゲーション順序：5
- アイコン：heroicon-o-truck

### フォーム構成

#### 連絡先セクション（2カラム）
- メールアドレス（TextInput）
- 電話番号（TextInput）

#### ソーシャルリンクセクション（2カラム）
- Twitter（TextInput - プレフィックス付き）
- Facebook（TextInput - プレフィックス付き）
- Instagram（TextInput - プレフィックス付き）
- WhatsApp（TextInput - プレフィックス付き）
- YouTube（TextInput - プレフィックス付き）
- LinkedIn（TextInput - プレフィックス付き）
- Pinterest（TextInput - プレフィックス付き）
- TikTok（TextInput - プレフィックス付き）
- GitHub（TextInput - プレフィックス付き）
- Slack（TextInput - プレフィックス付き）

### フッターアクション
- 保存ボタン

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | バリデーション | プレースホルダー | プレフィックス | 説明 |
|--------|--------|-----|------|----------------|-----------------|---------------|------|
| メール | email | TextInput | 任意 | email | support@example.com | - | 連絡先メールアドレス |
| 電話番号 | phone | TextInput | 任意 | tel | +1234567890 | - | 連絡先電話番号 |
| Twitter | twitter | TextInput | 任意 | - | username | https://x.com/ | Twitterユーザー名 |
| Facebook | facebook | TextInput | 任意 | - | username | https://facebook.com/ | Facebookユーザー名 |
| Instagram | instagram | TextInput | 任意 | - | username | https://instagram.com/ | Instagramユーザー名 |
| WhatsApp | whatsapp | TextInput | 任意 | - | username | https://wa.me/ | WhatsApp番号 |
| YouTube | youtube | TextInput | 任意 | - | username | https://youtube.com/ | YouTubeチャンネル |
| LinkedIn | linkedin | TextInput | 任意 | - | username | https://linkedin.com/ | LinkedInプロフィール |
| Pinterest | pinterest | TextInput | 任意 | - | username | https://pinterest.com/ | Pinterestユーザー名 |
| TikTok | tiktok | TextInput | 任意 | - | username | https://tiktok.com/@ | TikTokユーザー名 |
| GitHub | github | TextInput | 任意 | - | username | https://github.com/ | GitHubユーザー名 |
| Slack | slack | TextInput | 任意 | - | username | https://slack.com/ | Slackワークスペース |

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容をバリデーションし、問題がなければContactSettings設定クラスに保存します。spatie/laravel-settingsパッケージにより、設定はデータベースのsettingsテーブルに保存されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | settings | UPDATE/INSERT | 設定値の更新または新規作成 |

### テーブル別更新項目詳細

#### settings（spatie/laravel-settings）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | group = 'website_contact' | - | 設定グループ |
| UPDATE | name = 各設定名 | フォーム入力値 | email, phone, twitter等 |
| UPDATE | payload | JSON形式の値 | 設定値 |

## メッセージ仕様

| メッセージ種別 | タイミング | タイトル | 本文 |
|---------------|-----------|---------|------|
| 成功 | 保存完了時 | Settings Saved | Settings have been saved successfully. |
| エラー | バリデーションエラー | - | 各フィールドにエラーメッセージ表示 |

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| メールアドレス形式不正 | バリデーションエラー | 有効なメールアドレスを入力してください |
| 電話番号形式不正 | バリデーションエラー | 有効な電話番号を入力してください |
| 権限不足 | 403エラー | アクセスが拒否されました |

## 備考

- SettingsPageクラスを継承したFilament設定ページ実装
- HasPageShieldトレイトによりFilamentShield権限管理が適用されます
- 設定クラスはContactSettings（Webkul\Website\Settings\ContactSettings）
- 設定グループは'website_contact'
- ソーシャルリンクはプレフィックス付きで、ユーザー名のみを入力すればURLが完成する設計
- 全ての項目は任意入力（nullable）
- パンくずリストには設定ページタイトルのみが表示されます
