# 画面設計書 368-ページ詳細（顧客）

## 概要

本ドキュメントは、Aureus ERPシステムのWebsiteモジュールにおける顧客向けページ詳細表示画面の設計仕様を定義します。

### 本画面の処理概要

ページ詳細（顧客）画面は、一般公開されているウェブサイトページのコンテンツを顧客（エンドユーザー）に表示するためのフロントエンド機能を提供します。

**業務上の目的・背景**：管理者がCMS（ページ管理機能）で作成・公開したコンテンツページを、ウェブサイト訪問者が閲覧できるようにします。利用規約、プライバシーポリシー、会社概要など、顧客に情報を提供するためのページ表示に使用されます。

**画面へのアクセス方法**：公開されたページのURLスラッグを使用してアクセスします。例：`/pages/about-us`

**主要な操作・処理内容**：
1. ページコンテンツの表示
2. ページタイトルの表示

**画面遷移**：本画面は表示専用のため、他画面への遷移はありません（ページ内のリンクを除く）。

**権限による表示制御**：本画面は認証不要（shouldSkipAuthorization = true）で、すべてのウェブサイト訪問者がアクセス可能です。ただし、公開済み（is_published = true）のページのみが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-WEB-005 | ページ公開表示 | 主機能 | 公開ページのコンテンツ表示 |
| FN-WEB-003 | ページ編集 | 関連機能 | 管理者によるコンテンツ作成・編集 |

## 画面種別

詳細（ViewRecord）画面 - カスタムBladeテンプレート使用

## URL/ルーティング

`/pages/{record}`

※ recordはページのslugカラムで解決されます（recordRouteKeyName = 'slug'）

## 画面構成

### カスタムビュー

本画面はFilament標準のViewRecordではなく、カスタムBladeテンプレートを使用しています：
`website::filament.customer.resources.page.pages.view-record`

### ページタイトル
- ページのtitleカラムの値がブラウザタイトルとして表示されます

### パンくずリスト
- パンくずリストは非表示（空配列を返す）

### コンテンツエリア
- ページのcontentカラムの内容がHTMLとしてレンダリングされます

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

### ページ情報

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| タイトル | title | string | ページタイトル（ブラウザタイトルとして使用） |
| コンテンツ | content | HTML | ページ本文（HTMLとしてレンダリング） |

## イベント仕様

本画面は表示専用のため、ユーザー操作によるイベントはありません。

## データベース更新仕様

本画面は読み取り専用のため、データベース更新は行いません。

## メッセージ仕様

本画面にはメッセージ表示はありません。

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| ページが見つからない | 404エラー | ページが見つかりません |
| ページが非公開 | 404エラー | ページが見つかりません |

## 備考

- CustomerパネルのPageResource実装
- ナビゲーションには表示されない（shouldRegisterNavigation = false）
- 認証不要（shouldSkipAuthorization = true）
- recordRouteKeyNameが'slug'に設定されており、URLではIDではなくスラッグでページを識別
- カスタムBladeテンプレートを使用するため、画面のデザインはテンプレートファイルで定義
- getBreadcrumbs()は空配列を返し、パンくずリストは非表示
- getTitle()はレコードのtitleカラムの値を返す
- ビューファイル：`resources/views/filament/customer/resources/page/pages/view-record.blade.php`（Websiteプラグイン内）
