# 画面設計書 369-ウェルカムページ

## 概要

本ドキュメントは、Aureus ERPシステムのウェルカムページ（Laravelデフォルトページ）の設計仕様を定義します。

### 本画面の処理概要

ウェルカムページは、アプリケーションのルートURL（/）にアクセスした際に表示されるランディングページです。Laravel標準のウェルカムページをベースとしており、認証済みユーザーにはダッシュボードへのリンク、未認証ユーザーにはログイン・登録へのリンクを提供します。

**業務上の目的・背景**：アプリケーションへの最初のエントリーポイントとして機能し、訪問者を適切なページへ誘導します。Laravel公式ドキュメントやLaracastsなどの学習リソースへのリンクも含まれており、開発者向けの情報も提供しています。

**画面へのアクセス方法**：アプリケーションのルートURL（/）にアクセスします。

**主要な操作・処理内容**：
1. 認証状態に応じたナビゲーションリンクの表示
2. Laravel関連リソースへのリンク表示
3. アプリケーション情報（Laravel/PHPバージョン）の表示

**画面遷移**：
- ログインリンク押下 → ログイン画面
- 登録リンク押下 → 登録画面
- ダッシュボードリンク押下 → ダッシュボード画面
- 外部リンク押下 → 各外部サイト（Laravel Docs, Laracasts等）

**権限による表示制御**：認証状態に応じてヘッダーナビゲーションが変化します（認証済み：Dashboard / 未認証：Login, Register）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-AUTH-001 | ログイン | 遷移先機能 | ログイン画面への遷移 |
| FN-AUTH-002 | 登録 | 遷移先機能 | 登録画面への遷移 |
| FN-DASH-001 | ダッシュボード | 遷移先機能 | ダッシュボード画面への遷移 |

## 画面種別

静的ページ（Bladeテンプレート）

## URL/ルーティング

`/`

## 画面構成

### ヘッダー

#### 左側：Laravelロゴ
- SVG形式のLaravelロゴを表示

#### 右側：ナビゲーション
条件付き表示：
- **認証済みの場合**：「Dashboard」リンク
- **未認証の場合**：「Log in」「Register」リンク

### メインコンテンツ

4つのカードセクションをグリッドレイアウトで表示：

#### 1. Documentation カード（大）
- Laravelドキュメントへのリンク
- スクリーンショット画像
- 説明テキスト

#### 2. Laracasts カード
- Laracastsへのリンク
- 動画チュートリアルの説明

#### 3. Laravel News カード
- Laravel Newsへのリンク
- コミュニティニュースの説明

#### 4. Vibrant Ecosystem カード
- Laravel関連ツール・ライブラリへのリンク集
- Forge, Vapor, Nova, Envoyer, Herd
- Cashier, Dusk, Echo, Horizon, Sanctum, Telescope

### フッター

- LaravelとPHPのバージョン情報表示

## 入出力項目

本画面は静的表示のため、入力項目はありません。

## 表示項目

### ヘッダーナビゲーション

| 項目名 | 表示条件 | 遷移先 | 説明 |
|--------|---------|--------|------|
| Dashboard | @auth | - | ダッシュボードリンク |
| Log in | @guest | route('login') | ログインページへのリンク |
| Register | @guest && Route::has('register') | route('register') | 登録ページへのリンク |

### メインコンテンツ

| 項目名 | URL | 説明 |
|--------|-----|------|
| Documentation | https://laravel.com/docs | Laravel公式ドキュメント |
| Laracasts | https://laracasts.com | Laravel動画チュートリアル |
| Laravel News | https://laravel-news.com | Laravelコミュニティニュース |
| Forge | https://forge.laravel.com | サーバー管理 |
| Vapor | https://vapor.laravel.com | サーバーレスプラットフォーム |
| Nova | https://nova.laravel.com | 管理パネル |
| Envoyer | https://envoyer.io | デプロイメント |
| Herd | https://herd.laravel.com | ローカル開発環境 |
| Cashier | https://laravel.com/docs/billing | 課金システム |
| Dusk | https://laravel.com/docs/dusk | ブラウザテスト |
| Echo | https://laravel.com/docs/broadcasting | ブロードキャスト |
| Horizon | https://laravel.com/docs/horizon | キュー管理 |
| Sanctum | https://laravel.com/docs/sanctum | API認証 |
| Telescope | https://laravel.com/docs/telescope | デバッグ |

### フッター

| 項目名 | 表示内容 | 説明 |
|--------|---------|------|
| Laravelバージョン | Illuminate\Foundation\Application::VERSION | 使用中のLaravelバージョン |
| PHPバージョン | PHP_VERSION | 使用中のPHPバージョン |

## イベント仕様

### 1-ログインリンク押下

未認証ユーザーが「Log in」リンクを押下すると、ログイン画面に遷移します。

### 2-登録リンク押下

未認証ユーザーが「Register」リンクを押下すると、登録画面に遷移します。registerルートが存在しない場合はリンク自体が非表示となります。

### 3-ダッシュボードリンク押下

認証済みユーザーが「Dashboard」リンクを押下すると、ダッシュボード画面に遷移します。

### 4-外部リンク押下

各カードや説明内の外部リンクを押下すると、該当する外部サイトが新しいタブ/ウィンドウで開きます。

## データベース更新仕様

本画面は読み取り専用の静的ページのため、データベース更新は行いません。

## メッセージ仕様

本画面にはメッセージ表示はありません。

## 例外処理

| 例外ケース | 処理内容 | ユーザーへの表示 |
|-----------|---------|-----------------|
| 画像読み込みエラー | JavaScriptでフォールバック処理 | スクリーンショットコンテナを非表示 |

## 備考

- Laravel標準のウェルカムページテンプレート（resources/views/welcome.blade.php）
- Tailwind CSSを使用したスタイリング（インラインスタイルも含む）
- ダーク/ライトモードに対応（prefers-color-scheme: dark）
- レスポンシブデザイン（sm, md, lg ブレークポイント対応）
- Viteによるアセットビルド（ビルド済みでない場合はインラインCSSを使用）
- 背景画像はLaravel公式サイトからの外部読み込み
- Figtreeフォントを使用（Bunny Fonts CDN）
- 画像読み込みエラー時のJavaScriptフォールバック処理あり
- 認証関連のルート存在チェック（Route::has()）を使用
