# 画面設計書 37-支払期限管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払期限管理画面の設計仕様を定義するものです。この画面は会計モジュールの支払条件リソースの関連ページとして、支払条件に紐づく支払期限（Due Term）の管理機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払期限は、支払条件の詳細設定として、実際の支払い期日の計算方法を定義するものです。例えば「請求日から30日後」「翌月10日」「請求額の50%を即時、残り50%を30日後」など、複雑な支払スケジュールを設定できます。この管理画面は、支払条件に関連する支払期限の作成・編集・削除を行うためのリレーション管理インターフェースを提供します。

**画面へのアクセス方法**：支払条件詳細画面または編集画面のサブナビゲーションから「支払期限」リンクをクリックしてアクセスします。URLパターンは `/payment-terms/{record}/payment-due-terms` です。

**主要な操作・処理内容**：
1. 支払期限の一覧表示（期限額、値タイプ、日数、遅延タイプ）
2. 新規支払期限の作成（インラインフォーム）
3. 既存支払期限の編集
4. 支払期限の削除
5. 支払期限の詳細表示

**画面遷移**：
- 遷移元：支払条件詳細画面、支払条件編集画面（サブナビゲーション）
- 遷移先：サブナビゲーションで詳細画面、編集画面へ

**権限による表示制御**：システムの権限設定に基づき、支払条件リソースへの管理権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-023 | 支払条件管理 | 主機能 | 支払期限の管理 |
| - | 支払条件詳細 | 遷移元機能 | サブナビゲーションからの遷移 |
| - | 支払条件編集 | 遷移元機能 | サブナビゲーションからの遷移 |

## 画面種別

関連レコード管理

## URL/ルーティング

- パス: `/payment-terms/{record}/payment-due-terms`
- ルート名: `filament.accounts.resources.payment-terms.payment-due-terms`
- HTTPメソッド: GET

## 画面構成

```
+------------------------------------------------------------------+
| サブナビゲーション（上部配置）                                      |
|  [詳細] [編集] [支払期限(現在)]                                    |
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  支払期限                                  [+ 新規作成]            |
+------------------------------------------------------------------+
| データテーブル                                                     |
| +----------+------------+----------+------------+--------+        |
| | 期限額   | 値タイプ    | 日数後   | 遅延タイプ   | 操作    |
| +----------+------------+----------+------------+--------+        |
| | 100      | パーセント  | 0        | 日数後      | [表示][編集][削除] |
| +----------+------------+----------+------------+--------+        |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 備考 |
|--------|--------|--------|----------|------|------|
| 値タイプ | value | 入力 | enum | ○ | DueTermValue列挙型（パーセント/固定額） |
| 期限額 | value_amount | 入力 | numeric | - | 0以上、デフォルト100 |
| 遅延タイプ | delay_type | 入力 | enum | ○ | DelayType列挙型 |
| 翌月日 | days_next_month | 入力 | integer | - | デフォルト10 |
| 日数 | nb_days | 入力 | integer | - | 0以上、デフォルト0 |
| 支払条件 | payment_id | 入力 | integer | - | リレーション選択 |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 備考 |
|--------|--------|----------|--------|------|
| 期限額 | value_amount | numeric | ○ | メインカラム |
| 値タイプ | value | enum | ○ | DueTermValue列挙型の表示名 |
| 日数後 | nb_days | integer | ○ | - |
| 遅延タイプ | delay_type | enum | ○ | DelayType列挙型の表示名 |

## イベント仕様

### 1-新規作成ボタン押下

**トリガー**: ヘッダーの「新規作成」ボタンをクリック

**処理フロー**:
1. インラインフォームダイアログの表示
2. 各フィールドにデフォルト値を設定
   - value_amount: 100
   - days_next_month: 10
   - nb_days: 0
3. 入力完了後、バリデーション実行
4. 成功通知の表示
5. テーブルの再読み込み

### 2-編集アクション

**トリガー**: 行の「編集」ボタンをクリック

**処理フロー**:
1. インラインフォームダイアログの表示（既存値をプリセット）
2. 入力完了後、バリデーション実行
3. データベースへのUPDATE処理
4. 成功通知の表示
5. テーブルの再読み込み

### 3-削除アクション

**トリガー**: 行の「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、物理削除実行
3. 成功通知の表示
4. テーブルの再読み込み

### 4-表示アクション

**トリガー**: 行の「表示」ボタンをクリック

**処理フロー**:
1. 詳細表示ダイアログの表示

### 5-サブナビゲーション

**トリガー**: サブナビゲーションのリンクをクリック

**処理フロー**:
1. 詳細: 支払条件詳細画面へ遷移
2. 編集: 支払条件編集画面へ遷移
3. 支払期限: 現在のページ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | accounts_payment_due_terms | INSERT | 支払期限の新規登録 |
| 編集アクション | accounts_payment_due_terms | UPDATE | 支払期限の更新 |
| 削除アクション | accounts_payment_due_terms | DELETE | 支払期限の物理削除 |

### テーブル別更新項目詳細

#### accounts_payment_due_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | value | フォーム入力値 | DueTermValue列挙型 |
| INSERT | value_amount | フォーム入力値 | デフォルト100 |
| INSERT | delay_type | フォーム入力値 | DelayType列挙型 |
| INSERT | days_next_month | フォーム入力値 | デフォルト10 |
| INSERT | nb_days | フォーム入力値 | デフォルト0 |
| INSERT | payment_id | 親レコードID | FK |
| UPDATE | 上記全項目 | フォーム入力値 | - |
| DELETE | - | WHERE id = {id} | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| create.notification.title | 成功 | 支払期限が作成されました | 作成成功時 |
| create.notification.body | 成功 | 支払期限が正常に作成されました | 作成成功時 |
| edit.notification.title | 成功 | 支払期限が更新されました | 編集成功時 |
| edit.notification.body | 成功 | 支払期限が正常に更新されました | 編集成功時 |
| delete.notification.title | 成功 | 支払期限が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 支払期限が正常に削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 親レコードが存在しない | 404エラー画面表示 | 指定された支払条件が見つかりません |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの保存中にエラーが発生しました |
| バリデーションエラー | フォームエラー表示 | 各フィールドに対応するエラーメッセージ |

## 備考

- 本画面はFilament PHPのManageRelatedRecordsページクラスを継承して実装されています
- PaymentDueTermトレイトを使用してフォームとテーブルを定義しています
- リレーションシップ名は`dueTerm`です
- サブナビゲーションは画面上部に配置されます（SubNavigationPosition::Top）
- ナビゲーションアイコンは`heroicon-o-banknotes`です
- 値タイプ（value）はDueTermValue列挙型で「パーセント」「固定額」などを選択できます
- 遅延タイプ（delay_type）はDelayType列挙型で「日数後」「翌月の日」などを選択できます
- 支払条件作成時に自動的にデフォルトの支払期限が1件作成されます（PaymentTermモデルのboot）
