# 画面設計書 38-支払一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払一覧画面の設計仕様を定義するものです。この画面は会計モジュールの支払管理機能として、登録されている支払情報の一覧表示と管理機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払管理は会計業務において重要な機能であり、顧客からの入金や仕入先への支払いを記録・追跡するために使用されます。この一覧画面は、すべての支払取引を一元管理し、ステータス別・タイプ別に絞り込んで確認できるビューを提供します。

**画面へのアクセス方法**：会計モジュールのナビゲーションから「支払」メニューをクリックしてアクセスします。ただし、ナビゲーションには直接登録されていない（shouldRegisterNavigation = false）ため、クラスタークラスやカスタムナビゲーション経由でアクセスします。URLパターンは `/payments` です。

**主要な操作・処理内容**：
1. 支払情報の一覧表示（名称、会社、銀行口座、支払方法、通貨など）
2. プリセットビューによるフィルタリング（顧客支払、仕入先支払、下書き、処理中など）
3. 高度なフィルタリング（QueryBuilder）
4. カラムのグルーピング
5. 新規支払の作成への遷移
6. 既存支払の表示・編集・削除

**画面遷移**：
- 遷移元：会計ダッシュボード、他のモジュールからのリンク
- 遷移先：「新規作成」ボタンで作成画面へ、行クリックまたは「表示」ボタンで詳細画面へ、「編集」ボタンで編集画面へ

**権限による表示制御**：システムの権限設定に基づき、支払リソースへのアクセス権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-024 | 支払管理 | 主機能 | 支払情報の一覧表示 |
| - | 支払作成 | 遷移先機能 | 新規支払の作成 |
| - | 支払詳細 | 遷移先機能 | 支払情報の詳細表示 |
| - | 支払編集 | 遷移先機能 | 支払情報の編集 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/payments`
- ルート名: `filament.accounts.resources.payments.index`
- HTTPメソッド: GET

## 画面構成

```
+------------------------------------------------------------------+
| ヘッダー                                                          |
|  支払一覧                                  [+ 新規作成]            |
+------------------------------------------------------------------+
| プリセットビュー                                                   |
| [顧客支払] [仕入先支払] [下書き*] [処理中] [送信済み]              |
| [未送信] [銀行照合なし] [消込済み]                                 |
+------------------------------------------------------------------+
| フィルタ・検索バー                                                 |
| [QueryBuilder フィルタ] [グルーピング選択]                         |
+------------------------------------------------------------------+
| データテーブル（カラム並べ替え可能）                                |
| +------+------+----------+--------+----------+--------+------+    |
| | 名称 | 会社 | 銀行名義人 | 内部振替 | 支払方法ライン | 通貨 | 操作 |
| +------+------+----------+--------+----------+--------+------+    |
| | PAY/001 | ... | ... | ... | ... | ... | [表示][編集][削除] |
| +------+------+----------+--------+----------+--------+------+    |
+------------------------------------------------------------------+
| 一括操作                                                          |
| [一括削除]                                                        |
+------------------------------------------------------------------+
```

## 入出力項目

本画面は一覧画面のため、直接の入力項目はありません。フィルタ条件のみ入力可能です。

### フィルタ項目

| 項目名 | 項目ID | データ型 | 備考 |
|--------|--------|----------|------|
| 会社 | company | relationship | 複数選択可 |
| 顧客銀行口座 | partnerBank | relationship | 複数選択可 |
| 内部振替支払 | pairedInternalTransferPayment | relationship | 複数選択可 |
| 支払方法ライン | paymentMethodLine | relationship | 複数選択可 |
| 支払方法 | paymentMethod | relationship | 複数選択可 |
| 通貨 | currency | relationship | 複数選択可 |
| パートナー | partner | relationship | 複数選択可 |
| 作成日 | created_at | date | 日付範囲 |
| 更新日 | updated_at | date | 日付範囲 |

## 表示項目

| 項目名 | 項目ID | データ型 | 検索 | ソート | 表示/非表示 | 備考 |
|--------|--------|----------|------|--------|------------|------|
| 名称 | name | string | ○ | ○ | 常時表示 | - |
| 会社 | company.name | string | - | ○ | 常時表示 | - |
| 銀行口座名義人 | partnerBank.account_holder_name | string | ○ | ○ | 常時表示 | - |
| 内部振替支払 | pairedInternalTransferPayment.name | string | - | ○ | 常時表示 | - |
| 支払方法ライン | paymentMethodLine.name | string | - | ○ | 常時表示 | - |
| 支払方法 | paymentMethod.name | string | - | ○ | 常時表示 | - |
| 通貨 | currency.name | string | - | ○ | 常時表示 | - |
| パートナー | partner.name | string | - | ○ | デフォルト非表示 | - |
| 未決済口座 | outstandingAccount.name | string | - | ○ | デフォルト非表示 | - |
| 宛先口座 | destinationAccount.name | string | - | ○ | デフォルト非表示 | - |
| 作成者 | createdBy.name | string | - | ○ | デフォルト非表示 | - |
| 支払トランザクション | paymentTransaction.name | string | - | ○ | デフォルト非表示 | - |

## プリセットビュー

| ビュー名 | ビューID | フィルタ条件 | お気に入り | デフォルト | アイコン |
|---------|---------|-------------|----------|-----------|---------|
| 顧客支払 | customer_payments | partner_type = 'customer' | ○ | - | heroicon-s-banknotes |
| 仕入先支払 | vendor_payments | partner_type = 'supplier' | ○ | - | heroicon-s-banknotes |
| 下書き | draft | state = 'draft' | ○ | ○ | heroicon-s-stop |
| 処理中 | in_process | state = 'in_process' | ○ | - | heroicon-s-play |
| 送信済み | is_sent | is_sent = true | - | - | heroicon-s-play |
| 未送信 | not_sent | is_sent = false | - | - | heroicon-s-play |
| 銀行照合なし | no_bank_matching | is_matched = false | - | - | heroicon-s-play |
| 消込済み | is_reconciled | is_reconciled = true | - | - | heroicon-s-play |

## グルーピング

| グループ名 | グループID | 折りたたみ可 |
|-----------|-----------|------------|
| 名称 | name | ○ |
| 会社 | company.name | ○ |
| 支払方法ライン | paymentMethodLine.name | ○ |
| パートナー | partner.name | ○ |
| 支払方法 | paymentMethod.name | ○ |
| 銀行口座名義人 | partnerBank.account_holder_name | ○ |
| 内部振替支払 | pairedInternalTransferPayment.name | ○ |
| 作成日 | created_at | ○ |
| 更新日 | updated_at | ○ |

## イベント仕様

### 1-新規作成ボタン押下

**トリガー**: ヘッダーの「新規作成」ボタンをクリック

**処理フロー**:
1. 支払作成画面への遷移
2. URLは `/payments/create`

### 2-表示アクション

**トリガー**: 行の「表示」ボタンをクリックまたは行をクリック

**処理フロー**:
1. 支払詳細画面への遷移
2. URLは `/payments/{id}`

### 3-編集アクション

**トリガー**: 行の「編集」ボタンをクリック

**処理フロー**:
1. 支払編集画面への遷移
2. URLは `/payments/{id}/edit`

### 4-削除アクション

**トリガー**: 行の「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、物理削除実行
3. 成功通知の表示
4. テーブルの再読み込み

### 5-一括削除

**トリガー**: 複数行を選択し「一括削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、選択されたレコードを物理削除
3. 成功通知の表示
4. テーブルの再読み込み

### 6-プリセットビュー切り替え

**トリガー**: プリセットビューのタブをクリック

**処理フロー**:
1. 選択したプリセットビューのフィルタ条件を適用
2. テーブルの再読み込み

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | accounts_account_payments | DELETE | 支払の物理削除 |
| 一括削除 | accounts_account_payments | DELETE | 複数支払の物理削除 |

### テーブル別更新項目詳細

#### accounts_account_payments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {id} | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| delete.notification.title | 成功 | 支払が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 支払が正常に削除されました | 削除成功時 |
| bulk-actions.delete.notification.title | 成功 | 支払が削除されました | 一括削除成功時 |
| bulk-actions.delete.notification.body | 成功 | 選択した支払が正常に削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの取得中にエラーが発生しました |

## 備考

- 本画面はFilament PHPのListRecordsページクラスを継承して実装されています
- HasTableViewsトレイトを使用してプリセットビュー機能を実装しています
- デフォルトのプリセットビューは「下書き」（draft）です
- テーブルはID降順でソートされます（orderByDesc('id')）
- カラムの並べ替えが可能です（reorderableColumns）
- カラムマネージャーは2カラム表示です（columnManagerColumns(2)）
- フィルタフォームは2カラム表示です（filtersFormColumns(2)）
- ナビゲーションには直接登録されていません（shouldRegisterNavigation = false）
- プレースホルダーは「-」で統一されています
- 一部のカラムはデフォルトで非表示になっています（toggleable(isToggledHiddenByDefault: true)）
