# 画面設計書 39-支払作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払作成画面の設計仕様を定義するものです。この画面は会計モジュールの支払管理機能として、新規支払情報の登録機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払作成画面は、顧客からの入金（受取）や仕入先への支払い（送金）を新規に登録するために使用されます。支払タイプ、銀行口座、金額、支払方法、日付などの情報を入力し、支払取引を記録します。

**画面へのアクセス方法**：支払一覧画面の「新規作成」ボタンをクリック、または直接URLでアクセスします。URLパターンは `/payments/create` です。

**主要な操作・処理内容**：
1. 支払情報の入力（支払タイプ、銀行口座、顧客、支払方法、金額、日付、メモ）
2. 顧客選択時の銀行口座と支払方法の自動設定
3. 入力内容のバリデーション
4. 支払データの保存

**画面遷移**：
- 遷移元：支払一覧画面
- 遷移先：保存成功後は支払詳細画面へリダイレクト

**権限による表示制御**：システムの権限設定に基づき、支払リソースへの作成権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-024 | 支払管理 | 主機能 | 支払情報の新規作成 |
| - | 支払一覧 | 遷移元機能 | 一覧からの作成遷移 |
| - | 支払詳細 | 遷移先機能 | 作成後の詳細表示 |

## 画面種別

作成

## URL/ルーティング

- パス: `/payments/create`
- ルート名: `filament.accounts.resources.payments.create`
- HTTPメソッド: GET（画面表示）、POST（保存）

## 画面構成

```
+------------------------------------------------------------------+
| ステータスステッパー（読み取り専用）                                  |
|  [下書き] → [処理中] → [支払済み]                                   |
+------------------------------------------------------------------+
| フォームセクション                                                  |
| +--------------------------------------------------------------+ |
| | 支払タイプ                                                      | |
| | (○) 受取  ( ) 送金                                            | |
| |                                                                | |
| | 顧客銀行口座*                  顧客                             | |
| | [Selectbox         ▼]       [Selectbox         ▼]            | |
| |                                                                | |
| | 支払方法                      金額*                             | |
| | [Selectbox         ▼]       [0              ]                 | |
| |                                                                | |
| | 日付*                         メモ                              | |
| | [2025-12-26       📅]       [                  ]              | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
| フッター                                                          |
|                                     [キャンセル] [保存]            |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 初期値 | バリデーション | 備考 |
|--------|--------|--------|----------|------|--------|----------------|------|
| ステータス | state | 表示 | enum | - | draft | - | ProgressStepper、読み取り専用 |
| 支払タイプ | payment_type | 入力 | enum | - | inbound | PaymentType列挙型 | ToggleButtons、受取/送金 |
| 顧客銀行口座 | partner_bank_id | 入力 | integer | ○ | - | リレーション存在 | 削除済みも表示（無効化） |
| 顧客 | partner_id | 入力 | integer | - | - | sub_type=customer | 選択時に銀行口座と支払方法を自動設定 |
| 支払方法 | payment_method_line_id | 入力 | integer | - | - | リレーション存在 | PaymentMethodLine選択 |
| 金額 | amount | 入力 | numeric | ○ | 0 | 0以上、99999999999以下 | - |
| 日付 | date | 入力 | date | ○ | 今日 | 有効な日付 | ネイティブピッカー無効 |
| メモ | memo | 入力 | string | - | - | 最大255文字 | - |

## イベント仕様

### 1-顧客選択時の連動処理

**トリガー**: 「顧客」フィールドの値が変更された時

**処理フロー**:
1. 選択された顧客のPartnerモデルを取得
2. 顧客の銀行口座（bankAccounts）の最初のレコードIDを「顧客銀行口座」に設定
3. 顧客の受取用支払方法（propertyInboundPaymentMethodLine）のIDを「支払方法」に設定
4. フォームの再描画

### 2-保存ボタン押下

**トリガー**: フォームの「保存」ボタンをクリック

**処理フロー**:
1. 入力値のバリデーション実行
2. バリデーション成功時、mutateFormDataBeforeCreate実行
   - state = 'draft' を設定
   - creator_id = 現在のログインユーザーID を設定
3. accounts_account_paymentsテーブルへのINSERT処理
4. 成功通知の表示
5. 支払詳細画面へのリダイレクト

### 3-キャンセルボタン押下

**トリガー**: フォームの「キャンセル」ボタンをクリック

**処理フロー**:
1. 一覧画面へのリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_account_payments | INSERT | 支払の新規登録 |

### テーブル別更新項目詳細

#### accounts_account_payments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | payment_type | フォーム入力値 | PaymentType列挙型 |
| INSERT | partner_bank_id | フォーム入力値 | FK |
| INSERT | partner_id | フォーム入力値 | FK |
| INSERT | payment_method_line_id | フォーム入力値 | FK |
| INSERT | amount | フォーム入力値 | デフォルト0 |
| INSERT | date | フォーム入力値 | デフォルト今日 |
| INSERT | memo | フォーム入力値 | - |
| INSERT | state | 'draft' | 自動設定 |
| INSERT | creator_id | 現在のユーザーID | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| notification.title | 成功 | 支払が作成されました | 作成成功時 |
| notification.body | 成功 | 支払が正常に作成されました | 作成成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | フォームエラー表示 | 各フィールドに対応するエラーメッセージ |
| 金額が範囲外 | フォームエラー表示 | 金額は0以上99999999999以下で入力してください |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの保存中にエラーが発生しました |
| 銀行口座が削除済み | 選択肢無効化 | 「(Deleted)」接尾辞付きで表示、選択不可 |

## 備考

- 本画面はFilament PHPのCreateRecordページクラスを継承して実装されています
- ProgressStepperコンポーネントで支払ステータスを表示しますが、作成時は読み取り専用です
- 支払タイプはToggleButtonsで「受取」「送金」を選択できます
- 顧客銀行口座の選択肢には削除済みのレコードも含まれますが、選択は無効化されています
- 顧客を選択すると、その顧客に紐づく銀行口座と支払方法が自動的に設定されます
- 金額のデフォルトは0です
- 日付のデフォルトは今日の日付です
- 保存後は詳細画面（ViewPayments）にリダイレクトされます
- 作成時にstateは自動的に'draft'に設定されます
- creator_idは現在ログインしているユーザーIDが自動設定されます
- フォームは1カラムレイアウトですが、内部のGroupは2カラムで配置されます
