# 画面設計書 4-勘定科目詳細

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける勘定科目詳細画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、勘定科目の詳細情報を閲覧するための表示画面です。勘定科目の基本情報、関連する税、タグ、仕訳帳などの情報を確認でき、編集画面や削除操作への導線を提供します。

**業務上の目的・背景**：経理担当者や監査担当者が特定の勘定科目の詳細設定を確認する必要がある場合に使用します。勘定科目の属性を一目で把握でき、必要に応じて編集や削除への迅速なアクセスが可能です。

**画面へのアクセス方法**：勘定科目一覧画面で対象行をクリック、または行アクションの「表示」を選択してアクセスします。また、勘定科目作成・編集画面からの保存成功後にも本画面へリダイレクトされます。

**主要な操作・処理内容**：
1. 勘定科目基本情報の表示（コード、名称）
2. 会計設定情報の表示（科目タイプ、税、タグ、仕訳帳、通貨）
3. 各種フラグ状態の表示（非推奨、消込対象、非取引）
4. 編集画面への遷移
5. 削除操作の実行

**画面遷移**：
- 本画面から遷移可能：勘定科目編集画面
- 本画面への遷移元：勘定科目一覧画面、勘定科目作成画面、勘定科目編集画面

**権限による表示制御**：勘定科目の閲覧権限を持つユーザーのみアクセス可能です。編集・削除ボタンは対応する権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-018 | 勘定科目表示 | 主機能 | 勘定科目詳細の表示 |
| FN-ACC-020 | 勘定科目編集 | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細

## URL/ルーティング

`/accounts/accounts/{record}`

## 画面構成

- ヘッダーエリア：画面タイトル、編集ボタン、削除ボタン
- 情報表示セクション
  - 基本情報：コード、名称（2カラムレイアウト、アイコン付き）
  - 会計設定セクション：科目タイプ、税、タグ、仕訳帳、通貨、各種フラグ

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 表示形式 |
|----|--------|--------|-----|------|---------|
| 1 | コード | code | string | 勘定科目コード | テキスト（識別アイコン付き） |
| 2 | 勘定科目名 | name | string | 勘定科目の名称 | テキスト（ドキュメントアイコン付き） |
| 3 | 科目タイプ | account_type | enum | 勘定科目の種類 | テキスト（タグアイコン付き） |
| 4 | デフォルト税 | taxes.name | array | 関連する税一覧 | リスト表示（計算機アイコン付き） |
| 5 | タグ | tags.name | array | 勘定科目タグ一覧 | リスト表示（タグアイコン付き） |
| 6 | 仕訳帳 | journals.name | array | 関連仕訳帳一覧 | リスト表示（ブックアイコン付き） |
| 7 | 通貨 | currency.name | string | 使用通貨 | テキスト（ドルアイコン付き） |
| 8 | 非推奨 | deprecated | boolean | 非推奨フラグ | アイコン表示 |
| 9 | 消込対象 | reconcile | boolean | 消込可能フラグ | アイコン表示 |
| 10 | 非取引 | non_trade | boolean | 非取引フラグ | アイコン表示 |

## イベント仕様

### 1-編集ボタン押下

ヘッダーの「編集」ボタンを押下すると、該当レコードの編集画面（EditAccount）へ遷移します。

### 2-削除ボタン押下

ヘッダーの「削除」ボタンを押下すると、確認ダイアログが表示されます。確認後、該当レコードを削除し、一覧画面へ遷移します。削除成功時は通知メッセージが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | accounts_accounts | DELETE | 勘定科目レコードを削除 |
| 画面表示 | accounts_accounts | SELECT | 勘定科目レコードを取得 |

### テーブル別更新項目詳細

#### accounts_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | id = {record} | 関連テーブル（taxes, tags, journals, currency）もEagerロード |
| DELETE | - | id = {record} | 確認ダイアログ後に実行 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 勘定科目が削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコード未存在 | 404エラー表示 | 指定されたデータが見つかりません |
| 削除失敗（関連データあり） | エラー通知表示 | この勘定科目は使用中のため削除できません |
| 権限不足 | 操作拒否 | この操作を行う権限がありません |

## 備考

- 本画面はFilament PHPのViewRecordを継承して実装されています
- Infolistを使用して情報を表示しています
- 税項目は科目タイプが「OFF_BALANCE」以外の場合のみ表示されます
- 複数値を持つ項目（税、タグ、仕訳帳）はlistWithLineBreaks()で行区切りで表示されます
- 各項目には視認性向上のためのアイコンが付与されています
- フラグ項目（非推奨、消込対象、非取引）は3カラムグリッドでアイコン表示されます
