# 画面設計書 40-支払編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける支払編集画面の設計仕様を定義するものです。この画面は会計モジュールの支払管理機能として、既存の支払情報の編集機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：支払編集画面は、登録済みの支払情報を修正するために使用されます。また、支払のワークフロー操作（確認、下書きに戻す、送信済みマーク、キャンセル、拒否）もこの画面から実行できます。Chatter機能によるコメント・履歴管理も可能です。

**画面へのアクセス方法**：支払一覧画面や詳細画面の「編集」ボタンをクリック、または直接URLでアクセスします。URLパターンは `/payments/{record}/edit` です。

**主要な操作・処理内容**：
1. 支払情報の編集（支払タイプ、銀行口座、顧客、支払方法、金額、日付、メモ）
2. ワークフローアクション（確認、下書きに戻す、送信済みマーク、キャンセル、拒否）
3. Chatter機能（コメント、履歴）
4. 入力内容のバリデーション
5. 支払データの更新

**画面遷移**：
- 遷移元：支払一覧画面、支払詳細画面
- 遷移先：保存成功後は支払詳細画面へリダイレクト

**権限による表示制御**：システムの権限設定に基づき、支払リソースへの編集権限を持つユーザーがこの画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-024 | 支払管理 | 主機能 | 支払情報の編集 |
| - | 支払一覧 | 遷移元機能 | 一覧からの編集遷移 |
| - | 支払詳細 | 遷移元/先機能 | 詳細からの編集、保存後リダイレクト |

## 画面種別

編集

## URL/ルーティング

- パス: `/payments/{record}/edit`
- ルート名: `filament.accounts.resources.payments.edit`
- HTTPメソッド: GET（画面表示）、PUT（保存）

## 画面構成

```
+------------------------------------------------------------------+
| ヘッダーアクション                                                  |
| [Chatter] [表示] [削除] [確認] [下書きに戻す] [送信済み/未送信] [キャンセル] [拒否] |
+------------------------------------------------------------------+
| ステータスステッパー（読み取り専用）                                  |
|  [下書き] → [処理中] → [支払済み]                                   |
+------------------------------------------------------------------+
| フォームセクション                                                  |
| +--------------------------------------------------------------+ |
| | 支払タイプ                                                      | |
| | (○) 受取  ( ) 送金                                            | |
| |                                                                | |
| | 顧客銀行口座*                  顧客                             | |
| | [Selectbox         ▼]       [Selectbox         ▼]            | |
| |                                                                | |
| | 支払方法                      金額*                             | |
| | [Selectbox         ▼]       [1000            ]                | |
| |                                                                | |
| | 日付*                         メモ                              | |
| | [2025-12-26       📅]       [支払いについて   ]                 | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
| フッター                                                          |
|                                     [キャンセル] [保存]            |
+------------------------------------------------------------------+
```

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | バリデーション | 備考 |
|--------|--------|--------|----------|------|----------------|------|
| ステータス | state | 表示 | enum | - | - | ProgressStepper、読み取り専用 |
| 支払タイプ | payment_type | 入力 | enum | - | PaymentType列挙型 | ToggleButtons |
| 顧客銀行口座 | partner_bank_id | 入力 | integer | ○ | リレーション存在 | 削除済みも表示（無効化） |
| 顧客 | partner_id | 入力 | integer | - | sub_type=customer | 選択時に連動処理 |
| 支払方法 | payment_method_line_id | 入力 | integer | - | リレーション存在 | PaymentMethodLine |
| 金額 | amount | 入力 | numeric | ○ | 0以上、99999999999以下 | - |
| 日付 | date | 入力 | date | ○ | 有効な日付 | ネイティブピッカー無効 |
| メモ | memo | 入力 | string | - | 最大255文字 | - |

## ヘッダーアクション

| アクション名 | アクションID | 色 | 表示条件 | 処理内容 |
|-------------|-------------|-----|---------|---------|
| Chatter | chatter | - | 常時 | Chatterパネルを開く |
| 表示 | view | - | 常時 | 詳細画面へ遷移 |
| 削除 | delete | danger | 常時 | レコードを削除 |
| 確認 | confirm | gray | state = 'draft' | stateを'in_process'に変更 |
| 下書きに戻す | reset-to-draft | gray | state != 'draft' | stateを'draft'に変更 |
| 送信済み/未送信 | mark-as-sent-or-unsent | gray | state = 'in_process' かつ paymentMethodLine.paymentMethod.code = 'manual' | is_sentをトグル |
| キャンセル | cancel | gray | state != 'canceled' | stateを'canceled'に変更 |
| 拒否 | reject | danger | state = 'in_process' | stateを'rejected'に変更 |

## イベント仕様

### 1-保存ボタン押下

**トリガー**: フォームの「保存」ボタンをクリック

**処理フロー**:
1. 入力値のバリデーション実行
2. バリデーション成功時、accounts_account_paymentsテーブルへのUPDATE処理
3. 成功通知の表示
4. 支払詳細画面へのリダイレクト

### 2-確認アクション

**トリガー**: ヘッダーの「確認」ボタンをクリック

**処理フロー**:
1. stateを'in_process'に更新
2. レコードを保存
3. フォームのstate表示を更新

**表示条件**: stateが'draft'の場合のみ表示

### 3-下書きに戻すアクション

**トリガー**: ヘッダーの「下書きに戻す」ボタンをクリック

**処理フロー**:
1. stateを'draft'に更新
2. レコードを保存
3. フォームのstate表示を更新

**表示条件**: stateが'draft'以外の場合に表示

### 4-送信済み/未送信マークアクション

**トリガー**: ヘッダーの「送信済み」または「未送信にする」ボタンをクリック

**処理フロー**:
1. is_sentの値をトグル（true→false、false→true）
2. レコードを保存
3. フォームの表示を更新

**表示条件**:
- stateが'in_process'の場合
- 支払方法のコードが'manual'の場合

**ラベル変更**: is_sentがtrueなら「未送信にする」、falseなら「送信済みにする」

### 5-キャンセルアクション

**トリガー**: ヘッダーの「キャンセル」ボタンをクリック

**処理フロー**:
1. stateを'canceled'に更新
2. レコードを保存
3. フォームのstate表示を更新

**表示条件**: stateが'canceled'以外の場合に表示

### 6-拒否アクション

**トリガー**: ヘッダーの「拒否」ボタンをクリック

**処理フロー**:
1. stateを'rejected'に更新
2. レコードを保存
3. フォームのstate表示を更新

**表示条件**: stateが'in_process'の場合のみ表示

### 7-Chatterアクション

**トリガー**: ヘッダーの「Chatter」ボタンをクリック

**処理フロー**:
1. Chatterパネルを開く
2. コメント入力・閲覧、アクティビティログの表示

### 8-表示アクション

**トリガー**: ヘッダーの「表示」ボタンをクリック

**処理フロー**:
1. 支払詳細画面への遷移

### 9-削除アクション

**トリガー**: ヘッダーの「削除」ボタンをクリック

**処理フロー**:
1. 削除確認ダイアログの表示
2. 確認後、物理削除実行
3. 一覧画面へのリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_account_payments | UPDATE | 支払の更新 |
| 確認アクション | accounts_account_payments | UPDATE | stateをin_processに更新 |
| 下書きに戻すアクション | accounts_account_payments | UPDATE | stateをdraftに更新 |
| 送信済み/未送信マーク | accounts_account_payments | UPDATE | is_sentをトグル |
| キャンセルアクション | accounts_account_payments | UPDATE | stateをcanceledに更新 |
| 拒否アクション | accounts_account_payments | UPDATE | stateをrejectedに更新 |
| 削除アクション | accounts_account_payments | DELETE | 支払の物理削除 |

### テーブル別更新項目詳細

#### accounts_account_payments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（保存） | payment_type | フォーム入力値 | PaymentType列挙型 |
| UPDATE（保存） | partner_bank_id | フォーム入力値 | FK |
| UPDATE（保存） | partner_id | フォーム入力値 | FK |
| UPDATE（保存） | payment_method_line_id | フォーム入力値 | FK |
| UPDATE（保存） | amount | フォーム入力値 | - |
| UPDATE（保存） | date | フォーム入力値 | - |
| UPDATE（保存） | memo | フォーム入力値 | - |
| UPDATE（確認） | state | 'in_process' | ワークフロー |
| UPDATE（下書きに戻す） | state | 'draft' | ワークフロー |
| UPDATE（送信済みマーク） | is_sent | !is_sent | トグル |
| UPDATE（キャンセル） | state | 'canceled' | ワークフロー |
| UPDATE（拒否） | state | 'rejected' | ワークフロー |
| DELETE | - | WHERE id = {id} | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| notification.title | 成功 | 支払が更新されました | 保存成功時 |
| notification.body | 成功 | 支払が正常に更新されました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面表示 | 指定された支払が見つかりません |
| 必須項目未入力 | フォームエラー表示 | 各フィールドに対応するエラーメッセージ |
| 金額が範囲外 | フォームエラー表示 | 金額は0以上99999999999以下で入力してください |
| アクセス権限不足 | 403エラー画面表示 | この操作を実行する権限がありません |
| データベースエラー | エラー通知表示 | データの保存中にエラーが発生しました |

## 備考

- 本画面はFilament PHPのEditRecordページクラスを継承して実装されています
- HasRecordNavigationTabsトレイトを使用してレコードナビゲーション機能を実装しています
- Chatter機能（ChatterAction）によりコメントと履歴管理が可能です
- ProgressStepperコンポーネントで支払ステータスを表示しますが、編集は読み取り専用です
- ワークフローアクションはヘッダーに配置され、ステータスに応じて表示/非表示が切り替わります
- 確認アクション（ConfirmAction）はdraft状態でのみ表示されます
- 下書きに戻すアクション（ResetToDraftAction）はdraft以外の状態で表示されます
- 送信済み/未送信マークアクション（MarkAsSendAdnUnsentAction）はin_process状態かつ手動支払方法の場合のみ表示されます
- キャンセルアクション（CancelAction）はcanceled以外の状態で表示されます
- 拒否アクション（RejectAction）はin_process状態でのみ表示されます
- 保存後は詳細画面（ViewPayments）にリダイレクトされます
- 顧客選択時の連動処理は作成画面と同様です
