# 画面設計書 41-支払詳細

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「支払詳細」画面の設計仕様を定義する。

### 本画面の処理概要

支払詳細画面は、登録済みの支払情報を詳細表示し、支払処理のワークフローを管理するための画面である。

**業務上の目的・背景**：企業の会計業務において、支払処理は重要な財務活動の一つである。本画面は、個々の支払レコードの詳細情報を確認し、支払の確認・承認・キャンセルなどのワークフロー操作を行うために必要である。これにより、支払処理の透明性を確保し、監査証跡を残すことができる。

**画面へのアクセス方法**：支払一覧画面（ListPayments）から特定の支払レコードを選択して遷移するか、支払作成・編集完了後に自動的にリダイレクトされる。URLパターンは `/payments/{record}` である。

**主要な操作・処理内容**：
1. 支払情報の詳細表示（ステータス、支払タイプ、顧客銀行口座、顧客、支払方法、金額、日付、メモ）
2. 編集画面への遷移
3. 支払レコードの削除
4. 支払の確認（Confirm）処理
5. ドラフトへのリセット
6. 送信済み/未送信マーク
7. 支払のキャンセル
8. 支払の拒否
9. チャッター機能（コメント・履歴）

**画面遷移**：支払一覧画面から遷移し、編集アクション実行時は支払編集画面へ遷移する。削除後は支払一覧画面へ戻る。

**権限による表示制御**：各アクションボタンは支払の状態（state）に応じて表示/非表示が制御される。ドラフト状態では確認ボタンが表示され、確認済み状態ではキャンセル・拒否ボタンが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-012 | 支払表示 | 主機能 | 支払詳細情報の表示 |
| FN-ACC-011 | 支払編集 | 遷移先機能 | 編集画面への遷移 |
| FN-ACC-009 | 支払一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

```
/payments/{record}
```

## 画面構成

1. **ヘッダーアクションエリア**
   - チャッター（ChatterAction）
   - 編集ボタン（EditAction）
   - 削除ボタン（DeleteAction）
   - 確認ボタン（ConfirmAction）
   - ドラフトにリセット（ResetToDraftAction）
   - 送信済み/未送信マーク（MarkAsSendAndUnsentAction）
   - キャンセル（CancelAction）
   - 拒否（RejectAction）

2. **詳細情報セクション**
   - 支払情報グリッド（2カラム）

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 状態 | state | string | バッジ | 支払ステータス（Draft/In Process/Paid/Canceled） |
| 2 | 支払タイプ | payment_type | string | バッジ+アイコン | 受取/支払の区分 |
| 3 | 顧客銀行口座 | partnerBank.account_number | string | テキスト+アイコン | 支払先の銀行口座番号 |
| 4 | 顧客 | partner.name | string | テキスト+アイコン | 取引先名 |
| 5 | 支払方法 | paymentMethodLine.name | string | テキスト+アイコン | 支払方法名 |
| 6 | 金額 | amount | decimal | 通貨形式+アイコン | 支払金額 |
| 7 | 日付 | date | date | 日付形式+アイコン | 支払日 |
| 8 | メモ | memo | string | テキスト+アイコン | 備考 |

## イベント仕様

### 1-編集ボタン押下

編集画面（EditPayments）へ遷移する。URLは `/payments/{record}/edit`。

### 2-削除ボタン押下

確認ダイアログを表示後、支払レコードを削除し、一覧画面へリダイレクトする。成功時に通知メッセージを表示する。

### 3-確認ボタン押下（ConfirmAction）

支払を確認済み状態（In Process）に更新する。ドラフト状態のときのみ表示される。

### 4-ドラフトにリセット押下（ResetToDraftAction）

支払状態をドラフトに戻す。確認済み状態のときのみ表示される。

### 5-キャンセル押下（CancelAction）

支払をキャンセル状態に更新する。

### 6-拒否押下（RejectAction）

支払を拒否する処理を実行する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | accounts_account_payments | DELETE | 支払レコードの削除 |
| 確認ボタン押下 | accounts_account_payments | UPDATE | state を 'in_process' に更新 |
| ドラフトリセット押下 | accounts_account_payments | UPDATE | state を 'draft' に更新 |
| キャンセル押下 | accounts_account_payments | UPDATE | state を 'canceled' に更新 |

### テーブル別更新項目詳細

#### accounts_account_payments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | PaymentStatus の各値 | 確認/リセット/キャンセル時 |
| UPDATE | updated_at | now() | 更新日時 |
| DELETE | - | id = {record} | 削除時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | header-actions.delete.notification.title | 削除成功タイトル |
| 2 | 成功 | header-actions.delete.notification.body | 削除成功メッセージ本文 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | レコードが存在しない | 404エラーページを表示 |
| 2 | 削除権限がない | 権限エラーメッセージを表示 |
| 3 | 削除対象が関連データに紐づいている | 削除失敗エラーを表示 |

## 備考

- HasRecordNavigationTabs トレイトを使用してレコード間ナビゲーション機能を実装
- ChatterAction によりコメント・履歴機能を提供
- 状態に応じて表示されるアクションボタンが動的に変化する
