# 画面設計書 42-返金一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「返金一覧」画面の設計仕様を定義する。

### 本画面の処理概要

返金一覧画面は、システムに登録された返金（Refund）レコードを一覧表示し、検索・フィルタリング・ソートなどの操作を通じて効率的に返金データを管理するための画面である。

**業務上の目的・背景**：企業の会計業務において、返金処理は売上返品や誤請求の訂正など、様々なビジネスシナリオで発生する。本画面は、返金レコードを一元的に管理し、迅速に必要な返金情報にアクセスできるようにすることで、経理業務の効率化と正確性の向上を実現する。返金は仕入先への返金（IN_REFUND）として処理される。

**画面へのアクセス方法**：会計モジュールのナビゲーションメニューから「返金」を選択してアクセスする。RefundResourceは直接ナビゲーションに登録されていないため、他の画面からの遷移または直接URLアクセスとなる。

**主要な操作・処理内容**：
1. 返金レコードの一覧表示（テーブル形式）
2. 各種条件による検索・フィルタリング
3. カラムによるソート
4. 返金の新規作成画面への遷移
5. 個別返金の詳細・編集画面への遷移
6. 返金レコードの削除
7. 一括削除操作

**画面遷移**：本画面から返金作成画面、返金詳細画面、返金編集画面へ遷移可能。他の会計関連画面からも遷移してくる。

**権限による表示制御**：ユーザーの権限に応じて、作成・編集・削除ボタンの表示/非表示が制御される。会社（company_id）によるデータフィルタリングが適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-013 | 返金一覧 | 主機能 | 返金データの一覧表示・検索・フィルタ |
| FN-ACC-014 | 返金作成 | 遷移先機能 | 新規返金作成画面への遷移 |
| FN-ACC-015 | 返金編集 | 遷移先機能 | 返金編集画面への遷移 |
| FN-ACC-016 | 返金詳細 | 遷移先機能 | 返金詳細画面への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

```
/refunds
```

## 画面構成

1. **ヘッダーエリア**
   - 画面タイトル
   - 新規作成ボタン（未定義の場合、デフォルトなし）

2. **テーブルエリア**
   - InvoiceResource（BillResource経由）のテーブル定義を継承
   - ソート可能なカラム
   - 検索・フィルタ機能
   - ページネーション

3. **アクションエリア**
   - 行アクション（表示・編集・削除）
   - 一括アクション（一括削除）

## 入出力項目

該当なし（一覧表示画面のため直接入力項目なし。フィルタ条件は別途定義）

## 表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 番号 | name | string | テキスト | 返金番号 |
| 2 | 取引先 | invoice_partner_display_name | string | テキスト | 仕入先名 |
| 3 | 請求日 | invoice_date | date | 日付 | 返金請求日 |
| 4 | 支払期日 | invoice_date_due | date | 日付 | 支払期限 |
| 5 | 状態 | state | string | バッジ | ドラフト/投稿済/キャンセル |
| 6 | 支払状態 | payment_state | string | バッジ | 未払い/支払済/一部支払 |
| 7 | 金額 | amount_total | decimal | 通貨形式 | 返金合計金額 |
| 8 | 会社 | company.name | string | テキスト | 所属会社 |

## イベント仕様

### 1-新規作成ボタン押下

返金作成画面（CreateRefund）へ遷移する。URLは `/refunds/create`。

### 2-行クリック（表示）

選択した返金の詳細画面（ViewRefund）へ遷移する。URLは `/refunds/{record}`。

### 3-編集アクション押下

選択した返金の編集画面（EditRefund）へ遷移する。URLは `/refunds/{record}/edit`。

### 4-削除アクション押下

確認ダイアログを表示後、返金レコードを削除する。削除成功時に通知メッセージを表示。

### 5-一括削除押下

選択した複数の返金レコードを一括削除する。確認ダイアログを表示後に実行。

### 6-フィルタ適用

指定された条件でテーブルデータをフィルタリングする。

### 7-ソート実行

指定されたカラムでテーブルデータをソートする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | accounts_moves | SELECT | 返金データの取得 |
| 削除アクション押下 | accounts_moves | DELETE | 返金レコードの削除 |
| 一括削除押下 | accounts_moves | DELETE | 複数返金レコードの削除 |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | move_type = 'in_refund' | 返金タイプでフィルタ |
| DELETE | - | id IN (選択されたID) | 削除対象のID |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | delete.notification.title | 削除成功タイトル |
| 2 | 成功 | delete.notification.body | 削除成功メッセージ本文 |
| 3 | 成功 | bulk-delete.notification.title | 一括削除成功タイトル |
| 4 | 成功 | bulk-delete.notification.body | 一括削除成功メッセージ本文 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | データ取得エラー | エラーメッセージを表示 |
| 2 | 削除権限がない | 権限エラーメッセージを表示 |
| 3 | 関連データが存在するため削除不可 | 削除失敗エラーを表示 |

## 備考

- RefundResourceはBillResourceを継承しており、多くの機能を共有している
- move_type が IN_REFUND の場合に返金として扱われる
- テーブル表示はInvoiceResourceのテーブル定義を使用
- shouldRegisterNavigation = false のため、直接ナビゲーションには表示されない
