# 画面設計書 43-返金作成

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「返金作成」画面の設計仕様を定義する。

### 本画面の処理概要

返金作成画面は、新規の返金（Refund）レコードを作成するためのフォーム画面である。仕入先への返金処理を登録し、会計処理の基盤となるデータを入力する。

**業務上の目的・背景**：企業の会計業務において、仕入先への返金は商品の返品、過払い金の返還、品質問題に対する補償など、様々な理由で発生する。本画面は、これらの返金処理を正確に記録し、会計帳簿への適切な反映を可能にする。返金はIN_REFUND（仕入先返金）タイプとして処理され、BillResourceの作成フォームを継承している。

**画面へのアクセス方法**：返金一覧画面の新規作成ボタンから遷移するか、URLを直接入力してアクセスする。URLパターンは `/refunds/create`。

**主要な操作・処理内容**：
1. 仕入先（ベンダー）の選択
2. 返金日・会計日の入力
3. 参照番号の入力
4. 銀行口座の選択
5. 支払条件・支払期日の設定
6. 返金明細（商品ライン）の追加
7. 追加情報（インコターム、支払方法、会社、通貨）の設定
8. 利用規約・メモの入力
9. 返金データの保存

**画面遷移**：返金一覧画面から遷移し、保存完了後は返金詳細画面へリダイレクトされる。

**権限による表示制御**：ユーザーの会社設定（default_company_id）に基づいて初期値が設定される。権限に応じてフォームの表示・操作が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-014 | 返金作成 | 主機能 | 新規返金データの登録 |
| FN-ACC-013 | 返金一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-ACC-016 | 返金詳細 | 遷移先機能 | 作成完了後の遷移 |

## 画面種別

登録（Create）

## URL/ルーティング

```
/refunds/create
```

## 画面構成

1. **ステータスエリア**
   - ProgressStepper（状態表示）- 初期値: Draft

2. **一般情報セクション**
   - ベンダー選択
   - 返金日
   - 参照番号
   - 会計日
   - 支払参照
   - 銀行口座
   - 支払期日/支払条件

3. **タブエリア**
   - 返金明細タブ（商品ライン）
   - その他情報タブ（会計情報、セキュリティ、追加情報）
   - 利用規約タブ

4. **サマリーエリア**
   - InvoiceSummary コンポーネント（小計・税・合計）

## 入出力項目

| No | 項目名 | 物理名 | データ型 | 必須 | 初期値 | バリデーション | 説明 |
|----|--------|--------|----------|------|--------|---------------|------|
| 1 | 状態 | state | string | - | draft | - | 自動設定 |
| 2 | 仕入先 | partner_id | integer | - | - | 仕入先マスタ存在 | 取引先選択 |
| 3 | 返金日 | invoice_date | date | - | now() | 日付形式 | 返金請求日 |
| 4 | 参照番号 | reference | string | - | - | 最大255文字 | 請求書参照 |
| 5 | 会計日 | date | date | - | now() | 日付形式 | 会計処理日 |
| 6 | 支払参照 | payment_reference | string | - | - | 最大255文字 | 支払参照番号 |
| 7 | 銀行口座 | partner_bank_id | integer | - | - | 銀行口座マスタ存在 | 受取銀行口座 |
| 8 | 支払期日 | invoice_date_due | date | 条件付き | now() | 日付形式 | 支払条件未設定時必須 |
| 9 | 支払条件 | invoice_payment_term_id | integer | 条件付き | - | 支払条件マスタ存在 | 支払期日未設定時必須 |
| 10 | インコターム | invoice_incoterm_id | integer | - | - | インコタームマスタ存在 | 国際取引条件 |
| 11 | インコタームロケーション | incoterm_location | string | - | - | - | 引渡場所 |
| 12 | 支払方法 | preferred_payment_method_line_id | integer | - | - | 支払方法マスタ存在 | 優先支払方法 |
| 13 | 自動記帳 | auto_post | boolean | - | false | - | 自動記帳フラグ |
| 14 | 確認済み | checked | boolean | - | false | - | 確認フラグ |
| 15 | 会社 | company_id | integer | - | ログインユーザーのdefault_company_id | 会社マスタ存在 | 所属会社 |
| 16 | 通貨 | currency_id | integer | ○ | 会社の通貨 | 通貨マスタ存在 | 取引通貨 |
| 17 | 備考 | narration | text | - | - | - | 利用規約・メモ |

## 表示項目

該当なし（入力フォーム画面のため）

## イベント仕様

### 1-仕入先選択変更

仕入先が変更された際、以下の項目を自動設定する：
- partner_bank_id: 仕入先の最初の銀行口座
- preferred_payment_method_line_id: 仕入先のpropertyOutboundPaymentMethodLine
- invoice_payment_term_id: 仕入先のpropertySupplierPaymentTerm

### 2-会社選択変更

会社が変更された際、currency_id を会社のデフォルト通貨に更新する。

### 3-商品追加・編集

商品ラインの追加・編集時、小計・税額・合計を自動計算する。

### 4-保存ボタン押下

入力データのバリデーションを実行し、accounts_movesテーブルにレコードを作成する。作成後、返金詳細画面へリダイレクトする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_moves | INSERT | 返金レコードの新規作成 |
| 保存ボタン押下 | accounts_move_lines | INSERT | 返金明細の新規作成 |
| 保存完了後 | accounts_moves | UPDATE | Account::computeAccountMove による計算 |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | 'in_refund' | MoveType::IN_REFUND |
| INSERT | date | now() | 現在日時 |
| INSERT | state | 'draft' | 初期状態 |
| INSERT | partner_id | フォーム入力値 | 仕入先ID |
| INSERT | invoice_date | フォーム入力値 | 返金日 |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | currency_id | フォーム入力値 | 通貨ID |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | notification.title | 返金作成成功タイトル |
| 2 | 成功 | notification.body | 返金作成成功メッセージ本文 |
| 3 | エラー | validation.required | 必須項目エラー |
| 4 | エラー | validation.date | 日付形式エラー |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | 必須項目未入力 | バリデーションエラーを表示 |
| 2 | 仕入先が存在しない | 選択エラーを表示 |
| 3 | データベース保存エラー | エラーメッセージを表示、ロールバック |

## 備考

- CreateRefundはCreateInvoice（CreateBaseRefund）を継承している
- 保存後にAccount::computeAccountMoveが呼び出され、会計計算が実行される
- move_typeはIN_REFUNDとして自動設定される
- 日付（date）は現在日時で自動設定される
- 商品リピーターはBillResourceのgetProductRepeater()を使用
