# 画面設計書 44-返金編集

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「返金編集」画面の設計仕様を定義する。

### 本画面の処理概要

返金編集画面は、既存の返金（Refund）レコードを編集するためのフォーム画面である。返金情報の修正、ワークフロー操作（支払・キャンセル・確認など）を実行できる。

**業務上の目的・背景**：会計処理において、返金情報の修正は不可欠な機能である。入力ミスの修正、追加情報の入力、返金状態の変更などを行い、正確な会計記録を維持する。ただし、投稿済み（Posted）またはキャンセル済み（Cancel）の返金は編集が制限される。

**画面へのアクセス方法**：返金一覧画面または返金詳細画面から編集アクションを選択して遷移する。URLパターンは `/refunds/{record}/edit`。

**主要な操作・処理内容**：
1. 返金情報の表示・編集
2. 返金明細（商品ライン）の編集
3. 支払処理（PayAction）
4. キャンセル処理（CancelAction）
5. 確認処理（ConfirmAction）
6. ドラフトへのリセット（ResetToDraftAction）
7. 確認済みマーク（SetAsCheckedAction）
8. 返金データの削除
9. チャッター機能（コメント・履歴）
10. 変更の保存

**画面遷移**：返金一覧画面・詳細画面から遷移し、保存完了後は返金詳細画面へリダイレクトされる。

**権限による表示制御**：返金の状態（state）に応じてアクションボタンの表示/非表示が制御される。Posted/Cancel状態では多くのフォーム項目が無効化される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-015 | 返金編集 | 主機能 | 返金データの編集・更新 |
| FN-ACC-013 | 返金一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-ACC-016 | 返金詳細 | 遷移先機能 | 保存後の遷移 |

## 画面種別

編集（Edit）

## URL/ルーティング

```
/refunds/{record}/edit
```

## 画面構成

1. **ヘッダーアクションエリア**
   - チャッター（ChatterAction）
   - 支払（PayAction）
   - キャンセル（CancelAction）
   - 確認（ConfirmAction）
   - ドラフトにリセット（ResetToDraftAction）
   - 確認済みマーク（SetAsCheckedAction）
   - 削除（DeleteAction）

2. **ステータスエリア**
   - ProgressStepper（状態表示）

3. **一般情報セクション**
   - ベンダー選択
   - 返金日
   - 参照番号
   - 会計日
   - 支払参照
   - 銀行口座
   - 支払期日/支払条件

4. **タブエリア**
   - 返金明細タブ（商品ライン）
   - その他情報タブ
   - 利用規約タブ

5. **サマリーエリア**
   - InvoiceSummary コンポーネント

## 入出力項目

| No | 項目名 | 物理名 | データ型 | 必須 | 編集可否 | バリデーション | 説明 |
|----|--------|--------|----------|------|----------|---------------|------|
| 1 | 状態 | state | string | - | 不可 | - | 自動管理 |
| 2 | 仕入先 | partner_id | integer | - | 状態依存 | 存在チェック | Posted/Cancel時は編集不可 |
| 3 | 返金日 | invoice_date | date | - | 状態依存 | 日付形式 | Posted/Cancel時は編集不可 |
| 4 | 参照番号 | reference | string | - | 状態依存 | 最大255文字 | Posted/Cancel時は編集不可 |
| 5 | 会計日 | date | date | - | 状態依存 | 日付形式 | Posted/Cancel時は編集不可 |
| 6 | 支払参照 | payment_reference | string | - | 状態依存 | 最大255文字 | Posted/Cancel時は編集不可 |
| 7 | 銀行口座 | partner_bank_id | integer | - | 状態依存 | 存在チェック | Posted/Cancel時は編集不可 |
| 8 | 支払期日 | invoice_date_due | date | 条件付き | 可 | 日付形式 | 支払条件未設定時必須 |
| 9 | 支払条件 | invoice_payment_term_id | integer | 条件付き | 可 | 存在チェック | 支払期日未設定時必須 |
| 10 | 自動記帳 | auto_post | boolean | - | 状態依存 | - | Posted/Cancel時は編集不可 |
| 11 | 確認済み | checked | boolean | - | 可 | - | 確認フラグ |
| 12 | 会社 | company_id | integer | - | 可 | 存在チェック | 所属会社 |
| 13 | 通貨 | currency_id | integer | ○ | 可 | 存在チェック | 取引通貨 |
| 14 | 備考 | narration | text | - | 可 | - | 利用規約・メモ |

## 表示項目

該当なし（編集フォーム画面のため表示専用項目なし）

## イベント仕様

### 1-保存ボタン押下

入力データのバリデーションを実行し、accounts_movesテーブルを更新する。保存後、Account::computeAccountMoveで会計計算を実行し、詳細画面へリダイレクトする。

### 2-支払ボタン押下（PayAction）

支払処理ダイアログを表示し、返金に対する支払を実行する。

### 3-キャンセルボタン押下（CancelAction）

返金をキャンセル状態に更新する。確認ダイアログを表示後に実行。

### 4-確認ボタン押下（ConfirmAction）

返金を確認済み（Posted）状態に更新する。

### 5-ドラフトリセット押下（ResetToDraftAction）

返金をドラフト状態に戻す。

### 6-確認済みマーク押下（SetAsCheckedAction）

checkedフラグをtrueに設定する。

### 7-削除ボタン押下

確認ダイアログを表示後、返金レコードを削除する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_moves | UPDATE | 返金レコードの更新 |
| 保存ボタン押下 | accounts_move_lines | UPDATE/INSERT/DELETE | 返金明細の同期 |
| 確認ボタン押下 | accounts_moves | UPDATE | state を 'posted' に更新 |
| キャンセル押下 | accounts_moves | UPDATE | state を 'cancel' に更新 |
| ドラフトリセット | accounts_moves | UPDATE | state を 'draft' に更新 |
| 削除押下 | accounts_moves | DELETE | 返金レコードの削除 |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値またはレコード既存値 | null合体演算子で処理 |
| UPDATE | invoice_date | フォーム入力値またはレコード既存値 | null合体演算子で処理 |
| UPDATE | name | フォーム入力値またはレコード既存値 | null合体演算子で処理 |
| UPDATE | auto_post | フォーム入力値またはレコード既存値 | null合体演算子で処理 |
| UPDATE | invoice_currency_rate | フォーム入力値またはデフォルト1.0 | 為替レート |
| UPDATE | updated_at | now() | 更新日時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | notification.title | 返金更新成功タイトル |
| 2 | 成功 | notification.body | 返金更新成功メッセージ本文 |
| 3 | エラー | validation.required | 必須項目エラー |
| 4 | エラー | validation.date | 日付形式エラー |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | レコードが存在しない | 404エラーページを表示 |
| 2 | 必須項目未入力 | バリデーションエラーを表示 |
| 3 | Posted/Cancel状態で編集不可項目を変更 | エラーを表示 |
| 4 | データベース更新エラー | エラーメッセージを表示 |

## 備考

- EditRefundはEditRecordを継承している
- HasRecordNavigationTabs トレイトによりレコード間ナビゲーション機能を提供
- mutateFormDataBeforeSaveで既存値をフォールバックとして使用
- afterSaveでAccount::computeAccountMoveを実行し会計計算を更新
- フォーム項目の多くはstate（Posted/Cancel）に応じて無効化される
