# 画面設計書 45-返金詳細

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「返金詳細」画面の設計仕様を定義する。

### 本画面の処理概要

返金詳細画面は、登録済みの返金（Refund）レコードを詳細表示し、返金処理のワークフロー管理を行うための画面である。

**業務上の目的・背景**：会計業務において、返金の詳細情報を確認することは、取引先との確認作業、監査対応、経理処理の確認など様々な場面で必要となる。本画面は、返金レコードの全情報を一覧できるビューを提供し、ワークフロー操作（支払・キャンセル・確認など）を実行可能にする。これにより、返金処理の進捗管理と意思決定を支援する。

**画面へのアクセス方法**：返金一覧画面から特定の返金レコードを選択するか、返金作成・編集完了後に自動リダイレクトされる。URLパターンは `/refunds/{record}`。

**主要な操作・処理内容**：
1. 返金情報の詳細表示（ヘッダー情報、明細、その他情報）
2. 支払処理（PayAction）
3. キャンセル処理（CancelAction）
4. 確認処理（ConfirmAction）
5. ドラフトへのリセット（ResetToDraftAction）
6. 確認済みマーク（SetAsCheckedAction）
7. 返金レコードの削除
8. チャッター機能（コメント・履歴）

**画面遷移**：返金一覧画面から遷移し、編集アクション実行時は返金編集画面へ遷移する。削除後は返金一覧画面へ戻る。

**権限による表示制御**：返金の状態（state）および支払状態（payment_state）に応じてアクションボタンの表示/非表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-016 | 返金詳細 | 主機能 | 返金詳細情報の表示 |
| FN-ACC-015 | 返金編集 | 遷移先機能 | 編集画面への遷移 |
| FN-ACC-013 | 返金一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

```
/refunds/{record}
```

## 画面構成

1. **ヘッダーアクションエリア**
   - チャッター（ChatterAction）
   - 支払（PayAction）
   - キャンセル（CancelAction）
   - 確認（ConfirmAction）
   - ドラフトにリセット（ResetToDraftAction）
   - 確認済みマーク（SetAsCheckedAction）
   - 削除（DeleteAction）

2. **支払状態セクション**
   - 支払状態バッジ（Paid/Reversed時に表示）

3. **一般情報セクション**
   - 返金番号
   - 仕入先/仕入先表示名
   - 返金日
   - 参照番号
   - 会計日
   - 支払参照
   - 銀行口座
   - 支払期日
   - 支払条件

4. **タブエリア**
   - 返金明細タブ（商品ラインテーブル、サマリー）
   - その他情報タブ（会計情報、セキュリティ、追加情報）
   - 利用規約タブ

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 支払状態 | payment_state | enum | バッジ | 未払い/支払済/一部支払/リバース |
| 2 | 返金番号 | name | string | テキスト（大・太字） | 返金伝票番号 |
| 3 | 仕入先 | partner.name | string | テキスト+アイコン | 取引先名（partner_id設定時） |
| 4 | 仕入先表示名 | invoice_partner_display_name | string | テキスト+アイコン | 取引先名（partner_id未設定時） |
| 5 | 返金日 | invoice_date | date | 日付+アイコン | 返金請求日 |
| 6 | 参照番号 | reference | string | テキスト | 請求書参照 |
| 7 | 会計日 | date | date | 日付+アイコン | 会計処理日 |
| 8 | 支払参照 | payment_reference | string | テキスト | 支払参照番号 |
| 9 | 銀行口座 | partnerBank.account_number | string | テキスト | 受取銀行口座 |
| 10 | 支払期日 | invoice_date_due | date | 日付+アイコン | 支払期限 |
| 11 | 支払条件 | invoicePaymentTerm.name | string | テキスト+アイコン | 支払条件名 |

### 返金明細（lines）の表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 商品名 | name | string | テキスト | 商品・サービス名 |
| 2 | 数量 | quantity | decimal | 数値 | 数量 |
| 3 | 単位 | uom.name | string | テキスト | 単位名（UOM有効時） |
| 4 | 単価 | price_unit | decimal | 通貨 | 単位価格 |
| 5 | 割引 | discount | decimal | パーセント | 割引率 |
| 6 | 税 | taxes | array | バッジ | 適用税リスト |
| 7 | 小計 | price_subtotal | decimal | 通貨 | 行小計 |

### その他情報タブの表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | インコターム | invoiceIncoterm.name | string | テキスト+アイコン | 国際取引条件 |
| 2 | インコタームロケーション | incoterm_location | string | テキスト+アイコン | 引渡場所 |
| 3 | 支払方法 | paymentMethodLine.name | string | テキスト+アイコン | 支払方法 |
| 4 | 自動記帳 | auto_post | boolean | アイコン | 自動記帳フラグ |
| 5 | 会社 | company.name | string | テキスト+アイコン | 所属会社 |
| 6 | 通貨 | currency.name | string | テキスト+アイコン | 取引通貨 |

## イベント仕様

### 1-支払ボタン押下（PayAction）

支払処理ダイアログを表示し、返金に対する支払を実行する。ドラフト以外の状態で表示される。

### 2-キャンセルボタン押下（CancelAction）

返金をキャンセル状態に更新する。確認ダイアログを表示後に実行。

### 3-確認ボタン押下（ConfirmAction）

返金を確認済み（Posted）状態に更新する。ドラフト状態のときに表示される。

### 4-ドラフトリセット押下（ResetToDraftAction）

返金をドラフト状態に戻す。Posted/Cancel状態のときに表示される。

### 5-確認済みマーク押下（SetAsCheckedAction）

checkedフラグをtrueに設定する。

### 6-削除ボタン押下

確認ダイアログを表示後、返金レコードを削除し、一覧画面へリダイレクトする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | accounts_moves | SELECT | 返金データの取得 |
| 詳細表示 | accounts_move_lines | SELECT | 返金明細の取得 |
| 確認ボタン押下 | accounts_moves | UPDATE | state を 'posted' に更新 |
| キャンセル押下 | accounts_moves | UPDATE | state を 'cancel' に更新 |
| ドラフトリセット | accounts_moves | UPDATE | state を 'draft' に更新 |
| 削除押下 | accounts_moves | DELETE | 返金レコードの削除 |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | id = {record}, move_type = 'in_refund' | 取得条件 |
| UPDATE | state | MoveState の各値 | 確認/リセット/キャンセル時 |
| UPDATE | checked | true | 確認済みマーク時 |
| UPDATE | updated_at | now() | 更新日時 |
| DELETE | - | id = {record} | 削除時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | delete.notification.title | 削除成功タイトル |
| 2 | 成功 | delete.notification.body | 削除成功メッセージ本文 |
| 3 | 成功 | confirm.notification.title | 確認成功タイトル |
| 4 | 成功 | cancel.notification.title | キャンセル成功タイトル |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | レコードが存在しない | 404エラーページを表示 |
| 2 | 削除権限がない | 権限エラーメッセージを表示 |
| 3 | 削除対象が支払済み | 削除不可エラーを表示 |

## 備考

- ViewRefundはViewRecordを継承している
- HasRecordNavigationTabs トレイトによりレコード間ナビゲーション機能を提供
- infolistはBillResourceから継承し、返金の詳細表示に使用
- InvoiceSummary Livewireコンポーネントで合計金額を表示
- RepeatableEntry で商品ラインをテーブル形式で表示
- 支払状態バッジはPaid/Reversedの場合のみ表示される
