# 画面設計書 46-税一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「税一覧」画面の設計仕様を定義する。

### 本画面の処理概要

税一覧画面は、システムに登録された税（Tax）マスタを一覧表示し、税率の管理・検索・フィルタリングを行うための画面である。

**業務上の目的・背景**：企業の会計・税務処理において、消費税、付加価値税（VAT）、その他の税金の管理は不可欠である。本画面は、請求書や仕入伝票に適用される税率を一元管理し、税務コンプライアンスを確保するための基盤を提供する。売上用税、仕入用税、サービス税、商品税など、様々な税種別をプリセットビューで素早くフィルタリングできる。

**画面へのアクセス方法**：会計モジュールの設定メニューから「税」を選択してアクセスする。TaxResourceはshouldRegisterNavigation = falseのため、直接ナビゲーションには登録されていない。

**主要な操作・処理内容**：
1. 税レコードの一覧表示（テーブル形式）
2. プリセットビューによるフィルタリング（売上/仕入/サービス/商品/アクティブ/非アクティブ）
3. グループ化機能（名前、会社、税グループ、国など）
4. 税の新規作成画面への遷移
5. 個別税の詳細・編集画面への遷移
6. 税レコードの削除（外部キー制約考慮）
7. 一括削除操作
8. ドラッグ&ドロップによる並び替え

**画面遷移**：本画面から税作成画面、税詳細画面、税編集画面へ遷移可能。

**権限による表示制御**：会社（company_id）によるデータフィルタリングが適用される。削除操作は外部キー制約によりエラーとなる可能性がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-017 | 税一覧 | 主機能 | 税データの一覧表示・検索・フィルタ |
| FN-ACC-018 | 税作成 | 遷移先機能 | 新規税作成画面への遷移 |
| FN-ACC-019 | 税編集 | 遷移先機能 | 税編集画面への遷移 |
| FN-ACC-020 | 税詳細 | 遷移先機能 | 税詳細画面への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

```
/taxes
```

## 画面構成

1. **ヘッダーアクションエリア**
   - 新規作成ボタン（CreateAction + heroicon-o-plus-circle）

2. **プリセットビュータブ**
   - 売上（Sale）- type_tax_use = SALE
   - 仕入（Purchase）- type_tax_use = PURCHASE
   - 税スコープ（Tax Scope）- tax_scope = SERVICE
   - 商品（Goods）- tax_scope = CONSU
   - アクティブ（Active）- is_active = true
   - 非アクティブ（Inactive）- is_active = false

3. **テーブルエリア**
   - カラム管理機能（2カラム）
   - リオーダー可能なカラム
   - ソート可能なカラム
   - ドラッグ&ドロップによる並び替え

4. **アクションエリア**
   - 行アクションメニュー（編集・表示・削除）
   - 一括アクション（一括削除）

## 入出力項目

該当なし（一覧表示画面のため直接入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | ソート | トグル | 説明 |
|----|--------|--------|----------|----------|--------|--------|------|
| 1 | 名前 | name | string | テキスト | ○ | 表示 | 税名称 |
| 2 | 会社 | company.name | string | テキスト | ○ | 表示 | 所属会社 |
| 3 | 税グループ | taxGroup.name | string | テキスト | ○ | 表示 | 税グループ名 |
| 4 | 国 | country.name | string | テキスト | ○ | 非表示 | 適用国 |
| 5 | 税タイプ | type_tax_use | enum | テキスト | ○ | 表示 | 売上/仕入/なし |
| 6 | 税スコープ | tax_scope | enum | テキスト | ○ | 非表示 | サービス/商品 |
| 7 | 金額タイプ | amount_type | enum | テキスト | ○ | 非表示 | 固定/パーセント |
| 8 | 請求書ラベル | invoice_label | string | テキスト | ○ | 表示 | 請求書表示名 |
| 9 | 税確定性 | tax_exigibility | string | テキスト | ○ | 非表示 | 税確定タイミング |
| 10 | 価格含有 | price_include_override | string | テキスト | ○ | 非表示 | 価格に税含む |
| 11 | 金額 | amount | decimal | 数値 | ○ | 非表示 | 税率（%） |
| 12 | ステータス | is_active | boolean | アイコン | ○ | 表示 | 有効/無効 |
| 13 | 基本金額含む | include_base_amount | boolean | アイコン | ○ | 非表示 | 基本金額に含むか |
| 14 | 基本影響 | is_base_affected | boolean | アイコン | ○ | 非表示 | 基本に影響するか |

## イベント仕様

### 1-新規作成ボタン押下

税作成画面（CreateTax）へ遷移する。URLは `/taxes/create`。

### 2-行クリック（表示）

選択した税の詳細画面（ViewTax）へ遷移する。URLは `/taxes/{record}`。

### 3-編集アクション押下

選択した税の編集画面（EditTax）へ遷移する。URLは `/taxes/{record}/edit`。

### 4-削除アクション押下

確認ダイアログを表示後、税レコードを削除する。外部キー制約違反の場合はエラー通知を表示する。

### 5-一括削除押下

選択した複数の税レコードを一括削除する。外部キー制約違反の場合は処理を中断しエラー通知を表示する。

### 6-プリセットビュー選択

選択されたプリセットビューの条件でテーブルデータをフィルタリングする。

### 7-ドラッグ&ドロップ並び替え

sortカラムを更新し、税の表示順序を変更する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | accounts_taxes | SELECT | 税データの取得 |
| 削除アクション押下 | accounts_taxes | DELETE | 税レコードの削除 |
| 一括削除押下 | accounts_taxes | DELETE | 複数税レコードの削除 |
| ドラッグ&ドロップ | accounts_taxes | UPDATE | sortカラムの更新 |

### テーブル別更新項目詳細

#### accounts_taxes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | company_id等によるフィルタ | 一覧取得 |
| DELETE | - | id IN (選択されたID) | 外部キー制約あり |
| UPDATE | sort | 新しい並び順 | ドラッグ&ドロップ時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | delete.notification.success.title | 削除成功タイトル |
| 2 | 成功 | delete.notification.success.body | 削除成功メッセージ本文 |
| 3 | エラー | delete.notification.error.title | 削除失敗タイトル |
| 4 | エラー | delete.notification.error.body | 削除失敗メッセージ（外部キー制約） |
| 5 | 成功 | bulk-delete.notification.success.title | 一括削除成功タイトル |
| 6 | 成功 | bulk-delete.notification.success.body | 一括削除成功メッセージ |
| 7 | エラー | bulk-delete.notification.error.title | 一括削除失敗タイトル |
| 8 | エラー | bulk-delete.notification.error.body | 一括削除失敗メッセージ |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | データ取得エラー | エラーメッセージを表示 |
| 2 | 削除時の外部キー制約違反 | QueryException をキャッチしエラー通知を表示 |
| 3 | 一括削除時の外部キー制約違反 | QueryException をキャッチしエラー通知を表示、処理中断 |

## 備考

- HasTableViews トレイトを使用してプリセットビュー機能を実装
- SortableTrait により並び替え機能を提供（sort カラム使用）
- 削除操作は try-catch で QueryException をキャッチし、外部キー制約違反時に適切なエラー表示を行う
- テーブルはreorderable('sort', 'desc')で並び替え可能に設定
- カラムマネージャーは2カラム表示
- 一部カラムはデフォルトで非表示（toggleable(isToggledHiddenByDefault: true)）
