# 画面設計書 47-税作成

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「税作成」画面の設計仕様を定義する。

### 本画面の処理概要

税作成画面は、新規の税（Tax）マスタを作成するためのフォーム画面である。消費税、付加価値税、その他の税率を登録し、会計処理で使用できるようにする。

**業務上の目的・背景**：企業の会計・税務処理において、適切な税率設定は法令遵守の基盤である。本画面では、売上用税、仕入用税などの用途別、サービス用、商品用などのスコープ別に税を登録できる。税の作成時には、請求書・返金用の配分（Distribution）レコードも自動的に作成される。

**画面へのアクセス方法**：税一覧画面の新規作成ボタンから遷移するか、URLを直接入力してアクセスする。URLパターンは `/taxes/create`。サブナビゲーションはトップに配置される。

**主要な操作・処理内容**：
1. 税名称の入力
2. 税タイプ（売上/仕入/なし）の選択
3. 税計算方法（固定/パーセント/グループ）の選択
4. 税スコープ（サービス/商品）の選択
5. ステータス（有効/無効）の設定
6. 税額（%）の入力
7. 高度な設定（請求書ラベル、税グループ、国、価格含有など）
8. 説明・法的注記の入力
9. 税データの保存

**画面遷移**：税一覧画面から遷移し、保存完了後は税詳細画面へリダイレクトされる。

**権限による表示制御**：ログインユーザーのdefault_company_idに基づいて会社IDが自動設定される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-018 | 税作成 | 主機能 | 新規税データの登録 |
| FN-ACC-017 | 税一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-ACC-020 | 税詳細 | 遷移先機能 | 作成完了後の遷移 |

## 画面種別

登録（Create）

## URL/ルーティング

```
/taxes/create
```

## 画面構成

1. **サブナビゲーション**
   - 位置: トップ（SubNavigationPosition::Top）

2. **基本情報セクション**
   - 税名称
   - 税タイプ
   - 税計算方法
   - 税スコープ
   - ステータス
   - 税額（%）

3. **高度なオプションフィールドセット**
   - 請求書ラベル
   - 税グループ（作成フォーム付き）
   - 国
   - 価格含有設定
   - 基本金額含有
   - 基本影響フラグ

4. **説明・法的注記エリア**
   - 説明（リッチエディタ）
   - 法的注記（リッチエディタ）

## 入出力項目

| No | 項目名 | 物理名 | データ型 | 必須 | 初期値 | バリデーション | 説明 |
|----|--------|--------|----------|------|--------|---------------|------|
| 1 | 税名称 | name | string | ○ | - | 必須 | 税の名称 |
| 2 | 税タイプ | type_tax_use | enum | ○ | - | TypeTaxUse内の値 | 売上/仕入/なし |
| 3 | 税計算方法 | amount_type | enum | ○ | - | AmountType内の値 | 固定/パーセント/グループ |
| 4 | 税スコープ | tax_scope | enum | - | - | TaxScope内の値 | サービス/商品 |
| 5 | ステータス | is_active | boolean | - | - | - | 有効/無効 |
| 6 | 税額 | amount | decimal | ○ | - | 数値、0以上、最大11桁 | 税率（%） |
| 7 | 請求書ラベル | invoice_label | string | - | - | - | 請求書表示名 |
| 8 | 税グループ | tax_group_id | integer | ○ | - | 存在チェック | 税グループ |
| 9 | 国 | country_id | integer | - | - | 存在チェック | 適用国 |
| 10 | 価格含有 | price_include_override | enum | - | default | TaxIncludeOverride内の値 | 価格に税含むか |
| 11 | 基本金額含有 | include_base_amount | boolean | - | false | - | 他税の基本に含むか |
| 12 | 基本影響 | is_base_affected | boolean | - | false | - | 他税の影響を受けるか |
| 13 | 説明 | description | text | - | - | - | 税の説明 |
| 14 | 法的注記 | invoice_legal_notes | text | - | - | - | 請求書の法的注記 |
| 15 | 会社ID | company_id | integer | ○ | ユーザーのdefault_company_id | - | 自動設定 |
| 16 | 作成者ID | creator_id | integer | ○ | ユーザーID | - | 自動設定 |

## 表示項目

該当なし（入力フォーム画面のため）

## イベント仕様

### 1-保存ボタン押下

入力データのバリデーションを実行し、accounts_taxesテーブルにレコードを作成する。作成後、Taxモデルのbootメソッドにより請求書用・返金用の配分レコード（accounts_tax_partition_lines）が自動作成される。保存完了後、税詳細画面へリダイレクトする。

### 2-税グループ作成ボタン押下

インラインで税グループ作成フォームが表示される。TaxGroupResourceのフォームを使用。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_taxes | INSERT | 税レコードの新規作成 |
| 保存ボタン押下（自動） | accounts_tax_partition_lines | INSERT | 請求書用配分レコード作成（2件） |
| 保存ボタン押下（自動） | accounts_tax_partition_lines | INSERT | 返金用配分レコード作成（2件） |

### テーブル別更新項目詳細

#### accounts_taxes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 税名称 |
| INSERT | type_tax_use | フォーム入力値 | 税タイプ |
| INSERT | amount_type | フォーム入力値 | 計算方法 |
| INSERT | tax_scope | フォーム入力値 | 税スコープ |
| INSERT | is_active | フォーム入力値 | ステータス |
| INSERT | amount | フォーム入力値 | 税額 |
| INSERT | tax_group_id | フォーム入力値 | 税グループID |
| INSERT | country_id | フォーム入力値 | 国ID |
| INSERT | company_id | Auth::user()->default_company_id | 自動設定 |
| INSERT | creator_id | Auth::user()->id | 自動設定 |
| INSERT | sort | 自動採番（SortableTrait） | 並び順 |

#### accounts_tax_partition_lines（自動作成）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | tax_id | 作成された税ID | 親税ID |
| INSERT | company_id | 税の会社ID | 会社ID |
| INSERT | repartition_type | BASE / TAX | 配分タイプ |
| INSERT | document_type | INVOICE / REFUND | 伝票タイプ |
| INSERT | factor_percent | null / 100 | 係数（%） |
| INSERT | factor | null / 1 | 係数 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | notification.title | 税作成成功タイトル |
| 2 | 成功 | notification.body | 税作成成功メッセージ本文 |
| 3 | エラー | validation.required | 必須項目エラー |
| 4 | エラー | validation.numeric | 数値形式エラー |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | 必須項目未入力 | バリデーションエラーを表示 |
| 2 | 税グループが存在しない | 選択エラーを表示 |
| 3 | データベース保存エラー | エラーメッセージを表示 |

## 備考

- CreateTaxはCreateRecordを継承している
- SubNavigationPosition::Topでサブナビゲーションをトップに配置
- mutateFormDataBeforeCreateでcompany_idとcreator_idを自動設定
- Taxモデルのbootメソッドにより、作成時にaccounts_tax_partition_linesへ4件（請求書用BASE/TAX、返金用BASE/TAX）の配分レコードが自動作成される
- 税グループはcreateOptionFormでインライン作成可能
- include_base_amountとis_base_affectedはヒントアイコン付きで説明を表示
