# 画面設計書 48-税編集

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「税編集」画面の設計仕様を定義する。

### 本画面の処理概要

税編集画面は、既存の税（Tax）マスタを編集するためのフォーム画面である。税率の変更、設定の更新、ステータスの変更などを行う。

**業務上の目的・背景**：税制改正への対応、税率の変更、設定ミスの修正など、税マスタの編集は継続的なメンテナンスにおいて必要となる。本画面は、既存の税設定を安全に編集するためのインターフェースを提供する。ただし、削除操作は外部キー制約により制限される場合がある。

**画面へのアクセス方法**：税一覧画面または税詳細画面から編集アクションを選択して遷移する。URLパターンは `/taxes/{record}/edit`。サブナビゲーションはトップに配置される。

**主要な操作・処理内容**：
1. 税情報の表示・編集
2. 税率・設定の変更
3. ステータスの変更（有効/無効）
4. 詳細画面への遷移
5. 税レコードの削除（外部キー制約考慮）
6. 変更の保存

**画面遷移**：税一覧画面・詳細画面から遷移し、保存完了後は税詳細画面へリダイレクトされる。

**権限による表示制御**：会社（company_id）によるデータフィルタリングが適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-019 | 税編集 | 主機能 | 税データの編集・更新 |
| FN-ACC-017 | 税一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-ACC-020 | 税詳細 | 遷移先機能 | 保存後の遷移 |

## 画面種別

編集（Edit）

## URL/ルーティング

```
/taxes/{record}/edit
```

## 画面構成

1. **サブナビゲーション**
   - 位置: トップ（SubNavigationPosition::Top）

2. **ヘッダーアクションエリア**
   - 表示ボタン（ViewAction）
   - 削除ボタン（DeleteAction）- 外部キー制約エラー処理付き

3. **基本情報セクション**
   - 税名称
   - 税タイプ
   - 税計算方法
   - 税スコープ
   - ステータス
   - 税額（%）

4. **高度なオプションフィールドセット**
   - 請求書ラベル
   - 税グループ（作成フォーム付き）
   - 国
   - 価格含有設定
   - 基本金額含有
   - 基本影響フラグ

5. **説明・法的注記エリア**
   - 説明（リッチエディタ）
   - 法的注記（リッチエディタ）

## 入出力項目

| No | 項目名 | 物理名 | データ型 | 必須 | 編集可否 | バリデーション | 説明 |
|----|--------|--------|----------|------|----------|---------------|------|
| 1 | 税名称 | name | string | ○ | 可 | 必須 | 税の名称 |
| 2 | 税タイプ | type_tax_use | enum | ○ | 可 | TypeTaxUse内の値 | 売上/仕入/なし |
| 3 | 税計算方法 | amount_type | enum | ○ | 可 | AmountType内の値 | 固定/パーセント/グループ |
| 4 | 税スコープ | tax_scope | enum | - | 可 | TaxScope内の値 | サービス/商品 |
| 5 | ステータス | is_active | boolean | - | 可 | - | 有効/無効 |
| 6 | 税額 | amount | decimal | ○ | 可 | 数値、0以上、最大11桁 | 税率（%） |
| 7 | 請求書ラベル | invoice_label | string | - | 可 | - | 請求書表示名 |
| 8 | 税グループ | tax_group_id | integer | ○ | 可 | 存在チェック | 税グループ |
| 9 | 国 | country_id | integer | - | 可 | 存在チェック | 適用国 |
| 10 | 価格含有 | price_include_override | enum | - | 可 | TaxIncludeOverride内の値 | 価格に税含むか |
| 11 | 基本金額含有 | include_base_amount | boolean | - | 可 | - | 他税の基本に含むか |
| 12 | 基本影響 | is_base_affected | boolean | - | 可 | - | 他税の影響を受けるか |
| 13 | 説明 | description | text | - | 可 | - | 税の説明 |
| 14 | 法的注記 | invoice_legal_notes | text | - | 可 | - | 請求書の法的注記 |

## 表示項目

該当なし（編集フォーム画面のため表示専用項目なし）

## イベント仕様

### 1-保存ボタン押下

入力データのバリデーションを実行し、accounts_taxesテーブルを更新する。保存完了後、税詳細画面へリダイレクトする。

### 2-表示ボタン押下

税詳細画面（ViewTax）へ遷移する。URLは `/taxes/{record}`。

### 3-削除ボタン押下

確認ダイアログを表示後、税レコードを削除する。外部キー制約違反の場合はエラー通知を表示し、削除を中断する。削除成功時は成功通知を表示し、一覧画面へリダイレクト。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_taxes | UPDATE | 税レコードの更新 |
| 削除ボタン押下 | accounts_taxes | DELETE | 税レコードの削除（制約考慮） |

### テーブル別更新項目詳細

#### accounts_taxes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 税名称 |
| UPDATE | type_tax_use | フォーム入力値 | 税タイプ |
| UPDATE | amount_type | フォーム入力値 | 計算方法 |
| UPDATE | tax_scope | フォーム入力値 | 税スコープ |
| UPDATE | is_active | フォーム入力値 | ステータス |
| UPDATE | amount | フォーム入力値 | 税額 |
| UPDATE | tax_group_id | フォーム入力値 | 税グループID |
| UPDATE | country_id | フォーム入力値 | 国ID |
| UPDATE | price_include_override | フォーム入力値 | 価格含有設定 |
| UPDATE | include_base_amount | フォーム入力値 | 基本金額含有 |
| UPDATE | is_base_affected | フォーム入力値 | 基本影響 |
| UPDATE | description | フォーム入力値 | 説明 |
| UPDATE | invoice_legal_notes | フォーム入力値 | 法的注記 |
| UPDATE | updated_at | now() | 更新日時 |
| DELETE | - | id = {record} | 削除時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | notification.title | 税更新成功タイトル |
| 2 | 成功 | notification.body | 税更新成功メッセージ本文 |
| 3 | 成功 | delete.notification.success.title | 削除成功タイトル |
| 4 | 成功 | delete.notification.success.body | 削除成功メッセージ本文 |
| 5 | エラー | delete.notification.error.title | 削除失敗タイトル |
| 6 | エラー | delete.notification.error.body | 削除失敗メッセージ（外部キー制約） |
| 7 | エラー | validation.required | 必須項目エラー |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | レコードが存在しない | 404エラーページを表示 |
| 2 | 必須項目未入力 | バリデーションエラーを表示 |
| 3 | 削除時の外部キー制約違反 | QueryExceptionをキャッチしエラー通知を表示 |
| 4 | データベース更新エラー | エラーメッセージを表示 |

## 備考

- EditTaxはEditRecordを継承している
- SubNavigationPosition::Topでサブナビゲーションをトップに配置
- 削除操作はtry-catchでQueryExceptionをキャッチし、外部キー制約違反時に適切なエラー表示を行う
- 保存後のリダイレクト先は詳細画面
- フォーム構成はTaxResourceのform()メソッドを使用（作成画面と共通）
