# 画面設計書 49-税詳細

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「税詳細」画面の設計仕様を定義する。

### 本画面の処理概要

税詳細画面は、登録済みの税（Tax）マスタの詳細情報を表示するための画面である。

**業務上の目的・背景**：税設定の確認は、会計処理の正確性を担保するために重要である。本画面は、個々の税マスタの全情報を一覧でき、設定内容の確認、編集への遷移、不要な税の削除などの操作を提供する。税率、適用範囲、計算方法などの詳細を確認することで、請求書や仕入伝票への税適用が適切かを検証できる。

**画面へのアクセス方法**：税一覧画面から特定の税レコードを選択するか、税作成・編集完了後に自動リダイレクトされる。URLパターンは `/taxes/{record}`。サブナビゲーションはトップに配置される。

**主要な操作・処理内容**：
1. 税情報の詳細表示（基本情報、高度なオプション、説明・法的注記）
2. 編集画面への遷移
3. 税レコードの削除（外部キー制約考慮）

**画面遷移**：税一覧画面から遷移し、編集アクション実行時は税編集画面へ遷移する。削除後は税一覧画面へ戻る。

**権限による表示制御**：会社（company_id）によるデータフィルタリングが適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-020 | 税詳細 | 主機能 | 税詳細情報の表示 |
| FN-ACC-019 | 税編集 | 遷移先機能 | 編集画面への遷移 |
| FN-ACC-017 | 税一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

```
/taxes/{record}
```

## 画面構成

1. **サブナビゲーション**
   - 位置: トップ（SubNavigationPosition::Top）

2. **ヘッダーアクションエリア**
   - 編集ボタン（EditAction）
   - 削除ボタン（DeleteAction）- 外部キー制約エラー処理付き

3. **基本情報セクション（3カラムグリッド）**
   - 左側グループ（2カラム）：基本情報と説明・法的注記
   - 右側グループ（1カラム）：高度なオプション

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 基本情報セクション

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 税名称 | name | string | テキスト+アイコン | 税の名称 |
| 2 | 税タイプ | type_tax_use | enum | テキスト+アイコン | 売上/仕入/なし |
| 3 | 税計算方法 | amount_type | enum | テキスト+アイコン | 固定/パーセント/グループ |
| 4 | 税スコープ | tax_scope | enum | テキスト+アイコン | サービス/商品 |
| 5 | 税額 | amount | decimal | 数値+%サフィックス+アイコン | 税率（%） |
| 6 | ステータス | is_active | boolean | アイコン | 有効/無効 |

### 説明・法的注記セクション

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 説明 | description | text | Markdown | 税の説明（全幅） |
| 2 | 法的注記 | invoice_legal_notes | text | Markdown | 請求書の法的注記（全幅） |

### 高度なオプションセクション

| No | 項目名 | 物理名 | データ型 | 表示形式 | 説明 |
|----|--------|--------|----------|----------|------|
| 1 | 請求書ラベル | invoice_label | string | テキスト | 請求書表示名 |
| 2 | 税グループ | taxGroup.name | string | テキスト | 税グループ名 |
| 3 | 国 | country.name | string | テキスト | 適用国 |
| 4 | 価格含有 | price_include_override | enum | テキスト | 価格に税含むか |
| 5 | 基本金額含有 | include_base_amount | boolean | アイコン | 他税の基本に含むか |
| 6 | 基本影響 | is_base_affected | boolean | アイコン | 他税の影響を受けるか |

## イベント仕様

### 1-編集ボタン押下

税編集画面（EditTax）へ遷移する。URLは `/taxes/{record}/edit`。

### 2-削除ボタン押下

確認ダイアログを表示後、税レコードを削除する。外部キー制約違反の場合はエラー通知を表示し、削除を中断する。削除成功時は成功通知を表示し、一覧画面へリダイレクト。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | accounts_taxes | SELECT | 税データの取得 |
| 削除ボタン押下 | accounts_taxes | DELETE | 税レコードの削除（制約考慮） |

### テーブル別更新項目詳細

#### accounts_taxes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | id = {record} | 取得条件 |
| DELETE | - | id = {record} | 外部キー制約あり |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | delete.notification.title | 削除成功タイトル |
| 2 | 成功 | delete.notification.body | 削除成功メッセージ本文 |
| 3 | エラー | delete.notification.error.title | 削除失敗タイトル |
| 4 | エラー | delete.notification.error.body | 削除失敗メッセージ（外部キー制約） |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | レコードが存在しない | 404エラーページを表示 |
| 2 | 削除時の外部キー制約違反 | QueryExceptionをキャッチしエラー通知を表示 |

## 備考

- ViewTaxはViewRecordを継承している
- SubNavigationPosition::Topでサブナビゲーションをトップに配置
- 削除操作はtry-catchでQueryExceptionをキャッチし、外部キー制約違反時に適切なエラー表示を行う
- infolistは3カラムグリッドで構成（左2、右1）
- 説明と法的注記はMarkdown形式で表示
- booleanフィールドはIconEntryで表示
