# 画面設計書 5-勘定科目タグ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける勘定科目タグ一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、勘定科目に付与するタグを管理するための画面です。タグの一覧表示、新規作成、編集、削除の機能を提供し、勘定科目の分類・フィルタリングに使用するタグを一元管理します。

**業務上の目的・背景**：勘定科目タグは、勘定科目を独自の基準で分類・グループ化するための仕組みです。タグを活用することで、レポート作成時の絞り込みや、特定の会計処理に関連する勘定科目の一括管理が容易になります。税務申告や内部管理会計など、複数の視点からの勘定科目分類を可能にします。

**画面へのアクセス方法**：会計モジュールの設定メニューから「勘定科目タグ」を選択してアクセスします。

**主要な操作・処理内容**：
1. タグ一覧の表示（色、国、適用範囲、名称、税否定フラグ等）
2. グループ化機能による一覧の分類表示
3. 「新規作成」ボタンからのモーダルでのタグ作成
4. 行アクションからの表示・編集・削除操作
5. 一括削除操作

**画面遷移**：
- 本画面から遷移可能：モーダルでの作成・編集（画面遷移なし）
- 本画面への遷移元：会計モジュール設定メニュー

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみ表示可能です。編集・削除操作は対応する権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-027 | 勘定科目タグ管理 | 主機能 | 勘定科目タグの作成/編集/削除 |

## 画面種別

一覧（管理画面）

## URL/ルーティング

`/accounts/account-tags`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- テーブルエリア：タグ一覧テーブル（グループ化機能付き）
- 行アクション：表示、編集、削除
- 一括操作エリア：一括削除

## 入出力項目

### 新規作成・編集モーダル

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 1 | 色 | color | string | - | なし | タグの表示色 | カラーピッカー（16進数） |
| 2 | 国 | country_id | integer | - | なし | 適用国 | セレクトボックス |
| 3 | 適用範囲 | applicability | enum | ○ | ACCOUNT | 適用対象 | セレクトボックス（Applicability Enum） |
| 4 | 名称 | name | string | ○ | なし | タグ名 | テキスト入力（最大255文字） |
| 5 | 税否定 | tax_negate | boolean | ○ | false | 税否定フラグ | トグルスイッチ |

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | 色 | color | string | タグの表示色 | カラー表示、検索可能 |
| 2 | 国 | country.name | string | 適用国名 | ソート可能 |
| 3 | 作成者 | createdBy.name | string | 作成ユーザー名 | ソート可能 |
| 4 | 適用範囲 | applicability | enum | 適用対象 | 検索可能 |
| 5 | 名称 | name | string | タグ名 | 検索可能 |
| 6 | 税否定 | tax_negate | boolean | 税否定フラグ | アイコン表示 |
| 7 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示、切替可能 |
| 8 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示、切替可能 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、新規作成モーダルが表示されます。モーダル内でフォームを入力し、保存すると新規レコードが作成されます。作成時にログインユーザーIDがcreator_idに設定されます。

### 2-表示アクション

行の表示アクションを選択すると、該当レコードの詳細をモーダルで表示します。

### 3-編集アクション

行の編集アクションを選択すると、該当レコードの編集モーダルが表示されます。保存成功時は通知メッセージが表示されます。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

### 5-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが削除されます。

### 6-グループ化

テーブルはグループ化機能を備えており、以下の項目でグループ化が可能です：
- 国
- 作成者
- 適用範囲
- 名称

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | accounts_account_tags | INSERT | 新規タグレコードを作成 |
| 編集保存 | accounts_account_tags | UPDATE | タグレコードを更新 |
| 削除アクション | accounts_account_tags | DELETE | タグレコードを削除 |
| 一括削除 | accounts_account_tags | DELETE | 複数のタグレコードを削除 |

### テーブル別更新項目詳細

#### accounts_account_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | color | フォーム入力値 | 16進数カラーコード |
| INSERT | country_id | フォーム選択値 | 任意 |
| INSERT | applicability | フォーム選択値 | 必須、Applicability Enum |
| INSERT | name | フォーム入力値 | 必須、最大255文字 |
| INSERT | tax_negate | フォーム入力値 | 必須 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | color, country_id, applicability, name, tax_negate | フォーム入力値 | 各フィールド |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | タグが作成されました | 作成成功時 |
| MSG-002 | 成功 | タグが更新されました | 編集成功時 |
| MSG-003 | 成功 | タグが削除されました | 削除成功時 |
| MSG-004 | 成功 | タグが一括削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | フォームエラー表示 | 必須項目を入力してください |
| 削除失敗（使用中） | エラー通知表示 | このタグは使用中のため削除できません |
| データベースエラー | エラー通知表示 | データの保存に失敗しました |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- 作成・編集はモーダルダイアログで行われ、画面遷移なしで操作できます
- Applicability Enumには「ACCOUNT」（勘定科目用）などの値が定義されています
- テーブル列の表示/非表示は動的に切り替え可能です
- 作成日時・更新日時列はデフォルトで非表示設定されています
- ナビゲーションへの表示は無効化されています（shouldRegisterNavigation = false）
